/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.util;

import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;

public class PortalTools {
    public static final String GROUP = "com.liferay";
    public static final String PORTAL_VERSION_7_0_X = "7.0.x";
    public static final String PORTAL_VERSION_7_1_X = "7.1.x";
    public static final String PORTAL_VERSION_PROPERTY_NAME = "portal.version";
    protected static final String PORTAL_TOOLS_FILE_NAME = "com/liferay/gradle/plugins/dependencies/portal-tools.properties";
    private static final String[] _PORTAL_VERSION_PROPERTY_NAMES = new String[]{"git.working.branch.name", "portal.version"};
    private static final Map<String, Properties> _versionsMap = new HashMap<String, Properties>();

    public static String getPortalVersion(Project project) {
        return PortalTools._getPortalVersion(project);
    }

    public static String getVersion(Project project, String name) {
        return PortalTools._getVersion(project, name, PortalTools._getPortalVersion(project));
    }

    private static String _getPortalVersion(Project project) {
        String name;
        String portalVersion = null;
        String[] stringArray = _PORTAL_VERSION_PROPERTY_NAMES;
        int n = stringArray.length;
        for (int i = 0; i < n && !Validator.isNotNull((String)(portalVersion = GradleUtil.getProperty((ExtensionAware)project, (String)(name = stringArray[i]), (String)null))); ++i) {
        }
        if (portalVersion != null) {
            portalVersion = portalVersion.trim();
            int pos = (portalVersion = portalVersion.toLowerCase()).indexOf(45);
            if (pos != -1) {
                portalVersion = portalVersion.substring(0, pos);
            }
            if (portalVersion.isEmpty() || portalVersion.equals("latest") || portalVersion.equals("master")) {
                portalVersion = null;
            }
        }
        return portalVersion;
    }

    private static String _getVersion(Project project, String name, String portalVersion) {
        Properties properties;
        String key = name + ".version";
        String version = GradleUtil.getProperty((ExtensionAware)project, (String)key, (String)null);
        if (Validator.isNotNull((String)version)) {
            return version;
        }
        for (File dir = project.getProjectDir(); dir != null && Validator.isNull((String)version); dir = dir.getParentFile()) {
            properties = GradleUtil.getGradleProperties((File)dir);
            if (properties == null) continue;
            version = properties.getProperty(key);
        }
        if (Validator.isNotNull((String)version)) {
            return version;
        }
        properties = _versionsMap.get(portalVersion);
        if (properties == null) {
            properties = _versionsMap.get(null);
        }
        return properties.getProperty(name);
    }

    private static Properties _populateVersionsMap(ClassLoader classLoader, String portalVersion, Properties defaultProperties) throws IOException {
        String fileName = PORTAL_TOOLS_FILE_NAME;
        if (portalVersion != null) {
            fileName = fileName.substring(0, fileName.length() - 11) + "-" + portalVersion + ".properties";
        }
        Properties properties = new Properties(defaultProperties);
        try (InputStream inputStream = classLoader.getResourceAsStream(fileName);){
            properties.load(inputStream);
        }
        _versionsMap.put(portalVersion, properties);
        return properties;
    }

    static {
        ClassLoader classLoader = PortalTools.class.getClassLoader();
        try {
            PortalTools._populateVersionsMap(classLoader, null, null);
        }
        catch (IOException ioe) {
            throw new ExceptionInInitializerError(ioe);
        }
    }
}

