/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import aQute.bnd.gradle.BndBuilderPlugin;
import aQute.bnd.gradle.BndUtils;
import aQute.bnd.gradle.BundleTaskConvention;
import aQute.bnd.gradle.PropertiesWrapper;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Processor;
import aQute.bnd.version.MavenVersion;
import aQute.bnd.version.Version;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.service.reporter.Report;
import aQute.service.reporter.Reporter;
import com.liferay.gradle.plugins.JspCDefaultsPlugin;
import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.css.builder.CSSBuilderPlugin;
import com.liferay.gradle.plugins.extensions.BundleExtension;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.extensions.LiferayOSGiExtension;
import com.liferay.gradle.plugins.internal.AlloyTaglibDefaultsPlugin;
import com.liferay.gradle.plugins.internal.CSSBuilderDefaultsPlugin;
import com.liferay.gradle.plugins.internal.DBSupportDefaultsPlugin;
import com.liferay.gradle.plugins.internal.EclipseDefaultsPlugin;
import com.liferay.gradle.plugins.internal.FindBugsDefaultsPlugin;
import com.liferay.gradle.plugins.internal.IdeaDefaultsPlugin;
import com.liferay.gradle.plugins.internal.JSModuleConfigGeneratorDefaultsPlugin;
import com.liferay.gradle.plugins.internal.JavadocFormatterDefaultsPlugin;
import com.liferay.gradle.plugins.internal.RESTBuilderDefaultsPlugin;
import com.liferay.gradle.plugins.internal.ServiceBuilderDefaultsPlugin;
import com.liferay.gradle.plugins.internal.TLDFormatterDefaultsPlugin;
import com.liferay.gradle.plugins.internal.TestIntegrationDefaultsPlugin;
import com.liferay.gradle.plugins.internal.UpgradeTableBuilderDefaultsPlugin;
import com.liferay.gradle.plugins.internal.WSDDBuilderDefaultsPlugin;
import com.liferay.gradle.plugins.internal.WatchOSGiPlugin;
import com.liferay.gradle.plugins.internal.XMLFormatterDefaultsPlugin;
import com.liferay.gradle.plugins.internal.util.FileUtil;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.internal.util.IncludeResourceCompileIncludeInstruction;
import com.liferay.gradle.plugins.internal.util.copy.RenameDependencyAction;
import com.liferay.gradle.plugins.jasper.jspc.JspCPlugin;
import com.liferay.gradle.plugins.javadoc.formatter.JavadocFormatterPlugin;
import com.liferay.gradle.plugins.js.module.config.generator.JSModuleConfigGeneratorPlugin;
import com.liferay.gradle.plugins.js.transpiler.JSTranspilerBasePlugin;
import com.liferay.gradle.plugins.js.transpiler.JSTranspilerPlugin;
import com.liferay.gradle.plugins.lang.builder.LangBuilderPlugin;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.node.tasks.DownloadNodeModuleTask;
import com.liferay.gradle.plugins.node.tasks.NpmInstallTask;
import com.liferay.gradle.plugins.source.formatter.SourceFormatterPlugin;
import com.liferay.gradle.plugins.soy.SoyPlugin;
import com.liferay.gradle.plugins.soy.SoyTranslationPlugin;
import com.liferay.gradle.plugins.soy.tasks.BuildSoyTask;
import com.liferay.gradle.plugins.tasks.DirectDeployTask;
import com.liferay.gradle.plugins.test.integration.TestIntegrationPlugin;
import com.liferay.gradle.plugins.tld.formatter.TLDFormatterPlugin;
import com.liferay.gradle.plugins.tlddoc.builder.TLDDocBuilderPlugin;
import com.liferay.gradle.plugins.util.BndBuilderUtil;
import com.liferay.gradle.plugins.wsdd.builder.BuildWSDDTask;
import com.liferay.gradle.plugins.wsdl.builder.WSDLBuilderPlugin;
import com.liferay.gradle.plugins.xml.formatter.XMLFormatterPlugin;
import com.liferay.gradle.util.StringUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ApplicationPlugin;
import org.gradle.api.plugins.ApplicationPluginConvention;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.Test;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;

public class LiferayOSGiPlugin
implements Plugin<Project> {
    public static final String AUTO_CLEAN_PROPERTY_NAME = "autoClean";
    public static final String AUTO_UPDATE_XML_TASK_NAME = "autoUpdateXml";
    public static final String CLEAN_DEPLOYED_PROPERTY_NAME = "cleanDeployed";
    public static final String COMPILE_INCLUDE_CONFIGURATION_NAME = "compileInclude";
    public static final String DEPLOY_DEPENDENCIES_TASK_NAME = "deployDependencies";
    public static final String DEPLOY_FAST_TASK_NAME = "deployFast";
    public static final String PLUGIN_NAME = "liferayOSGi";
    private static final String _CACHE_PLUGIN_ID = "com.liferay.cache";
    private static final Logger _logger = Logging.getLogger(LiferayOSGiPlugin.class);
    private static final Pattern _keyRegex = Pattern.compile("[a-z][\\p{Alnum}-_.]*");

    public void apply(final Project project) {
        GradleUtil.applyPlugin((Project)project, LiferayBasePlugin.class);
        LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        final LiferayOSGiExtension liferayOSGiExtension = (LiferayOSGiExtension)GradleUtil.addExtension((ExtensionAware)project, (String)PLUGIN_NAME, LiferayOSGiExtension.class);
        this._applyPlugins(project);
        this._addDeployedFile(project, liferayExtension, "jar", false);
        final Configuration compileIncludeConfiguration = this._addConfigurationCompileInclude(project);
        this._addTaskAutoUpdateXml(project);
        this._addTaskDeployFast(project, liferayExtension);
        this._addTasksBuildWSDDJar(project, liferayExtension);
        Copy deployDependenciesTask = this._addTaskDeployDependencies(project, liferayExtension);
        this._configureArchivesBaseName(project);
        this._configureDescription(project);
        this._configureLiferay(project, liferayExtension);
        this._configureSourceSetMain(project);
        this._configureTaskClean(project);
        this._configureTaskDeploy(project, deployDependenciesTask);
        this._configureTaskJar(project);
        this._configureTaskJavadoc(project);
        this._configureTaskTest(project);
        this._configureTasksTest(project);
        if (GradleUtil.isRunningInsideDaemon()) {
            this._configureTasksJavaCompileFork(project, true);
        }
        this._configureVersion(project);
        GradleUtil.withPlugin(project, ApplicationPlugin.class, new Action<ApplicationPlugin>(){

            public void execute(ApplicationPlugin applicationPlugin) {
                LiferayOSGiPlugin.this._configureApplication(project);
                LiferayOSGiPlugin.this._configureTaskRun(project, compileIncludeConfiguration);
            }
        });
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                LiferayOSGiPlugin.this._configureBundleExtensionDefaults(project, liferayOSGiExtension, compileIncludeConfiguration);
            }
        });
    }

    private Configuration _addConfigurationCompileInclude(Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)COMPILE_INCLUDE_CONFIGURATION_NAME);
        configuration.setDescription("Additional dependencies to include in the final JAR.");
        configuration.setVisible(false);
        Configuration compileOnlyConfiguration = GradleUtil.getConfiguration((Project)project, (String)"compileOnly");
        compileOnlyConfiguration.extendsFrom(new Configuration[]{configuration});
        return configuration;
    }

    private void _addDeployedFile(final LiferayExtension liferayExtension, final AbstractArchiveTask abstractArchiveTask, boolean lazy) {
        final Project project = abstractArchiveTask.getProject();
        Task task = GradleUtil.getTask((Project)project, (String)"deploy");
        if (!(task instanceof Copy)) {
            return;
        }
        final Copy copy = (Copy)task;
        Object sourcePath = abstractArchiveTask;
        if (lazy) {
            sourcePath = new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return abstractArchiveTask.getArchivePath();
                }
            };
        }
        copy.from(sourcePath, (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                copySpec.rename((Closure)new Closure<String>((Object)project){

                    public String doCall(String fileName) {
                        Closure<String> deployedFileNameClosure = liferayExtension.getDeployedFileNameClosure();
                        return (String)deployedFileNameClosure.call((Object)abstractArchiveTask);
                    }
                });
            }
        });
        final Delete delete = (Delete)GradleUtil.getTask((Project)project, (String)"clean");
        delete.delete(new Object[]{new Callable<File>(){

            @Override
            public File call() throws Exception {
                boolean cleanDeployed = GradleUtil.getProperty((ExtensionAware)delete, (String)LiferayOSGiPlugin.CLEAN_DEPLOYED_PROPERTY_NAME, (boolean)true);
                if (!cleanDeployed) {
                    return null;
                }
                Closure<String> deployedFileNameClosure = liferayExtension.getDeployedFileNameClosure();
                return new File(copy.getDestinationDir(), (String)deployedFileNameClosure.call((Object)abstractArchiveTask));
            }
        }});
    }

    private void _addDeployedFile(Project project, LiferayExtension liferayExtension, String taskName, boolean lazy) {
        AbstractArchiveTask abstractArchiveTask = (AbstractArchiveTask)GradleUtil.getTask((Project)project, (String)taskName);
        this._addDeployedFile(liferayExtension, abstractArchiveTask, lazy);
    }

    private DirectDeployTask _addTaskAutoUpdateXml(final Project project) {
        final DirectDeployTask directDeployTask = (DirectDeployTask)GradleUtil.addTask((Project)project, (String)AUTO_UPDATE_XML_TASK_NAME, DirectDeployTask.class);
        directDeployTask.setAppServerDeployDir(directDeployTask.getTemporaryDir());
        directDeployTask.setAppServerType("tomcat");
        directDeployTask.setWebAppFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
                return FileUtil.replaceExtension((File)jar.getArchivePath(), (String)"war");
            }
        });
        directDeployTask.setWebAppType("portlet");
        directDeployTask.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                DirectDeployTask directDeployTask = (DirectDeployTask)task;
                Jar jar = (Jar)GradleUtil.getTask((Project)directDeployTask.getProject(), (String)"jar");
                File jarFile = jar.getArchivePath();
                jarFile.renameTo(directDeployTask.getWebAppFile());
            }
        });
        directDeployTask.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Logger logger = task.getLogger();
                Project project = task.getProject();
                project.delete(new Object[]{"liferay/logs"});
                File liferayDir = project.file((Object)"liferay");
                boolean deleted = liferayDir.delete();
                if (!deleted && logger.isInfoEnabled()) {
                    logger.info("Unable to delete " + liferayDir);
                }
            }
        });
        directDeployTask.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                DirectDeployTask directDeployTask = (DirectDeployTask)task;
                Project project = directDeployTask.getProject();
                Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
                String deployedPluginDirName = FileUtil.stripExtension((String)jar.getArchiveName());
                File deployedPluginDir = new File(directDeployTask.getAppServerDeployDir(), deployedPluginDirName);
                if (!deployedPluginDir.exists()) {
                    deployedPluginDir = new File(directDeployTask.getAppServerDeployDir(), project.getName());
                }
                if (!deployedPluginDir.exists()) {
                    _logger.warn("Unable to automatically update web.xml in " + jar.getArchivePath());
                    return;
                }
                FileUtil.touchFiles(project, deployedPluginDir, 0L, "WEB-INF/liferay-web.xml", "WEB-INF/web.xml", "WEB-INF/tld/*");
                deployedPluginDirName = project.relativePath((Object)deployedPluginDir);
                LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
                String[][] filesets = new String[][]{{project.relativePath((Object)liferayExtension.getAppServerPortalDir()), "WEB-INF/tld/c.tld"}, {deployedPluginDirName, "WEB-INF/liferay-web.xml,WEB-INF/web.xml"}, {deployedPluginDirName, "WEB-INF/tld/*"}};
                File warFile = directDeployTask.getWebAppFile();
                FileUtil.jar((Project)project, (File)warFile, (String)"preserve", (boolean)true, (String[][])filesets);
                warFile.renameTo(jar.getArchivePath());
            }
        });
        directDeployTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                Project project = task.getProject();
                LiferayOSGiExtension liferayOSGiExtension = (LiferayOSGiExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayOSGiExtension.class);
                return liferayOSGiExtension.isAutoUpdateXml() && FileUtil.exists((Project)project, (String)"docroot/WEB-INF/portlet.xml");
            }
        });
        TaskInputsInternal taskInputs = directDeployTask.getInputs();
        taskInputs.file((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
                return jar.getArchivePath();
            }
        });
        Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
        jar.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                directDeployTask.execute();
            }
        });
        return directDeployTask;
    }

    private Jar _addTaskBuildWSDDJar(final BuildWSDDTask buildWSDDTask, LiferayExtension liferayExtension) {
        Project project = buildWSDDTask.getProject();
        Jar jar = (Jar)GradleUtil.addTask((Project)project, (String)(buildWSDDTask.getName() + "Jar"), Jar.class);
        jar.setActions(Collections.emptyList());
        jar.dependsOn(new Object[]{buildWSDDTask});
        jar.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                Logger logger = project.getLogger();
                PropertiesWrapper gradleProperties = new PropertiesWrapper();
                gradleProperties.put("project", project);
                gradleProperties.put("task", task);
                try (Builder builder = new Builder(new Processor((Properties)gradleProperties, false));){
                    String bundleVersion;
                    String bundleSymbolicName;
                    Map<String, String> properties = this._getProperties(project);
                    File buildFile = project.getBuildFile();
                    builder.setBase(buildFile.getParentFile());
                    builder.putAll(properties, true);
                    SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
                    SourceDirectorySet sourceDirectorySet = sourceSet.getJava();
                    SourceSetOutput sourceSetOutput = sourceSet.getOutput();
                    ConfigurableFileCollection buildDirs = project.files(new Object[]{sourceDirectorySet.getOutputDir(), sourceSetOutput.getResourcesDir()});
                    builder.setClasspath(buildDirs.getFiles().toArray(new File[0]));
                    builder.setProperty("project.buildpath", buildDirs.getAsPath());
                    if (logger.isDebugEnabled()) {
                        logger.debug("Builder Classpath: {}", (Object)buildDirs.getAsPath());
                    }
                    SourceDirectorySet allSource = sourceSet.getAllSource();
                    Set srcDirs = allSource.getSrcDirs();
                    Stream stream = srcDirs.stream();
                    ConfigurableFileCollection sourceDirs = project.files(new Object[]{stream.filter(File::exists).collect(Collectors.toList())});
                    builder.setProperty("project.sourcepath", sourceDirs.getAsPath());
                    builder.setSourcepath(sourceDirs.getFiles().toArray(new File[0]));
                    if (logger.isDebugEnabled()) {
                        logger.debug("Builder Sourcepath: {}", (Object)builder.getSourcePath());
                    }
                    if (Validator.isNull((String)(bundleSymbolicName = builder.getProperty("Bundle-SymbolicName"))) || "<<EMPTY>>".equals(bundleSymbolicName)) {
                        builder.setProperty("Bundle-SymbolicName", project.getName());
                    }
                    if ((Validator.isNull((String)(bundleVersion = builder.getProperty("Bundle-Version"))) || "<<EMPTY>>".equals(bundleVersion)) && project.getVersion() != null) {
                        Object version = project.getVersion();
                        MavenVersion mavenVersion = MavenVersion.parseString((String)version.toString());
                        Version osgiVersion = mavenVersion.getOSGiVersion();
                        builder.setProperty("Bundle-Version", osgiVersion.toString());
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Builder Properties: {}", properties);
                    }
                    aQute.bnd.osgi.Jar bndJar = builder.build();
                    if (!builder.isOk()) {
                        BndUtils.logReport((Report)builder, (Logger)logger);
                        new GradleException(buildWSDDTask + " failed");
                    }
                    TaskOutputs taskOutputs = task.getOutputs();
                    FileCollection fileCollection = taskOutputs.getFiles();
                    bndJar.write(fileCollection.getSingleFile());
                    BndUtils.logReport((Report)builder, (Logger)logger);
                    if (!builder.isOk()) {
                        new GradleException(buildWSDDTask + " failed");
                    }
                }
                catch (Exception e) {
                    new GradleException(buildWSDDTask + " failed", (Throwable)e);
                }
            }

            private Map<String, String> _getProperties(Project project) {
                LiferayOSGiExtension liferayOSGiExtension = (LiferayOSGiExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayOSGiExtension.class);
                Map<String, String> properties = GradleUtil.toStringMap(liferayOSGiExtension.getBundleDefaultInstructions());
                Map projectProperties = project.getProperties();
                for (Map.Entry entry : projectProperties.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!Character.isLowerCase(key.charAt(0))) continue;
                    properties.put(key, GradleUtil.toString(entry.getValue()));
                }
                properties.remove("-donotcopy");
                properties.remove("-liferay-service-xml");
                String bundleName = BndBuilderUtil.getInstruction(project, "Bundle-Name");
                if (Validator.isNotNull((String)bundleName)) {
                    properties.put("Bundle-Name", bundleName + " WSDD descriptors");
                }
                String bundleSymbolicName = BndBuilderUtil.getInstruction(project, "Bundle-SymbolicName");
                properties.put("Bundle-SymbolicName", bundleSymbolicName + ".wsdd");
                properties.put("Fragment-Host", bundleSymbolicName);
                properties.put("Import-Package", "javax.servlet,javax.servlet.http");
                StringBuilder sb = new StringBuilder();
                sb.append("WEB-INF/=");
                sb.append(FileUtil.getRelativePath(project, buildWSDDTask.getServerConfigFile()));
                sb.append(',');
                sb.append(FileUtil.getRelativePath(project, buildWSDDTask.getOutputDir()));
                sb.append(";filter:=*.wsdd");
                properties.put("Include-Resource", sb.toString());
                return properties;
            }
        });
        String taskName = buildWSDDTask.getName();
        if (taskName.equals("buildWSDD")) {
            jar.setAppendix("wsdd");
        } else {
            jar.setAppendix("wsdd-" + taskName);
        }
        buildWSDDTask.finalizedBy(new Object[]{jar});
        this._addDeployedFile(liferayExtension, (AbstractArchiveTask)jar, true);
        return jar;
    }

    private Copy _addTaskDeployDependencies(Project project, final LiferayExtension liferayExtension) {
        final Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)DEPLOY_DEPENDENCIES_TASK_NAME, Copy.class);
        final boolean keepVersions = Boolean.getBoolean("deploy.dependencies.keep.versions");
        GradleUtil.setProperty((ExtensionAware)copy, (String)AUTO_CLEAN_PROPERTY_NAME, (Object)false);
        GradleUtil.setProperty((ExtensionAware)copy, (String)"keepVersions", (Object)keepVersions);
        String renameSuffix = ".jar";
        if (keepVersions) {
            renameSuffix = "-$1.jar";
        }
        GradleUtil.setProperty((ExtensionAware)copy, (String)"renameSuffix", (Object)renameSuffix);
        copy.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return liferayExtension.getDeployDir();
            }
        });
        copy.setDescription("Deploys additional dependencies.");
        TaskOutputsInternal taskOutputs = copy.getOutputs();
        taskOutputs.upToDateWhen((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return false;
            }
        });
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                copy.eachFile((Action)new RenameDependencyAction(keepVersions));
            }
        });
        return copy;
    }

    private Copy _addTaskDeployFast(Project project, LiferayExtension liferayExtension) {
        Copy deployFastTask = (Copy)GradleUtil.addTask((Project)project, (String)DEPLOY_FAST_TASK_NAME, Copy.class);
        deployFastTask.setDescription("Builds and deploys resources to the Liferay work directory.");
        deployFastTask.setGroup("build");
        deployFastTask.setDestinationDir(liferayExtension.getLiferayHome());
        deployFastTask.setIncludeEmptyDirs(false);
        String bundleSymbolicName = BndBuilderUtil.getInstruction(project, "Bundle-SymbolicName");
        String bundleVersion = BndBuilderUtil.getInstruction(project, "Bundle-Version");
        StringBuilder sb = new StringBuilder();
        sb.append("work/");
        sb.append(bundleSymbolicName);
        sb.append("-");
        sb.append(bundleVersion);
        final String pathName = sb.toString();
        deployFastTask.from((Object)GradleUtil.getTask((Project)project, (String)"compileJSP"), (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                copySpec.into((Object)pathName);
            }
        });
        deployFastTask.from((Object)GradleUtil.getTask((Project)project, (String)"processResources"), (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                copySpec.eachFile((Action)new Action<FileCopyDetails>(){

                    public void execute(FileCopyDetails fileCopyDetails) {
                        RelativePath relativePath = fileCopyDetails.getRelativePath();
                        String[] segments = relativePath.getSegments();
                        if (segments.length > 4 && segments[2].equals("META-INF") && segments[3].equals("resources")) {
                            ArrayList<String> list = new ArrayList<String>();
                            list.add(segments[0]);
                            list.add(segments[1]);
                            for (int i = 4; i < segments.length; ++i) {
                                String segment = segments[i];
                                if (segment.equals(".sass-cache")) continue;
                                list.add(segment);
                            }
                            segments = list.toArray(new String[0]);
                        }
                        fileCopyDetails.setRelativePath(new RelativePath(true, segments));
                    }
                });
                copySpec.include(new String[]{"**/*.css"});
                copySpec.into((Object)pathName);
            }
        });
        return deployFastTask;
    }

    private void _addTasksBuildWSDDJar(Project project, final LiferayExtension liferayExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildWSDDTask.class, (Action)new Action<BuildWSDDTask>(){

            public void execute(BuildWSDDTask buildWSDDTask) {
                LiferayOSGiPlugin.this._addTaskBuildWSDDJar(buildWSDDTask, liferayExtension);
            }
        });
    }

    private void _applyPlugins(Project project) {
        GradleUtil.applyPlugin((Project)project, BndBuilderPlugin.class);
        this._configureBundleExtension(project);
        GradleUtil.applyPlugin((Project)project, JavaPlugin.class);
        GradleUtil.applyPlugin((Project)project, CSSBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, NodePlugin.class);
        if (GradleUtil.hasTask(project, "packageRunBuild")) {
            GradleUtil.applyPlugin((Project)project, JSTranspilerBasePlugin.class);
        } else {
            GradleUtil.applyPlugin((Project)project, JSModuleConfigGeneratorPlugin.class);
            GradleUtil.applyPlugin((Project)project, JSTranspilerPlugin.class);
        }
        GradleUtil.applyPlugin((Project)project, EclipsePlugin.class);
        GradleUtil.applyPlugin((Project)project, JavadocFormatterPlugin.class);
        GradleUtil.applyPlugin((Project)project, JspCPlugin.class);
        GradleUtil.applyPlugin((Project)project, LangBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, SourceFormatterPlugin.class);
        GradleUtil.applyPlugin((Project)project, SoyPlugin.class);
        GradleUtil.applyPlugin((Project)project, SoyTranslationPlugin.class);
        GradleUtil.applyPlugin((Project)project, TLDDocBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, TLDFormatterPlugin.class);
        GradleUtil.applyPlugin((Project)project, TestIntegrationPlugin.class);
        GradleUtil.applyPlugin((Project)project, XMLFormatterPlugin.class);
        AlloyTaglibDefaultsPlugin.INSTANCE.apply((Object)project);
        CSSBuilderDefaultsPlugin.INSTANCE.apply((Object)project);
        DBSupportDefaultsPlugin.INSTANCE.apply((Object)project);
        EclipseDefaultsPlugin.INSTANCE.apply((Object)project);
        FindBugsDefaultsPlugin.INSTANCE.apply((Object)project);
        IdeaDefaultsPlugin.INSTANCE.apply((Object)project);
        JSModuleConfigGeneratorDefaultsPlugin.INSTANCE.apply((Object)project);
        JavadocFormatterDefaultsPlugin.INSTANCE.apply((Object)project);
        JspCDefaultsPlugin.INSTANCE.apply((Object)project);
        RESTBuilderDefaultsPlugin.INSTANCE.apply((Object)project);
        ServiceBuilderDefaultsPlugin.INSTANCE.apply((Object)project);
        TLDFormatterDefaultsPlugin.INSTANCE.apply((Object)project);
        TestIntegrationDefaultsPlugin.INSTANCE.apply((Object)project);
        UpgradeTableBuilderDefaultsPlugin.INSTANCE.apply((Object)project);
        WSDDBuilderDefaultsPlugin.INSTANCE.apply((Object)project);
        WatchOSGiPlugin.INSTANCE.apply((Object)project);
        XMLFormatterDefaultsPlugin.INSTANCE.apply((Object)project);
    }

    private void _configureApplication(Project project) {
        ApplicationPluginConvention applicationPluginConvention = (ApplicationPluginConvention)GradleUtil.getConvention((Project)project, ApplicationPluginConvention.class);
        String mainClassName = BndBuilderUtil.getInstruction(project, "Main-Class");
        if (Validator.isNotNull((String)mainClassName)) {
            applicationPluginConvention.setMainClassName(mainClassName);
        }
    }

    private void _configureArchivesBaseName(Project project) {
        BasePluginConvention basePluginConvention = (BasePluginConvention)GradleUtil.getConvention((Project)project, BasePluginConvention.class);
        String bundleSymbolicName = BndBuilderUtil.getInstruction(project, "Bundle-SymbolicName");
        if (Validator.isNull((String)bundleSymbolicName)) {
            return;
        }
        Parameters parameters = new Parameters(bundleSymbolicName);
        Set keys = parameters.keySet();
        Iterator iterator = keys.iterator();
        bundleSymbolicName = (String)iterator.next();
        basePluginConvention.setArchivesBaseName(bundleSymbolicName);
    }

    private void _configureBundleExtension(Project project) {
        BundleExtension bundleExtension = new BundleExtension();
        ExtensionContainer extensionContainer = project.getExtensions();
        extensionContainer.add(BundleExtension.class, "bundle", (Object)bundleExtension);
        File file = project.file((Object)"bnd.bnd");
        if (file.exists()) {
            UTF8Properties utf8Properties = new UTF8Properties();
            try (Processor processor = new Processor();){
                utf8Properties.load(file, (Reporter)processor);
                Enumeration keys = utf8Properties.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = utf8Properties.getProperty(key);
                    bundleExtension.put(key, (Object)value);
                }
            }
            catch (Exception e) {
                throw new GradleException("Could not read " + file, (Throwable)e);
            }
        }
    }

    private void _configureBundleExtensionDefaults(Project project, final LiferayOSGiExtension liferayOSGiExtension, final Configuration compileIncludeConfiguration) {
        BundleExtension bundleInstructions = BndBuilderUtil.getInstructions(project);
        IncludeResourceCompileIncludeInstruction includeResourceCompileIncludeInstruction = new IncludeResourceCompileIncludeInstruction(new Callable<Iterable<File>>(){

            @Override
            public Iterable<File> call() throws Exception {
                return compileIncludeConfiguration;
            }
        }, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return liferayOSGiExtension.isExpandCompileInclude();
            }
        });
        bundleInstructions.put("-includeresource." + compileIncludeConfiguration.getName(), includeResourceCompileIncludeInstruction);
        Map<String, Object> bundleDefaultInstructions = liferayOSGiExtension.getBundleDefaultInstructions();
        for (Map.Entry<String, Object> entry : bundleDefaultInstructions.entrySet()) {
            String key = entry.getKey();
            if (bundleInstructions.containsKey(key)) continue;
            bundleInstructions.put(key, entry.getValue());
        }
    }

    private void _configureDescription(Project project) {
        String description = BndBuilderUtil.getInstruction(project, "Bundle-Description");
        if (Validator.isNull((String)description)) {
            description = BndBuilderUtil.getInstruction(project, "Bundle-Name");
        }
        if (Validator.isNotNull((String)description)) {
            project.setDescription(description);
        }
    }

    private void _configureLiferay(final Project project, final LiferayExtension liferayExtension) {
        liferayExtension.setDeployDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                File dir = new File(liferayExtension.getAppServerParentDir(), "osgi/modules");
                return GradleUtil.getProperty((Project)project, (String)"auto.deploy.dir", (File)dir);
            }
        });
    }

    private void _configureSourceSetMain(Project project) {
        File docrootDir = project.file((Object)"docroot");
        if (!docrootDir.exists()) {
            return;
        }
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        File javaClassesDir = new File(docrootDir, "WEB-INF/classes");
        SourceDirectorySet javaSourceDirectorySet = sourceSet.getJava();
        javaSourceDirectorySet.setOutputDir(javaClassesDir);
        SourceSetOutput sourceSetOutput = sourceSet.getOutput();
        sourceSetOutput.setResourcesDir(javaClassesDir);
        File srcDir = new File(docrootDir, "WEB-INF/src");
        Set<File> srcDirs = Collections.singleton(srcDir);
        javaSourceDirectorySet.setSrcDirs(srcDirs);
        SourceDirectorySet resourcesSourceDirectorySet = sourceSet.getResources();
        resourcesSourceDirectorySet.setSrcDirs(srcDirs);
    }

    private void _configureTaskClean(Project project) {
        Task task = GradleUtil.getTask((Project)project, (String)"clean");
        if (task instanceof Delete) {
            this._configureTaskCleanDependsOn((Delete)task);
        }
    }

    private void _configureTaskCleanDependsOn(Delete delete) {
        Project project = delete.getProject();
        Closure<Set<String>> closure = new Closure<Set<String>>((Object)project){

            public Set<String> doCall(Delete delete) {
                HashSet<String> cleanTaskNames = new HashSet<String>();
                Project project = delete.getProject();
                for (Task task : project.getTasks()) {
                    TaskOutputs taskOutputs;
                    boolean autoClean;
                    String taskName = task.getName();
                    if (taskName.equals(LiferayOSGiPlugin.DEPLOY_FAST_TASK_NAME) || taskName.equals("deploy") || taskName.equals("eclipseClasspath") || taskName.equals("eclipseProject") || taskName.equals("ideaModule") || task instanceof BuildSoyTask || task instanceof DownloadNodeModuleTask || task instanceof NpmInstallTask || GradleUtil.hasPlugin(project, LiferayOSGiPlugin._CACHE_PLUGIN_ID) && taskName.startsWith("save") && taskName.endsWith("Cache") || GradleUtil.hasPlugin(project, WSDLBuilderPlugin.class) && taskName.startsWith("buildWSDLGenerate") || !(autoClean = GradleUtil.getProperty((ExtensionAware)task, (String)LiferayOSGiPlugin.AUTO_CLEAN_PROPERTY_NAME, (boolean)true)) || !(taskOutputs = task.getOutputs()).getHasOutput()) continue;
                    cleanTaskNames.add("clean" + StringUtil.capitalize((String)taskName));
                }
                return cleanTaskNames;
            }
        };
        delete.dependsOn(new Object[]{closure});
    }

    private void _configureTaskDeploy(Project project, Copy deployDepenciesTask) {
        Task deployTask = GradleUtil.getTask((Project)project, (String)"deploy");
        deployTask.finalizedBy(new Object[]{deployDepenciesTask});
    }

    private void _configureTaskJar(final Project project) {
        final Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
        jar.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                BundleExtension instructions = BndBuilderUtil.getInstructions(project);
                instructions.forEach((k, v) -> instructions.put(k, GradleUtil.toString((Object)v)));
                Map projectProperties = project.getProperties();
                for (Map.Entry entry : projectProperties.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    Matcher matcher = _keyRegex.matcher(key);
                    if (!matcher.matches() || !(value instanceof String)) continue;
                    instructions.put(key, entry.getValue());
                }
                Convention convention = jar.getConvention();
                BundleTaskConvention bundleTaskConvention = (BundleTaskConvention)convention.getPlugin(BundleTaskConvention.class);
                bundleTaskConvention.setBndfile((Object)new File("$$$DOESNOTEXIST$$$"));
                bundleTaskConvention.setBnd((Map)instructions);
            }
        });
        File bndFile = project.file((Object)"bnd.bnd");
        if (!bndFile.exists()) {
            return;
        }
        TaskInputsInternal taskInputs = jar.getInputs();
        taskInputs.file((Object)bndFile);
    }

    private void _configureTaskJavaCompileFork(JavaCompile javaCompile, boolean fork) {
        CompileOptions compileOptions = javaCompile.getOptions();
        compileOptions.setFork(fork);
    }

    private void _configureTaskJavadoc(Project project) {
        String bundleName = BndBuilderUtil.getInstruction(project, "Bundle-Name");
        String bundleVersion = BndBuilderUtil.getInstruction(project, "Bundle-Version");
        if (Validator.isNull((String)bundleName) || Validator.isNull((String)bundleVersion)) {
            return;
        }
        Javadoc javadoc = (Javadoc)GradleUtil.getTask((Project)project, (String)"javadoc");
        String title = String.format("%s %s API", bundleName, bundleVersion);
        javadoc.setTitle(title);
    }

    private void _configureTaskRun(Project project, Configuration compileIncludeConfiguration) {
        JavaExec javaExec = (JavaExec)GradleUtil.getTask((Project)project, (String)"run");
        javaExec.classpath(new Object[]{compileIncludeConfiguration});
    }

    private void _configureTasksJavaCompileFork(Project project, final boolean fork) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(JavaCompile.class, (Action)new Action<JavaCompile>(){

            public void execute(JavaCompile javaCompile) {
                LiferayOSGiPlugin.this._configureTaskJavaCompileFork(javaCompile, fork);
            }
        });
    }

    private void _configureTasksTest(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(Test.class, (Action)new Action<Test>(){

            public void execute(Test test) {
                LiferayOSGiPlugin.this._configureTaskTestDefaultCharacterEncoding(test);
            }
        });
    }

    private void _configureTaskTest(Project project) {
        final Test test = (Test)GradleUtil.getTask((Project)project, (String)"test");
        test.jvmArgs(new Object[]{"-Djava.net.preferIPv4Stack=true", "-Dliferay.mode=test", "-Duser.timezone=GMT"});
        test.setForkEvery(Long.valueOf(1L));
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                LiferayOSGiPlugin.this._configureTaskTestIncludes(test);
            }
        });
    }

    private void _configureTaskTestDefaultCharacterEncoding(Test test) {
        test.setDefaultCharacterEncoding(StandardCharsets.UTF_8.name());
    }

    private void _configureTaskTestIncludes(Test test) {
        Set includes = test.getIncludes();
        if (includes.isEmpty()) {
            test.setIncludes(Collections.singleton("**/*Test.class"));
        }
    }

    private void _configureVersion(Project project) {
        String bundleVersion = BndBuilderUtil.getInstruction(project, "Bundle-Version");
        if (Validator.isNotNull((String)bundleVersion)) {
            project.setVersion((Object)bundleVersion);
        }
    }
}

