/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.internal;

import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.internal.util.IncludeResourceCompileIncludeInstruction;
import com.liferay.gradle.plugins.tasks.ExecuteBndTask;
import com.liferay.gradle.plugins.tasks.WatchTask;
import com.liferay.gradle.plugins.util.BndBuilderUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.concurrent.Callable;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.bundling.Jar;

public class WatchOSGiPlugin
implements Plugin<Project> {
    public static final String BUILD_BUNDLE_DIR_TASK_NAME = "buildBundleDir";
    public static final Plugin<Project> INSTANCE = new WatchOSGiPlugin();
    public static final String JAR_COMPILE_INCLUDE_FRAGMENT_TASK_NAME = "jarCompileIncludeFragment";
    public static final String WATCH_TASK_NAME = "watch";

    public void apply(Project project) {
        ExecuteBndTask jarCompileIncludeFragmentTask = this._addTaskJarCompileIncludeFragment(project);
        Sync buildBundleDirTask = this._addTaskBuildBundleDir(project);
        this._addTaskWatch(buildBundleDirTask, jarCompileIncludeFragmentTask);
    }

    private WatchOSGiPlugin() {
    }

    private Sync _addTaskBuildBundleDir(final Project project) {
        Sync sync = (Sync)GradleUtil.addTask((Project)project, (String)BUILD_BUNDLE_DIR_TASK_NAME, Sync.class);
        final Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
        sync.dependsOn(new Object[]{jar});
        sync.from(new Object[]{new Callable<FileTree>(){

            @Override
            public FileTree call() throws Exception {
                return project.zipTree((Object)jar.getArchivePath());
            }
        }});
        sync.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(project.getBuildDir(), WatchOSGiPlugin.BUILD_BUNDLE_DIR_TASK_NAME);
            }
        });
        sync.setDescription("Unzips the project's JAR file into a temporary directory.");
        return sync;
    }

    private ExecuteBndTask _addTaskJarCompileIncludeFragment(final Project project) {
        ExecuteBndTask executeBndTask = (ExecuteBndTask)GradleUtil.addTask((Project)project, (String)JAR_COMPILE_INCLUDE_FRAGMENT_TASK_NAME, ExecuteBndTask.class);
        executeBndTask.property("Bundle-Name", new Callable<String>(){

            @Override
            public String call() throws Exception {
                return BndBuilderUtil.getInstruction(project, "Bundle-Name") + " Libs";
            }
        });
        executeBndTask.property("Bundle-SymbolicName", new Callable<String>(){

            @Override
            public String call() throws Exception {
                return BndBuilderUtil.getInstruction(project, "Bundle-SymbolicName") + ".libs";
            }
        });
        executeBndTask.property("Bundle-Version", "1.0.0");
        executeBndTask.property("Fragment-Host", new Callable<String>(){

            @Override
            public String call() throws Exception {
                return BndBuilderUtil.getInstruction(project, "Bundle-SymbolicName");
            }
        });
        executeBndTask.property("-includeresource", new IncludeResourceCompileIncludeInstruction(new Callable<Iterable<File>>(){

            @Override
            public Iterable<File> call() throws Exception {
                return GradleUtil.getConfiguration((Project)project, (String)"compileInclude");
            }
        }, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return Boolean.FALSE;
            }
        }));
        executeBndTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"compileInclude");
                return !configuration.isEmpty();
            }
        });
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        executeBndTask.setClasspath(sourceSet.getCompileClasspath());
        executeBndTask.setDescription("Generates an OSGi fragment containing all dependencies of compileInclude.");
        executeBndTask.setGroup("build");
        executeBndTask.setOutputFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(project.getBuildDir(), project.getName() + "-libs." + "jar");
            }
        });
        executeBndTask.setResourceDirs((FileCollection)project.files(new Object[0]));
        executeBndTask.setSourceDirs((FileCollection)project.files(new Object[0]));
        return executeBndTask;
    }

    private WatchTask _addTaskWatch(final Sync buildBundleDirTask, ExecuteBndTask jarCompileIncludeFragmentTask) {
        WatchTask watchTask = (WatchTask)GradleUtil.addTask((Project)buildBundleDirTask.getProject(), (String)WATCH_TASK_NAME, WatchTask.class);
        watchTask.dependsOn(new Object[]{buildBundleDirTask});
        watchTask.setBundleDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return buildBundleDirTask.getDestinationDir();
            }
        });
        watchTask.setBundleSymbolicName(new Callable<String>(){

            @Override
            public String call() throws Exception {
                File manifestFile = new File(buildBundleDirTask.getDestinationDir(), "META-INF/MANIFEST.MF");
                if (manifestFile.exists()) {
                    try (FileInputStream fileInputStream = new FileInputStream(manifestFile);){
                        Manifest manifest = new Manifest(fileInputStream);
                        Attributes attributes = manifest.getMainAttributes();
                        String string = attributes.getValue("Bundle-SymbolicName");
                        return string;
                    }
                }
                return null;
            }
        });
        watchTask.setDescription("Continuously redeploys the project's OSGi bundle.");
        watchTask.setGroup("build");
        TaskOutputsInternal taskOutputs = jarCompileIncludeFragmentTask.getOutputs();
        watchTask.setFragments(taskOutputs.getFiles());
        return watchTask;
    }
}

