/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.internal;

import com.liferay.gradle.plugins.BasePortalToolDefaultsPlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.internal.util.FileUtil;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.jasper.jspc.CompileJSPTask;
import com.liferay.gradle.plugins.jasper.jspc.JspCPlugin;
import com.liferay.gradle.plugins.util.PortalTools;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.bundling.Jar;

public class JspCDefaultsPlugin
extends BasePortalToolDefaultsPlugin<JspCPlugin> {
    public static final Plugin<Project> INSTANCE = new JspCDefaultsPlugin();
    public static final String UNZIP_JAR_TASK_NAME = "unzipJar";
    private static final String _PORTAL_TOOL_NAME = "com.liferay.jasper.jspc";

    protected void addDependenciesJspC(Project project) {
        ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{this._getUnzippedJarDir(project)});
        configurableFileCollection.builtBy(new Object[]{UNZIP_JAR_TASK_NAME});
        GradleUtil.addDependency((Project)project, (String)"jspC", (FileCollection)configurableFileCollection);
    }

    @Override
    protected void addPortalToolDependencies(Project project) {
        super.addPortalToolDependencies(project);
        GradleUtil.addDependency((Project)project, (String)this.getPortalToolConfigurationName(), (String)"org.apache.ant", (String)"ant", (String)"1.9.4");
    }

    @Override
    protected void addPortalToolDependencies(Project project, String configurationName, String portalToolName) {
        String portalToolVersion = PortalTools.getVersion(project, portalToolName);
        if (Validator.isNotNull((String)portalToolVersion)) {
            GradleUtil.addDependency((Project)project, (String)configurationName, (String)"com.liferay", (String)portalToolName, (String)portalToolVersion);
        }
    }

    @Override
    protected void configureDefaults(Project project, JspCPlugin jspCPlugin) {
        super.configureDefaults(project, jspCPlugin);
        this._addTaskUnzipJar(project);
        this._configureTaskGenerateJSPJava(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                JspCDefaultsPlugin.this.addDependenciesJspC(project);
            }
        });
    }

    @Override
    protected Class<JspCPlugin> getPluginClass() {
        return JspCPlugin.class;
    }

    @Override
    protected String getPortalToolConfigurationName() {
        return "jspCTool";
    }

    @Override
    protected String getPortalToolName() {
        return _PORTAL_TOOL_NAME;
    }

    private JspCDefaultsPlugin() {
    }

    private Task _addTaskUnzipJar(Project project) {
        Task task = project.task(UNZIP_JAR_TASK_NAME);
        final Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
        task.dependsOn(new Object[]{jar});
        task.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                FileUtil.unzip(project, jar.getArchivePath(), JspCDefaultsPlugin.this._getUnzippedJarDir(project));
            }
        });
        return task;
    }

    private void _configureTaskGenerateJSPJava(final Project project) {
        CompileJSPTask compileJSPTask = (CompileJSPTask)GradleUtil.getTask((Project)project, (String)"generateJSPJava");
        compileJSPTask.setWebAppDir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                File unzippedJarDir = JspCDefaultsPlugin.this._getUnzippedJarDir(project);
                File resourcesDir = new File(unzippedJarDir, "META-INF/resources");
                if (resourcesDir.exists()) {
                    return resourcesDir;
                }
                return unzippedJarDir;
            }
        });
        Action<Task> taskAction = new Action<Task>(){

            public void execute(Task task) {
                final CompileJSPTask compileJSPTask = (CompileJSPTask)task;
                Action<CopySpec> copySpecAction = new Action<CopySpec>(){

                    public void execute(CopySpec copySpec) {
                        copySpec.from(new Object[]{compileJSPTask.getDestinationDir()});
                        LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
                        File destinationDir = new File(liferayExtension.getLiferayHome() + "/work/" + GradleUtil.getArchivesBaseName(project) + "-" + project.getVersion());
                        copySpec.into((Object)destinationDir);
                    }
                };
                project.copy((Action)copySpecAction);
            }
        };
        compileJSPTask.doLast((Action)taskAction);
    }

    private File _getUnzippedJarDir(Project project) {
        return new File(project.getBuildDir(), "unzipped-jar");
    }
}

