/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.NodeExtension;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.node.tasks.ExecuteNodeTask;
import com.liferay.gradle.plugins.node.tasks.ExecuteNpmTask;
import com.liferay.gradle.plugins.node.tasks.NpmInstallTask;
import com.liferay.gradle.plugins.node.tasks.PublishNodeModuleTask;
import com.liferay.gradle.util.Validator;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.TaskContainer;

public class NodeDefaultsPlugin
extends BaseDefaultsPlugin<NodePlugin> {
    private static final String _NODE_VERSION = "10.15.1";
    private static final String _NPM_VERSION = "6.4.1";
    private static final String _SASS_BINARY_SITE_ARG = "--sass-binary-site=";

    @Override
    protected void configureDefaults(Project project, NodePlugin nodePlugin) {
        this._configureNode(project);
        this._configureTasksExecuteNpm(project);
        this._configureTasksNpmInstall(project);
        this._configureTasksPublishNodeModule(project);
    }

    @Override
    protected Class<NodePlugin> getPluginClass() {
        return NodePlugin.class;
    }

    private void _configureNode(Project project) {
        NodeExtension nodeExtension = (NodeExtension)GradleUtil.getExtension((ExtensionAware)project, NodeExtension.class);
        nodeExtension.setGlobal(true);
        nodeExtension.setNodeVersion((Object)_NODE_VERSION);
        nodeExtension.setNpmVersion((Object)_NPM_VERSION);
        String npmArgs = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.args", (String)null);
        if (Validator.isNotNull((String)npmArgs)) {
            nodeExtension.npmArgs((Object[])npmArgs.split("\\s+"));
        }
    }

    private void _configureTaskExecuteNpm(ExecuteNpmTask executeNpmTask) {
        String registry = GradleUtil.getProperty((ExtensionAware)executeNpmTask.getProject(), (String)"nodejs.npm.registry", (String)null);
        if (Validator.isNotNull((String)registry)) {
            executeNpmTask.setRegistry((Object)registry);
        }
    }

    private void _configureTaskNpmInstall(NpmInstallTask npmInstallTask) {
        Project project = npmInstallTask.getProject();
        String sassBinarySite = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.sass.binary.site", (String)null);
        if (Validator.isNotNull((String)sassBinarySite)) {
            this._setTaskExecuteNodeArgDefault((ExecuteNodeTask)npmInstallTask, _SASS_BINARY_SITE_ARG, sassBinarySite);
        }
    }

    private void _configureTaskPublishNodeModule(PublishNodeModuleTask publishNodeModuleTask) {
        String repository;
        String userName;
        String password;
        String emailAddress;
        String license;
        String bugsUrl;
        Project project = publishNodeModuleTask.getProject();
        String author = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.module.author", (String)null);
        if (Validator.isNotNull((String)author)) {
            publishNodeModuleTask.setModuleAuthor((Object)author);
        }
        if (Validator.isNotNull((String)(bugsUrl = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.module.bugs.url", (String)null)))) {
            publishNodeModuleTask.setModuleBugsUrl((Object)bugsUrl);
        }
        if (Validator.isNotNull((String)(license = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.module.license", (String)null)))) {
            publishNodeModuleTask.setModuleLicense((Object)license);
        }
        if (Validator.isNotNull((String)(emailAddress = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.email", (String)null)))) {
            publishNodeModuleTask.setNpmEmailAddress((Object)emailAddress);
        }
        if (Validator.isNotNull((String)(password = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.password", (String)null)))) {
            publishNodeModuleTask.setNpmPassword((Object)password);
        }
        if (Validator.isNotNull((String)(userName = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.user", (String)null)))) {
            publishNodeModuleTask.setNpmUserName((Object)userName);
        }
        if (Validator.isNotNull((String)(repository = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.module.repository", (String)null)))) {
            publishNodeModuleTask.setModuleRepository((Object)repository);
        }
    }

    private void _configureTasksExecuteNpm(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteNpmTask.class, (Action)new Action<ExecuteNpmTask>(){

            public void execute(ExecuteNpmTask executeNpmTask) {
                NodeDefaultsPlugin.this._configureTaskExecuteNpm(executeNpmTask);
            }
        });
    }

    private void _configureTasksNpmInstall(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(NpmInstallTask.class, (Action)new Action<NpmInstallTask>(){

            public void execute(NpmInstallTask npmInstallTask) {
                NodeDefaultsPlugin.this._configureTaskNpmInstall(npmInstallTask);
            }
        });
    }

    private void _configureTasksPublishNodeModule(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(PublishNodeModuleTask.class, (Action)new Action<PublishNodeModuleTask>(){

            public void execute(PublishNodeModuleTask publishNodeModuleTask) {
                NodeDefaultsPlugin.this._configureTaskPublishNodeModule(publishNodeModuleTask);
            }
        });
    }

    private void _setTaskExecuteNodeArgDefault(ExecuteNodeTask executeNodeTask, String key, String value) {
        for (Object object : executeNodeTask.getArgs()) {
            String arg = GradleUtil.toString(object);
            if (!arg.startsWith(key)) continue;
            return;
        }
        executeNodeTask.args(new Object[]{key + value});
    }
}

