/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.internal;

import com.liferay.gradle.plugins.BasePortalToolDefaultsPlugin;
import com.liferay.gradle.plugins.wsdl.builder.BuildWSDLTask;
import com.liferay.gradle.plugins.xml.formatter.FormatXMLTask;
import com.liferay.gradle.plugins.xml.formatter.XMLFormatterPlugin;
import com.liferay.gradle.plugins.xsd.builder.BuildXSDTask;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskContainer;

public class XMLFormatterDefaultsPlugin
extends BasePortalToolDefaultsPlugin<XMLFormatterPlugin> {
    public static final String FORMAT_WSDL_TASK_NAME = "formatWSDL";
    public static final String FORMAT_XSD_TASK_NAME = "formatXSD";
    public static final Plugin<Project> INSTANCE = new XMLFormatterDefaultsPlugin();
    private static final String _PORTAL_TOOL_NAME = "com.liferay.xml.formatter";

    @Override
    protected void configureDefaults(Project project, XMLFormatterPlugin xmlFormatterPlugin) {
        super.configureDefaults(project, xmlFormatterPlugin);
        this._addTaskFormatWSDL(project);
        this._addTaskFormatXSD(project);
    }

    @Override
    protected Class<XMLFormatterPlugin> getPluginClass() {
        return XMLFormatterPlugin.class;
    }

    @Override
    protected String getPortalToolConfigurationName() {
        return "xmlFormatter";
    }

    @Override
    protected String getPortalToolName() {
        return _PORTAL_TOOL_NAME;
    }

    private XMLFormatterDefaultsPlugin() {
    }

    private FormatXMLTask _addTaskFormatWSDL(final BuildWSDLTask buildWSDLTask) {
        Project project = buildWSDLTask.getProject();
        TaskContainer taskContainer = project.getTasks();
        FormatXMLTask formatXMLTask = (FormatXMLTask)taskContainer.maybeCreate(FORMAT_WSDL_TASK_NAME, FormatXMLTask.class);
        formatXMLTask.setDescription("Runs Liferay XML Formatter to format WSDL files.");
        formatXMLTask.setIncludes(Collections.singleton("**/*.wsdl"));
        formatXMLTask.source(new Object[]{new Callable<FileCollection>(){

            @Override
            public FileCollection call() throws Exception {
                return buildWSDLTask.getSource();
            }
        }});
        return formatXMLTask;
    }

    private void _addTaskFormatWSDL(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildWSDLTask.class, (Action)new Action<BuildWSDLTask>(){

            public void execute(BuildWSDLTask buildWSDLTask) {
                XMLFormatterDefaultsPlugin.this._addTaskFormatWSDL(buildWSDLTask);
            }
        });
    }

    private FormatXMLTask _addTaskFormatXSD(final BuildXSDTask buildXSDTask) {
        Project project = buildXSDTask.getProject();
        TaskContainer taskContainer = project.getTasks();
        FormatXMLTask formatXMLTask = (FormatXMLTask)taskContainer.maybeCreate(FORMAT_XSD_TASK_NAME, FormatXMLTask.class);
        formatXMLTask.setDescription("Runs Liferay XML Formatter to format XSD files.");
        formatXMLTask.setIncludes(Collections.singleton("**/*.xsd"));
        formatXMLTask.source(new Object[]{new Callable<File>(){

            @Override
            public File call() throws Exception {
                return buildXSDTask.getInputDir();
            }
        }});
        return formatXMLTask;
    }

    private void _addTaskFormatXSD(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildXSDTask.class, (Action)new Action<BuildXSDTask>(){

            public void execute(BuildXSDTask buildXSDTask) {
                XMLFormatterDefaultsPlugin.this._addTaskFormatXSD(buildXSDTask);
            }
        });
    }
}

