/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.internal;

import com.liferay.gradle.plugins.BasePortalToolDefaultsPlugin;
import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.db.support.DBSupportPlugin;
import com.liferay.gradle.plugins.db.support.tasks.CleanServiceBuilderTask;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.service.builder.BuildServiceTask;
import com.liferay.gradle.plugins.service.builder.ServiceBuilderPlugin;
import com.liferay.gradle.plugins.tasks.BuildDBTask;
import java.io.File;
import java.util.concurrent.Callable;
import org.dm.gradle.plugins.bundle.BundlePlugin;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskContainer;

public class ServiceBuilderDefaultsPlugin
extends BasePortalToolDefaultsPlugin<ServiceBuilderPlugin> {
    public static final String BUILD_DB_TASK_NAME = "buildDB";
    public static final Plugin<Project> INSTANCE = new ServiceBuilderDefaultsPlugin();
    private static final String _PORTAL_TOOL_NAME = "com.liferay.portal.tools.service.builder";

    @Override
    protected void configureDefaults(final Project project, ServiceBuilderPlugin serviceBuilderPlugin) {
        super.configureDefaults(project, serviceBuilderPlugin);
        BuildServiceTask buildServiceTask = (BuildServiceTask)GradleUtil.getTask((Project)project, (String)"buildService");
        GradleUtil.applyPlugin((Project)project, DBSupportPlugin.class);
        this._addTaskBuildDB(project);
        this._configureTaskCleanServiceBuilder(buildServiceTask);
        GradleUtil.withPlugin(project, LiferayBasePlugin.class, new Action<LiferayBasePlugin>(){

            public void execute(LiferayBasePlugin liferayBasePlugin) {
                Configuration portalConfiguration = GradleUtil.getConfiguration((Project)project, (String)"portal");
                ServiceBuilderDefaultsPlugin.this._configureTasksBuildDB(project, (FileCollection)portalConfiguration);
            }
        });
        GradleUtil.withPlugin(project, BundlePlugin.class, new Action<BundlePlugin>(){

            public void execute(BundlePlugin bundlePlugin) {
                ServiceBuilderDefaultsPlugin.this._configureTasksBuildServiceForBundlePlugin(project);
            }
        });
    }

    @Override
    protected Class<ServiceBuilderPlugin> getPluginClass() {
        return ServiceBuilderPlugin.class;
    }

    @Override
    protected String getPortalToolConfigurationName() {
        return "serviceBuilder";
    }

    @Override
    protected String getPortalToolName() {
        return _PORTAL_TOOL_NAME;
    }

    private ServiceBuilderDefaultsPlugin() {
    }

    private BuildDBTask _addTaskBuildDB(final Project project) {
        BuildDBTask buildDBTask = (BuildDBTask)GradleUtil.addTask((Project)project, (String)BUILD_DB_TASK_NAME, BuildDBTask.class);
        buildDBTask.setDatabaseName("lportal");
        buildDBTask.setDatabaseTypes("hypersonic", "mysql", "postgresql");
        buildDBTask.setDescription("Builds database SQL scripts from the generic SQL scripts.");
        buildDBTask.setGroup("build");
        buildDBTask.setSqlDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                BuildServiceTask buildServiceTask = (BuildServiceTask)GradleUtil.getTask((Project)project, (String)"buildService");
                return buildServiceTask.getSqlDir();
            }
        });
        return buildDBTask;
    }

    private void _configureTaskBuildDBClasspath(BuildDBTask buildDBTask, FileCollection fileCollection) {
        buildDBTask.setClasspath(fileCollection);
    }

    private void _configureTaskBuildServiceForBundlePlugin(BuildServiceTask buildServiceTask) {
        buildServiceTask.setOsgiModule(true);
    }

    private void _configureTaskCleanServiceBuilder(final BuildServiceTask buildServiceTask) {
        CleanServiceBuilderTask cleanServiceBuilderTask = (CleanServiceBuilderTask)GradleUtil.getTask((Project)buildServiceTask.getProject(), (String)"cleanServiceBuilder");
        cleanServiceBuilderTask.setServiceXmlFile((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return buildServiceTask.getInputFile();
            }
        });
    }

    private void _configureTasksBuildDB(Project project, final FileCollection classpath) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildDBTask.class, (Action)new Action<BuildDBTask>(){

            public void execute(BuildDBTask buildDBTask) {
                ServiceBuilderDefaultsPlugin.this._configureTaskBuildDBClasspath(buildDBTask, classpath);
            }
        });
    }

    private void _configureTasksBuildServiceForBundlePlugin(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildServiceTask.class, (Action)new Action<BuildServiceTask>(){

            public void execute(BuildServiceTask buildServiceTask) {
                ServiceBuilderDefaultsPlugin.this._configureTaskBuildServiceForBundlePlugin(buildServiceTask);
            }
        });
    }
}

