/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.internal.util;

import com.liferay.gradle.util.ArrayUtil;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gradle.api.AntBuilder;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileTree;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class FileUtil
extends com.liferay.gradle.util.FileUtil {
    private static final Logger _logger = Logging.getLogger(FileUtil.class);

    public static FileTree getJarsFileTree(Project project, File dir, String ... excludes) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("dir", dir);
        if (ArrayUtil.isNotEmpty((Object[])excludes)) {
            args.put("excludes", Arrays.asList(excludes));
        }
        args.put("include", "*.jar");
        return project.fileTree(args);
    }

    public static String getRelativePath(Project project, File file) {
        String relativePath = project.relativePath((Object)file);
        if (File.separatorChar != '/') {
            relativePath = relativePath.replace(File.separatorChar, '/');
        }
        return relativePath;
    }

    public static Properties readPropertiesFromZipFile(File file, String name) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry zipEntry = zipFile.getEntry(name);
            if (zipEntry == null) {
                Properties properties = null;
                return properties;
            }
            Properties properties = new Properties();
            try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                properties.load(inputStream);
            }
            Properties properties2 = properties;
            return properties2;
        }
    }

    public static void touchFile(File file, long time) {
        boolean success = file.setLastModified(time);
        if (!success) {
            _logger.error("Unable to touch {}", (Object)file);
        }
    }

    public static void touchFiles(Project project, File dir, long time, String ... includes) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("dir", dir);
        args.put("includes", Arrays.asList(includes));
        ConfigurableFileTree fileTree = project.fileTree(args);
        for (File file : fileTree) {
            FileUtil.touchFile(file, time);
        }
    }

    public static void unzip(Project project, final File file, final File destinationDir) {
        project.ant((Closure)new Closure<Void>((Object)project){

            public void doCall(AntBuilder antBuilder) {
                FileUtil._invokeAntMethodUnzip(antBuilder, file, destinationDir);
            }
        });
    }

    private static void _invokeAntMethodUnzip(AntBuilder antBuilder, File file, File destinationDir) {
        HashMap<String, File> args = new HashMap<String, File>();
        args.put("dest", destinationDir);
        args.put("src", file);
        antBuilder.invokeMethod("unzip", args);
    }
}

