/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import aQute.bnd.header.Parameters;
import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.css.builder.CSSBuilderPlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.extensions.LiferayOSGiExtension;
import com.liferay.gradle.plugins.internal.AlloyTaglibDefaultsPlugin;
import com.liferay.gradle.plugins.internal.CSSBuilderDefaultsPlugin;
import com.liferay.gradle.plugins.internal.DBSupportDefaultsPlugin;
import com.liferay.gradle.plugins.internal.EclipseDefaultsPlugin;
import com.liferay.gradle.plugins.internal.FindBugsDefaultsPlugin;
import com.liferay.gradle.plugins.internal.IdeaDefaultsPlugin;
import com.liferay.gradle.plugins.internal.JSModuleConfigGeneratorDefaultsPlugin;
import com.liferay.gradle.plugins.internal.JavadocFormatterDefaultsPlugin;
import com.liferay.gradle.plugins.internal.JspCDefaultsPlugin;
import com.liferay.gradle.plugins.internal.ServiceBuilderDefaultsPlugin;
import com.liferay.gradle.plugins.internal.TLDFormatterDefaultsPlugin;
import com.liferay.gradle.plugins.internal.TestIntegrationDefaultsPlugin;
import com.liferay.gradle.plugins.internal.UpgradeTableBuilderDefaultsPlugin;
import com.liferay.gradle.plugins.internal.WSDDBuilderDefaultsPlugin;
import com.liferay.gradle.plugins.internal.XMLFormatterDefaultsPlugin;
import com.liferay.gradle.plugins.internal.util.FileUtil;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.jasper.jspc.JspCPlugin;
import com.liferay.gradle.plugins.javadoc.formatter.JavadocFormatterPlugin;
import com.liferay.gradle.plugins.js.module.config.generator.JSModuleConfigGeneratorPlugin;
import com.liferay.gradle.plugins.js.transpiler.JSTranspilerPlugin;
import com.liferay.gradle.plugins.lang.builder.LangBuilderPlugin;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.node.tasks.DownloadNodeModuleTask;
import com.liferay.gradle.plugins.node.tasks.NpmInstallTask;
import com.liferay.gradle.plugins.source.formatter.SourceFormatterPlugin;
import com.liferay.gradle.plugins.soy.SoyPlugin;
import com.liferay.gradle.plugins.soy.SoyTranslationPlugin;
import com.liferay.gradle.plugins.soy.tasks.BuildSoyTask;
import com.liferay.gradle.plugins.tasks.DirectDeployTask;
import com.liferay.gradle.plugins.test.integration.TestIntegrationPlugin;
import com.liferay.gradle.plugins.tld.formatter.TLDFormatterPlugin;
import com.liferay.gradle.plugins.tlddoc.builder.TLDDocBuilderPlugin;
import com.liferay.gradle.plugins.wsdd.builder.BuildWSDDTask;
import com.liferay.gradle.plugins.wsdl.builder.WSDLBuilderPlugin;
import com.liferay.gradle.plugins.xml.formatter.XMLFormatterPlugin;
import com.liferay.gradle.util.StringUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import org.dm.gradle.plugins.bundle.BundleExtension;
import org.dm.gradle.plugins.bundle.BundlePlugin;
import org.dm.gradle.plugins.bundle.BundleUtils;
import org.dm.gradle.plugins.bundle.JarBuilder;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.ApplicationPlugin;
import org.gradle.api.plugins.ApplicationPluginConvention;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.Factory;
import org.gradle.util.GUtil;

public class LiferayOSGiPlugin
implements Plugin<Project> {
    public static final String AUTO_CLEAN_PROPERTY_NAME = "autoClean";
    public static final String AUTO_UPDATE_XML_TASK_NAME = "autoUpdateXml";
    public static final String CLEAN_DEPLOYED_PROPERTY_NAME = "cleanDeployed";
    public static final String COMPILE_INCLUDE_CONFIGURATION_NAME = "compileInclude";
    public static final String PLUGIN_NAME = "liferayOSGi";
    private static final String _CACHE_PLUGIN_ID = "com.liferay.cache";
    private static final Logger _logger = Logging.getLogger(LiferayOSGiPlugin.class);

    public void apply(final Project project) {
        GradleUtil.applyPlugin((Project)project, LiferayBasePlugin.class);
        LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        final LiferayOSGiExtension liferayOSGiExtension = (LiferayOSGiExtension)GradleUtil.addExtension((ExtensionAware)project, (String)PLUGIN_NAME, LiferayOSGiExtension.class);
        this._applyPlugins(project);
        this._addDeployedFile(project, liferayExtension, "jar", false);
        final Configuration compileIncludeConfiguration = this._addConfigurationCompileInclude(project);
        this._addTaskAutoUpdateXml(project);
        this._addTasksBuildWSDDJar(project, liferayExtension);
        this._configureArchivesBaseName(project);
        this._configureDescription(project);
        this._configureLiferay(project, liferayExtension);
        this._configureSourceSetMain(project);
        this._configureTaskClean(project);
        this._configureTaskJar(project);
        this._configureTaskJavadoc(project);
        this._configureTaskTest(project);
        this._configureTasksTest(project);
        if (GradleUtil.isRunningInsideDaemon()) {
            this._configureTasksJavaCompileFork(project, true);
        }
        this._configureVersion(project);
        GradleUtil.withPlugin(project, ApplicationPlugin.class, new Action<ApplicationPlugin>(){

            public void execute(ApplicationPlugin applicationPlugin) {
                LiferayOSGiPlugin.this._configureApplication(project);
                LiferayOSGiPlugin.this._configureTaskRun(project, compileIncludeConfiguration);
            }
        });
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                LiferayOSGiPlugin.this._configureBundleExtensionDefaults(project, liferayOSGiExtension, compileIncludeConfiguration);
            }
        });
    }

    private Configuration _addConfigurationCompileInclude(Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)COMPILE_INCLUDE_CONFIGURATION_NAME);
        configuration.setDescription("Additional dependencies to include in the final JAR.");
        configuration.setVisible(false);
        Configuration compileOnlyConfiguration = GradleUtil.getConfiguration((Project)project, (String)"compileOnly");
        compileOnlyConfiguration.extendsFrom(new Configuration[]{configuration});
        return configuration;
    }

    private void _addDeployedFile(final LiferayExtension liferayExtension, final AbstractArchiveTask abstractArchiveTask, boolean lazy) {
        final Project project = abstractArchiveTask.getProject();
        Task task = GradleUtil.getTask((Project)project, (String)"deploy");
        if (!(task instanceof Copy)) {
            return;
        }
        final Copy copy = (Copy)task;
        Object sourcePath = abstractArchiveTask;
        if (lazy) {
            sourcePath = new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return abstractArchiveTask.getArchivePath();
                }
            };
        }
        copy.from(sourcePath, (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                copySpec.rename((Closure)new Closure<String>((Object)project){

                    public String doCall(String fileName) {
                        Closure<String> deployedFileNameClosure = liferayExtension.getDeployedFileNameClosure();
                        return (String)deployedFileNameClosure.call((Object)abstractArchiveTask);
                    }
                });
            }
        });
        Delete delete = (Delete)GradleUtil.getTask((Project)project, (String)"clean");
        if (GradleUtil.getProperty((ExtensionAware)delete, (String)CLEAN_DEPLOYED_PROPERTY_NAME, (boolean)true)) {
            delete.delete(new Object[]{new Callable<File>(){

                @Override
                public File call() throws Exception {
                    Closure<String> deployedFileNameClosure = liferayExtension.getDeployedFileNameClosure();
                    return new File(copy.getDestinationDir(), (String)deployedFileNameClosure.call((Object)abstractArchiveTask));
                }
            }});
        }
    }

    private void _addDeployedFile(Project project, LiferayExtension liferayExtension, String taskName, boolean lazy) {
        AbstractArchiveTask abstractArchiveTask = (AbstractArchiveTask)GradleUtil.getTask((Project)project, (String)taskName);
        this._addDeployedFile(liferayExtension, abstractArchiveTask, lazy);
    }

    private DirectDeployTask _addTaskAutoUpdateXml(final Project project) {
        final DirectDeployTask directDeployTask = (DirectDeployTask)GradleUtil.addTask((Project)project, (String)AUTO_UPDATE_XML_TASK_NAME, DirectDeployTask.class);
        directDeployTask.setAppServerDeployDir(directDeployTask.getTemporaryDir());
        directDeployTask.setAppServerType("tomcat");
        directDeployTask.setWebAppFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
                return FileUtil.replaceExtension((File)jar.getArchivePath(), (String)"war");
            }
        });
        directDeployTask.setWebAppType("portlet");
        directDeployTask.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                DirectDeployTask directDeployTask = (DirectDeployTask)task;
                Jar jar = (Jar)GradleUtil.getTask((Project)directDeployTask.getProject(), (String)"jar");
                File jarFile = jar.getArchivePath();
                jarFile.renameTo(directDeployTask.getWebAppFile());
            }
        });
        directDeployTask.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Logger logger = task.getLogger();
                Project project = task.getProject();
                project.delete(new Object[]{"liferay/logs"});
                File liferayDir = project.file((Object)"liferay");
                boolean deleted = liferayDir.delete();
                if (!deleted && logger.isInfoEnabled()) {
                    logger.info("Unable to delete " + liferayDir);
                }
            }
        });
        directDeployTask.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                DirectDeployTask directDeployTask = (DirectDeployTask)task;
                Project project = directDeployTask.getProject();
                File warFile = directDeployTask.getWebAppFile();
                Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
                String deployedPluginDirName = FileUtil.stripExtension((String)jar.getArchiveName());
                File deployedPluginDir = new File(directDeployTask.getAppServerDeployDir(), deployedPluginDirName);
                if (!deployedPluginDir.exists()) {
                    deployedPluginDir = new File(directDeployTask.getAppServerDeployDir(), project.getName());
                }
                if (!deployedPluginDir.exists()) {
                    _logger.warn("Unable to automatically update web.xml in " + jar.getArchivePath());
                    return;
                }
                FileUtil.touchFiles(project, deployedPluginDir, 0L, "WEB-INF/liferay-web.xml", "WEB-INF/web.xml", "WEB-INF/tld/*");
                deployedPluginDirName = project.relativePath((Object)deployedPluginDir);
                LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
                String[][] filesets = new String[][]{{project.relativePath((Object)liferayExtension.getAppServerPortalDir()), "WEB-INF/tld/c.tld"}, {deployedPluginDirName, "WEB-INF/liferay-web.xml,WEB-INF/web.xml"}, {deployedPluginDirName, "WEB-INF/tld/*"}};
                FileUtil.jar((Project)project, (File)warFile, (String)"preserve", (boolean)true, (String[][])filesets);
                warFile.renameTo(jar.getArchivePath());
            }
        });
        directDeployTask.onlyIf((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                Project project = task.getProject();
                LiferayOSGiExtension liferayOSGiExtension = (LiferayOSGiExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayOSGiExtension.class);
                return liferayOSGiExtension.isAutoUpdateXml() && FileUtil.exists((Project)project, (String)"docroot/WEB-INF/portlet.xml");
            }
        });
        TaskInputs taskInputs = directDeployTask.getInputs();
        taskInputs.file((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
                return jar.getArchivePath();
            }
        });
        Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
        jar.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                directDeployTask.execute();
            }
        });
        return directDeployTask;
    }

    private Jar _addTaskBuildWSDDJar(final BuildWSDDTask buildWSDDTask, LiferayExtension liferayExtension) {
        Project project = buildWSDDTask.getProject();
        Jar jar = (Jar)GradleUtil.addTask((Project)project, (String)(buildWSDDTask.getName() + "Jar"), Jar.class);
        jar.dependsOn(new Object[]{buildWSDDTask});
        jar.deleteAllActions();
        jar.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Project project = task.getProject();
                BundleExtension bundleExtension = (BundleExtension)GradleUtil.getExtension((ExtensionAware)project, BundleExtension.class);
                Factory jarBuilderFactory = bundleExtension.getJarBuilderFactory();
                JarBuilder jarBuilder = (JarBuilder)jarBuilderFactory.create();
                Map<String, String> properties = this._getProperties(project);
                jarBuilder.withBase((Object)BundleUtils.getBase((Project)project));
                jarBuilder.withClasspath((Object)this._getClasspath(project));
                jarBuilder.withFailOnError((Object)true);
                jarBuilder.withName(properties.get("Bundle-SymbolicName"));
                jarBuilder.withProperties(properties);
                jarBuilder.withResources((Object)new File[0]);
                jarBuilder.withSourcepath((Object)BundleUtils.getSources((Project)project));
                jarBuilder.withTrace((Object)bundleExtension.isTrace());
                jarBuilder.withVersion(BundleUtils.getVersion((Project)project));
                TaskOutputs taskOutputs = task.getOutputs();
                FileCollection fileCollection = taskOutputs.getFiles();
                jarBuilder.writeJarTo(fileCollection.getSingleFile());
            }

            private File[] _getClasspath(Project project) {
                SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
                SourceSetOutput sourceSetOutput = sourceSet.getOutput();
                return new File[]{sourceSetOutput.getClassesDir(), sourceSetOutput.getResourcesDir()};
            }

            private Map<String, String> _getProperties(Project project) {
                LiferayOSGiExtension liferayOSGiExtension = (LiferayOSGiExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayOSGiExtension.class);
                Map<String, String> properties = liferayOSGiExtension.getBundleDefaultInstructions();
                properties.remove("-donotcopy");
                String bundleName = LiferayOSGiPlugin.this._getBundleInstruction(project, "Bundle-Name");
                if (Validator.isNotNull((String)bundleName)) {
                    properties.put("Bundle-Name", bundleName + " WSDD descriptors");
                }
                String bundleSymbolicName = LiferayOSGiPlugin.this._getBundleInstruction(project, "Bundle-SymbolicName");
                properties.put("Bundle-SymbolicName", bundleSymbolicName + ".wsdd");
                properties.put("Fragment-Host", bundleSymbolicName);
                properties.put("Import-Package", "javax.servlet,javax.servlet.http");
                StringBuilder sb = new StringBuilder();
                sb.append("WEB-INF/=");
                sb.append(FileUtil.getRelativePath(project, buildWSDDTask.getServerConfigFile()));
                sb.append(',');
                sb.append(FileUtil.getRelativePath(project, buildWSDDTask.getOutputDir()));
                sb.append(";filter:=*.wsdd");
                properties.put("Include-Resource", sb.toString());
                return properties;
            }
        });
        String taskName = buildWSDDTask.getName();
        if (taskName.equals("buildWSDD")) {
            jar.setAppendix("wsdd");
        } else {
            jar.setAppendix("wsdd-" + taskName);
        }
        buildWSDDTask.finalizedBy(new Object[]{jar});
        this._addDeployedFile(liferayExtension, (AbstractArchiveTask)jar, true);
        return jar;
    }

    private void _addTasksBuildWSDDJar(Project project, final LiferayExtension liferayExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildWSDDTask.class, (Action)new Action<BuildWSDDTask>(){

            public void execute(BuildWSDDTask buildWSDDTask) {
                LiferayOSGiPlugin.this._addTaskBuildWSDDJar(buildWSDDTask, liferayExtension);
            }
        });
    }

    private void _applyPlugins(Project project) {
        GradleUtil.applyPlugin((Project)project, BundlePlugin.class);
        this._configureBundleExtension(project);
        GradleUtil.applyPlugin((Project)project, JavaPlugin.class);
        GradleUtil.applyPlugin((Project)project, CSSBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, NodePlugin.class);
        if (!GradleUtil.hasTask(project, "npmRunBuild")) {
            GradleUtil.applyPlugin((Project)project, JSModuleConfigGeneratorPlugin.class);
            GradleUtil.applyPlugin((Project)project, JSTranspilerPlugin.class);
        }
        GradleUtil.applyPlugin((Project)project, JavadocFormatterPlugin.class);
        GradleUtil.applyPlugin((Project)project, JspCPlugin.class);
        GradleUtil.applyPlugin((Project)project, LangBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, SourceFormatterPlugin.class);
        GradleUtil.applyPlugin((Project)project, SoyPlugin.class);
        GradleUtil.applyPlugin((Project)project, SoyTranslationPlugin.class);
        GradleUtil.applyPlugin((Project)project, TLDDocBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, TLDFormatterPlugin.class);
        GradleUtil.applyPlugin((Project)project, TestIntegrationPlugin.class);
        GradleUtil.applyPlugin((Project)project, XMLFormatterPlugin.class);
        AlloyTaglibDefaultsPlugin.INSTANCE.apply((Object)project);
        CSSBuilderDefaultsPlugin.INSTANCE.apply((Object)project);
        DBSupportDefaultsPlugin.INSTANCE.apply((Object)project);
        EclipseDefaultsPlugin.INSTANCE.apply((Object)project);
        FindBugsDefaultsPlugin.INSTANCE.apply((Object)project);
        IdeaDefaultsPlugin.INSTANCE.apply((Object)project);
        JSModuleConfigGeneratorDefaultsPlugin.INSTANCE.apply((Object)project);
        JavadocFormatterDefaultsPlugin.INSTANCE.apply((Object)project);
        JspCDefaultsPlugin.INSTANCE.apply((Object)project);
        ServiceBuilderDefaultsPlugin.INSTANCE.apply((Object)project);
        TLDFormatterDefaultsPlugin.INSTANCE.apply((Object)project);
        TestIntegrationDefaultsPlugin.INSTANCE.apply((Object)project);
        UpgradeTableBuilderDefaultsPlugin.INSTANCE.apply((Object)project);
        WSDDBuilderDefaultsPlugin.INSTANCE.apply((Object)project);
        XMLFormatterDefaultsPlugin.INSTANCE.apply((Object)project);
    }

    private void _configureApplication(Project project) {
        ApplicationPluginConvention applicationPluginConvention = (ApplicationPluginConvention)GradleUtil.getConvention((Project)project, ApplicationPluginConvention.class);
        String mainClassName = this._getBundleInstruction(project, "Main-Class");
        if (Validator.isNotNull((String)mainClassName)) {
            applicationPluginConvention.setMainClassName(mainClassName);
        }
    }

    private void _configureArchivesBaseName(Project project) {
        BasePluginConvention basePluginConvention = (BasePluginConvention)GradleUtil.getConvention((Project)project, BasePluginConvention.class);
        String bundleSymbolicName = this._getBundleInstruction(project, "Bundle-SymbolicName");
        if (Validator.isNull((String)bundleSymbolicName)) {
            return;
        }
        Parameters parameters = new Parameters(bundleSymbolicName);
        Set keys = parameters.keySet();
        Iterator iterator = keys.iterator();
        bundleSymbolicName = (String)iterator.next();
        basePluginConvention.setArchivesBaseName(bundleSymbolicName);
    }

    private void _configureBundleExtension(Project project) {
        this._replaceJarBuilderFactory(project);
        BundleExtension bundleExtension = (BundleExtension)GradleUtil.getExtension((ExtensionAware)project, BundleExtension.class);
        bundleExtension.setFailOnError(true);
        File file = project.file((Object)"bnd.bnd");
        if (file.exists()) {
            Map<String, Object> bundleInstructions = this._getBundleInstructions(bundleExtension);
            Properties properties = GUtil.loadProperties((File)file);
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = properties.getProperty(key);
                bundleInstructions.put(key, value);
            }
        }
    }

    private void _configureBundleExtensionDefaults(Project project, final LiferayOSGiExtension liferayOSGiExtension, final Configuration compileIncludeConfiguration) {
        Map<String, Object> bundleInstructions = this._getBundleInstructions(project);
        bundleInstructions.put("-includeresource." + compileIncludeConfiguration.getName(), new Object(){

            public String toString() {
                boolean expandCompileInclude = liferayOSGiExtension.isExpandCompileInclude();
                StringBuilder sb = new StringBuilder();
                for (File file : compileIncludeConfiguration) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    if (expandCompileInclude) {
                        sb.append('@');
                    } else {
                        sb.append("lib/=");
                    }
                    sb.append(file.getAbsolutePath());
                    if (expandCompileInclude) continue;
                    sb.append(";lib:=true");
                }
                return sb.toString();
            }
        });
        Map<String, String> bundleDefaultInstructions = liferayOSGiExtension.getBundleDefaultInstructions();
        for (Map.Entry<String, String> entry : bundleDefaultInstructions.entrySet()) {
            String key = entry.getKey();
            if (bundleInstructions.containsKey(key)) continue;
            bundleInstructions.put(key, entry.getValue());
        }
    }

    private void _configureDescription(Project project) {
        String description = this._getBundleInstruction(project, "Bundle-Description");
        if (Validator.isNull((String)description)) {
            description = this._getBundleInstruction(project, "Bundle-Name");
        }
        if (Validator.isNotNull((String)description)) {
            project.setDescription(description);
        }
    }

    private void _configureLiferay(final Project project, final LiferayExtension liferayExtension) {
        liferayExtension.setDeployDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                File dir = new File(liferayExtension.getAppServerParentDir(), "osgi/modules");
                return GradleUtil.getProperty((Project)project, (String)"auto.deploy.dir", (File)dir);
            }
        });
    }

    private void _configureSourceSetMain(Project project) {
        File docrootDir = project.file((Object)"docroot");
        if (!docrootDir.exists()) {
            return;
        }
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        SourceSetOutput sourceSetOutput = sourceSet.getOutput();
        File classesDir = new File(docrootDir, "WEB-INF/classes");
        sourceSetOutput.setClassesDir((Object)classesDir);
        sourceSetOutput.setResourcesDir((Object)classesDir);
        SourceDirectorySet javaSourceDirectorySet = sourceSet.getJava();
        File srcDir = new File(docrootDir, "WEB-INF/src");
        Set<File> srcDirs = Collections.singleton(srcDir);
        javaSourceDirectorySet.setSrcDirs(srcDirs);
        SourceDirectorySet resourcesSourceDirectorySet = sourceSet.getResources();
        resourcesSourceDirectorySet.setSrcDirs(srcDirs);
    }

    private void _configureTaskClean(Project project) {
        Task task = GradleUtil.getTask((Project)project, (String)"clean");
        if (task instanceof Delete) {
            this._configureTaskCleanDependsOn((Delete)task);
        }
    }

    private void _configureTaskCleanDependsOn(Delete delete) {
        Project project = delete.getProject();
        Closure<Set<String>> closure = new Closure<Set<String>>((Object)project){

            public Set<String> doCall(Delete delete) {
                HashSet<String> cleanTaskNames = new HashSet<String>();
                Project project = delete.getProject();
                for (Task task : project.getTasks()) {
                    TaskOutputs taskOutputs;
                    boolean autoClean;
                    String taskName = task.getName();
                    if (taskName.equals("deploy") || taskName.equals("eclipseClasspath") || taskName.equals("eclipseProject") || taskName.equals("ideaModule") || task instanceof BuildSoyTask || task instanceof DownloadNodeModuleTask || task instanceof NpmInstallTask || GradleUtil.hasPlugin(project, LiferayOSGiPlugin._CACHE_PLUGIN_ID) && taskName.startsWith("save") && taskName.endsWith("Cache") || GradleUtil.hasPlugin(project, WSDLBuilderPlugin.class) && taskName.startsWith("buildWSDLGenerate") || !(autoClean = GradleUtil.getProperty((ExtensionAware)task, (String)LiferayOSGiPlugin.AUTO_CLEAN_PROPERTY_NAME, (boolean)true)) || !(taskOutputs = task.getOutputs()).getHasOutput()) continue;
                    cleanTaskNames.add("clean" + StringUtil.capitalize((String)taskName));
                }
                return cleanTaskNames;
            }
        };
        delete.dependsOn(new Object[]{closure});
    }

    private void _configureTaskJar(Project project) {
        File bndFile = project.file((Object)"bnd.bnd");
        if (!bndFile.exists()) {
            return;
        }
        Task jarTask = GradleUtil.getTask((Project)project, (String)"jar");
        TaskInputs taskInputs = jarTask.getInputs();
        taskInputs.file((Object)bndFile);
    }

    private void _configureTaskJavaCompileFork(JavaCompile javaCompile, boolean fork) {
        CompileOptions compileOptions = javaCompile.getOptions();
        compileOptions.setFork(fork);
    }

    private void _configureTaskJavadoc(Project project) {
        String bundleName = this._getBundleInstruction(project, "Bundle-Name");
        String bundleVersion = this._getBundleInstruction(project, "Bundle-Version");
        if (Validator.isNull((String)bundleName) || Validator.isNull((String)bundleVersion)) {
            return;
        }
        Javadoc javadoc = (Javadoc)GradleUtil.getTask((Project)project, (String)"javadoc");
        String title = String.format("%s %s API", bundleName, bundleVersion);
        javadoc.setTitle(title);
    }

    private void _configureTaskRun(Project project, Configuration compileIncludeConfiguration) {
        JavaExec javaExec = (JavaExec)GradleUtil.getTask((Project)project, (String)"run");
        javaExec.classpath(new Object[]{compileIncludeConfiguration});
    }

    private void _configureTasksJavaCompileFork(Project project, final boolean fork) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(JavaCompile.class, (Action)new Action<JavaCompile>(){

            public void execute(JavaCompile javaCompile) {
                LiferayOSGiPlugin.this._configureTaskJavaCompileFork(javaCompile, fork);
            }
        });
    }

    private void _configureTasksTest(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(Test.class, (Action)new Action<Test>(){

            public void execute(Test test) {
                LiferayOSGiPlugin.this._configureTaskTestDefaultCharacterEncoding(test);
            }
        });
    }

    private void _configureTaskTest(Project project) {
        final Test test = (Test)GradleUtil.getTask((Project)project, (String)"test");
        test.jvmArgs(new Object[]{"-Djava.net.preferIPv4Stack=true", "-Dliferay.mode=test", "-Duser.timezone=GMT"});
        test.setForkEvery(Long.valueOf(1L));
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                LiferayOSGiPlugin.this._configureTaskTestIncludes(test);
            }
        });
    }

    private void _configureTaskTestDefaultCharacterEncoding(Test test) {
        test.setDefaultCharacterEncoding(StandardCharsets.UTF_8.name());
    }

    private void _configureTaskTestIncludes(Test test) {
        Set includes = test.getIncludes();
        if (includes.isEmpty()) {
            test.setIncludes(Collections.singleton("**/*Test.class"));
        }
    }

    private void _configureVersion(Project project) {
        String bundleVersion = this._getBundleInstruction(project, "Bundle-Version");
        if (Validator.isNotNull((String)bundleVersion)) {
            project.setVersion((Object)bundleVersion);
        }
    }

    private String _getBundleInstruction(Project project, String key) {
        Map<String, Object> bundleInstructions = this._getBundleInstructions(project);
        return GradleUtil.toString((Object)bundleInstructions.get(key));
    }

    private Map<String, Object> _getBundleInstructions(BundleExtension bundleExtension) {
        return (Map)bundleExtension.getInstructions();
    }

    private Map<String, Object> _getBundleInstructions(Project project) {
        BundleExtension bundleExtension = (BundleExtension)GradleUtil.getExtension((ExtensionAware)project, BundleExtension.class);
        return this._getBundleInstructions(bundleExtension);
    }

    private void _replaceJarBuilderFactory(Project project) {
        BundleExtension bundleExtension = (BundleExtension)GradleUtil.getExtension((ExtensionAware)project, BundleExtension.class);
        bundleExtension.setJarBuilderFactory((Factory)new LiferayJarBuilderFactory());
    }

    private static class LiferayJarBuilder
    extends JarBuilder {
        private final Set<File> _classpathFiles = new HashSet<File>();
        private ClassLoader _contextClassLoader;
        private final Set<File> _resourceFiles = new HashSet<File>();

        private LiferayJarBuilder() {
        }

        public JarBuilder withClasspath(Object files) {
            ArrayList<File> filesList = new ArrayList<File>(Arrays.asList((File[])files));
            Iterator iterator = filesList.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                String fileName = file.getName();
                if (this._classpathFiles.contains(file) || fileName.endsWith(".pom") || !file.exists()) {
                    iterator.remove();
                    continue;
                }
                this._classpathFiles.add(file);
                if (!_logger.isInfoEnabled()) continue;
                _logger.info("CLASSPATH: {}", (Object)file.getAbsolutePath());
            }
            return super.withClasspath((Object)filesList.toArray(new File[filesList.size()]));
        }

        public JarBuilder withContextClassLoader(ClassLoader contextClassLoader) {
            this._contextClassLoader = contextClassLoader;
            return this;
        }

        public JarBuilder withResources(Object files) {
            ArrayList<File> filesList = new ArrayList<File>(Arrays.asList((File[])files));
            Iterator iterator = filesList.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                if (this._resourceFiles.contains(file) || !file.exists()) {
                    iterator.remove();
                    continue;
                }
                this._resourceFiles.add(file);
                if (!_logger.isInfoEnabled()) continue;
                _logger.info("RESOURCE: {}", (Object)file.getAbsolutePath());
            }
            return super.withResources((Object)filesList.toArray(new File[filesList.size()]));
        }

        public void writeJarTo(File file) {
            ClassLoader contextClassLoader = this._replaceContextClassLoader(this._contextClassLoader);
            try {
                super.writeJarTo(file);
            }
            finally {
                this._replaceContextClassLoader(contextClassLoader);
            }
        }

        public void writeManifestTo(OutputStream outputStream) {
            ClassLoader contextClassLoader = this._replaceContextClassLoader(this._contextClassLoader);
            try {
                super.writeManifestTo(outputStream);
            }
            finally {
                this._replaceContextClassLoader(contextClassLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeManifestTo(OutputStream outputStream, Closure closure) {
            ClassLoader contextClassLoader = this._replaceContextClassLoader(this._contextClassLoader);
            try {
                super.writeManifestTo(outputStream, closure);
            }
            finally {
                this._replaceContextClassLoader(contextClassLoader);
            }
        }

        private ClassLoader _replaceContextClassLoader(ClassLoader newContextClassLoader) {
            if (newContextClassLoader == null) {
                return null;
            }
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(newContextClassLoader);
            return contextClassLoader;
        }
    }

    public static class LiferayJarBuilderFactory
    implements Factory<JarBuilder> {
        private ClassLoader _contextClassLoader;

        public JarBuilder create() {
            LiferayJarBuilder liferayJarBuilder = new LiferayJarBuilder();
            return liferayJarBuilder.withContextClassLoader(this._contextClassLoader);
        }

        public ClassLoader getContextClassLoader() {
            return this._contextClassLoader;
        }

        public void setContextClassLoader(ClassLoader contextClassLoader) {
            this._contextClassLoader = contextClassLoader;
        }
    }
}

