/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.BasePortalToolDefaultsPlugin;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.source.formatter.FormatSourceTask;
import com.liferay.gradle.plugins.source.formatter.SourceFormatterPlugin;
import com.liferay.gradle.util.Validator;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.TaskContainer;

public class SourceFormatterDefaultsPlugin
extends BasePortalToolDefaultsPlugin<SourceFormatterPlugin> {
    public static final Plugin<Project> INSTANCE = new SourceFormatterDefaultsPlugin();
    private static final String _PORTAL_TOOL_NAME = "com.liferay.source.formatter";

    @Override
    protected void configureDefaults(Project project, SourceFormatterPlugin sourceFormatterPlugin) {
        super.configureDefaults(project, sourceFormatterPlugin);
        this._configureTasksFormatSource(project);
    }

    @Override
    protected Class<SourceFormatterPlugin> getPluginClass() {
        return SourceFormatterPlugin.class;
    }

    @Override
    protected String getPortalToolConfigurationName() {
        return "sourceFormatter";
    }

    @Override
    protected String getPortalToolName() {
        return _PORTAL_TOOL_NAME;
    }

    private SourceFormatterDefaultsPlugin() {
    }

    private void _configureTasksFormatSource(FormatSourceTask formatSourceTask) {
        String processorThreadCount;
        String showDocumentation;
        String maxLineLength;
        String includeSubrepositories;
        Project project = formatSourceTask.getProject();
        String gitWorkingBranchName = GradleUtil.getProperty((ExtensionAware)project, (String)"git.working.branch.name", (String)null);
        if (Validator.isNotNull((String)gitWorkingBranchName)) {
            formatSourceTask.setGitWorkingBranchName(gitWorkingBranchName);
        }
        if (Validator.isNotNull((String)(includeSubrepositories = GradleUtil.getProperty((ExtensionAware)project, (String)"source.formatter.include.subrepositories", (String)null)))) {
            formatSourceTask.setIncludeSubrepositories(Boolean.parseBoolean(includeSubrepositories));
        }
        if (Validator.isNotNull((String)(maxLineLength = GradleUtil.getProperty((ExtensionAware)project, (String)"source.formatter.max.line.length", (String)null)))) {
            formatSourceTask.setMaxLineLength(Integer.parseInt(maxLineLength));
        }
        if (Validator.isNotNull((String)(showDocumentation = GradleUtil.getProperty((ExtensionAware)project, (String)"source.formatter.show.documentation", (String)null)))) {
            formatSourceTask.setShowDocumentation(Boolean.parseBoolean(showDocumentation));
        }
        if (Validator.isNotNull((String)(processorThreadCount = GradleUtil.getProperty((ExtensionAware)project, (String)"source.formatter.processor.thread.count", (String)null)))) {
            formatSourceTask.setProcessorThreadCount(Integer.parseInt(processorThreadCount));
        }
    }

    private void _configureTasksFormatSource(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(FormatSourceTask.class, (Action)new Action<FormatSourceTask>(){

            public void execute(FormatSourceTask formatSourceTask) {
                SourceFormatterDefaultsPlugin.this._configureTasksFormatSource(formatSourceTask);
            }
        });
    }
}

