/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.tasks;

import com.liferay.gogo.shell.client.GogoShellClient;
import com.liferay.gradle.plugins.internal.util.FileUtil;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.util.ArrayUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.gradle.util.GUtil;
import org.osgi.framework.dto.BundleDTO;

public class WatchTask
extends DefaultTask {
    private static final Map<File, Attributes> _installedAttributes = new HashMap<File, Attributes>();
    private static final Pattern _installResponsePattern = Pattern.compile(".*Bundle ID: (.*$).*", 40);
    private Object _bundleDir;
    private Object _bundleSymbolicName;
    private final Set<String> _classLoaderFileExtensions = new LinkedHashSet<String>();
    private FileCollection _fragmentsFileCollection;
    private final Set<String> _ignoredManifestKeys = new LinkedHashSet<String>();

    public WatchTask() {
        this.classLoaderFileExtensions(".class", ".jsp", ".jspf", ".properties");
        this.ignoredManifestKeys("Bnd-LastModified");
    }

    public WatchTask classLoaderFileExtensions(Iterable<String> classLoaderFileExtensions) {
        GUtil.addToCollection(this._classLoaderFileExtensions, (Iterable[])new Iterable[]{classLoaderFileExtensions});
        return this;
    }

    public WatchTask classLoaderFileExtensions(String ... classLoaderFileExtensions) {
        return this.classLoaderFileExtensions(Arrays.asList(classLoaderFileExtensions));
    }

    @InputDirectory
    public File getBundleDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._bundleDir);
    }

    @Input
    public String getBundleSymbolicName() {
        return GradleUtil.toString((Object)this._bundleSymbolicName);
    }

    @Input
    public Set<String> getClassLoaderFileExtensions() {
        return this._classLoaderFileExtensions;
    }

    @InputFiles
    @Optional
    public FileCollection getFragments() {
        return this._fragmentsFileCollection;
    }

    @Input
    public Set<String> getIgnoredManifestKeys() {
        return this._ignoredManifestKeys;
    }

    @OutputFile
    public File getOutputFile() {
        Project project = this.getProject();
        return new File(project.getBuildDir(), "installedBundleId");
    }

    public WatchTask ignoredManifestKeys(Iterable<String> ignoredManifestKeys) {
        GUtil.addToCollection(this._ignoredManifestKeys, (Iterable[])new Iterable[]{ignoredManifestKeys});
        return this;
    }

    public WatchTask ignoredManifestKeys(String ... ignoredManifestKeys) {
        return this.ignoredManifestKeys(Arrays.asList(ignoredManifestKeys));
    }

    public void setBundleDir(Object bundleDir) {
        this._bundleDir = bundleDir;
    }

    public void setBundleSymbolicName(Object bundleSymbolicName) {
        this._bundleSymbolicName = bundleSymbolicName;
    }

    public void setClassLoaderFileExtensions(Iterable<String> classLoaderFileExtensions) {
        this._classLoaderFileExtensions.clear();
        this.classLoaderFileExtensions(classLoaderFileExtensions);
    }

    public void setClassLoaderFileExtensions(String ... classLoaderFileExtensions) {
        this.setClassLoaderFileExtensions(Arrays.asList(classLoaderFileExtensions));
    }

    public void setFragments(FileCollection fragmentsFileCollection) {
        this._fragmentsFileCollection = fragmentsFileCollection;
    }

    public void setIgnoredManifestKeys(Iterable<String> ignoredManifestKeys) {
        this._ignoredManifestKeys.clear();
        this.ignoredManifestKeys(ignoredManifestKeys);
    }

    public void setIgnoredManifestKeys(String ... ignoredManifestKeys) {
        this.setIgnoredManifestKeys(Arrays.asList(ignoredManifestKeys));
    }

    @TaskAction
    public void watch(IncrementalTaskInputs incrementalTaskInputs) throws IOException {
        Project project = this.getProject();
        Gradle gradle = project.getGradle();
        StartParameter startParameter = gradle.getStartParameter();
        if (!startParameter.isContinuous()) {
            throw new GradleException("Task must be executed in continuous mode: gradle watch (-t | --continuous)");
        }
        Logger logger = this.getLogger();
        long installedBundleId = -1L;
        try (GogoShellClient gogoShellClient = new GogoShellClient();){
            installedBundleId = this._getInstalledBundleId(gogoShellClient);
            if (installedBundleId < 1L || !incrementalTaskInputs.isIncremental()) {
                this._installOrUpdateBundle(installedBundleId, gogoShellClient);
                return;
            }
            List<File> modifiedFiles = this._getModifiedFiles(incrementalTaskInputs);
            if (this._isManifestChanged(modifiedFiles)) {
                this._installOrUpdateBundle(installedBundleId, gogoShellClient);
                return;
            }
            if (this._isClassLoaderFileChanged(modifiedFiles)) {
                this._refreshBundle(installedBundleId, gogoShellClient);
                if (this._isFragmentModule()) {
                    this._refreshFragmentHostBundle(gogoShellClient);
                }
                return;
            }
            if (logger.isQuietEnabled()) {
                if (modifiedFiles.isEmpty()) {
                    logger.quiet("No files changed. Skipping bundle refresh.");
                } else {
                    logger.quiet("Only resources changed. Skipping bundle refresh.");
                }
            }
        }
    }

    private static long _getBundleId(String bundleSymbolicName, GogoShellClient gogoShellClient) throws IOException {
        String command = String.format("lb -s %s", bundleSymbolicName);
        String response = WatchTask._sendGogoShellCommand(gogoShellClient, command);
        try (Scanner scanner = new Scanner(response);){
            String gogoLine;
            BundleDTO bundleDTO;
            ArrayList<String> lines = new ArrayList<String>();
            while (scanner.hasNextLine()) {
                lines.add(scanner.nextLine());
            }
            if (lines.size() > 2 && (bundleDTO = WatchTask._parseBundleDTO(gogoLine = (String)lines.get(2))) != null) {
                String symbolicName = bundleDTO.symbolicName;
                if (symbolicName.indexOf(40) > 0) {
                    symbolicName = symbolicName.substring(0, symbolicName.indexOf("(") - 1);
                }
                if (bundleSymbolicName.equals(symbolicName)) {
                    long l = bundleDTO.id;
                    return l;
                }
            }
        }
        return -1L;
    }

    private static <K, V> Map<K, V> _getDifferences(Map<? extends K, ? extends V> leftMap, Map<? extends K, ? extends V> rightMap) {
        HashMap<K, V> differences = new HashMap<K, V>();
        differences.putAll(leftMap);
        differences.putAll(rightMap);
        Set entrySet = differences.entrySet();
        if (leftMap.size() <= rightMap.size()) {
            entrySet.removeAll(leftMap.entrySet());
        } else {
            entrySet.removeAll(rightMap.entrySet());
        }
        return differences;
    }

    private static final int _getState(String state) {
        String bundleState = state.toUpperCase();
        if ("ACTIVE".equals(bundleState)) {
            return 32;
        }
        if ("INSTALLED".equals(bundleState)) {
            return 2;
        }
        if ("RESOLVED".equals(bundleState)) {
            return 4;
        }
        if ("STARTING".equals(bundleState)) {
            return 8;
        }
        if ("STOPPING".equals(bundleState)) {
            return 16;
        }
        if ("UNINSTALLED".equals(bundleState)) {
            return 1;
        }
        return 0;
    }

    private static boolean _isWarDir(File file) {
        if (!file.isDirectory()) {
            return false;
        }
        File webInfDir = new File(file, "WEB-INF");
        return webInfDir.exists();
    }

    private static final BundleDTO _newBundleDTO(Long id, int state, String symbolicName) {
        BundleDTO bundle = new BundleDTO();
        bundle.id = id;
        bundle.state = state;
        bundle.symbolicName = symbolicName;
        return bundle;
    }

    private static final BundleDTO _parseBundleDTO(String line) {
        String[] fields = line.split("\\|");
        Long id = Long.parseLong(fields[0].trim());
        int state = WatchTask._getState(fields[1].trim());
        String symbolicName = fields[3];
        return WatchTask._newBundleDTO(id, state, symbolicName);
    }

    private static String _sendGogoShellCommand(GogoShellClient gogoShellClient, String command) throws IOException {
        String response = gogoShellClient.send(command);
        if (response.startsWith(command)) {
            response = response.substring(command.length());
            response = response.trim();
        }
        return response;
    }

    private String _getFragmentHost() throws IOException {
        Project project = this.getProject();
        ConfigurableFileCollection fileCollection = project.files(new Object[]{"bnd.bnd"});
        if (fileCollection != null) {
            File file = fileCollection.getSingleFile();
            Properties properties = FileUtil.readProperties((File)file);
            return properties.getProperty("Fragment-Host");
        }
        return null;
    }

    private String _getFragmentHostName() throws IOException {
        Object[] fragmentNames;
        String fragmentHost = this._getFragmentHost();
        if (fragmentHost != null && ArrayUtil.isNotEmpty((Object[])(fragmentNames = fragmentHost.split(";")))) {
            return fragmentNames[0];
        }
        return null;
    }

    private long _getInstalledBundleId(GogoShellClient gogoShellClient) throws IOException {
        String bundleSymbolicName;
        File outputFile = this.getOutputFile();
        if (outputFile.exists()) {
            try {
                String installedBundleID = new String(Files.readAllBytes(outputFile.toPath()));
                return Long.parseLong(installedBundleID);
            }
            catch (Exception installedBundleID) {
                // empty catch block
            }
        }
        if ((bundleSymbolicName = this.getBundleSymbolicName()) == null) {
            File manifestFile = new File(this.getBundleDir(), "META-INF/MANIFEST.MF");
            bundleSymbolicName = FileUtil.readManifestAttribute(manifestFile, "Bundle-SymbolicName");
        }
        return WatchTask._getBundleId(bundleSymbolicName, gogoShellClient);
    }

    private List<File> _getModifiedFiles(IncrementalTaskInputs incrementalTaskInputs) {
        final ArrayList<File> modifiedFiles = new ArrayList<File>();
        incrementalTaskInputs.outOfDate((Action)new Action<InputFileDetails>(){

            public void execute(InputFileDetails inputFileDetails) {
                if (inputFileDetails.isAdded() || inputFileDetails.isModified()) {
                    modifiedFiles.add(inputFileDetails.getFile());
                }
            }
        });
        incrementalTaskInputs.removed((Action)new Action<InputFileDetails>(){

            public void execute(InputFileDetails inputFileDetails) {
                if (inputFileDetails.isRemoved()) {
                    modifiedFiles.add(inputFileDetails.getFile());
                }
            }
        });
        return modifiedFiles;
    }

    private String _getReferenceInstallURL(File file) {
        URI uri = file.toURI();
        if (WatchTask._isWarDir(file)) {
            return String.format("webbundledir:%s?Bundle-SymbolicName=%s&Web-ContextPath=/%s", uri.toASCIIString(), this.getBundleSymbolicName(), this.getBundleSymbolicName());
        }
        return "reference:" + uri.toASCIIString();
    }

    private long _installBundle(File file, GogoShellClient gogoShellClient, boolean start) throws IOException {
        long bundleId = -1L;
        String url = this._getReferenceInstallURL(file);
        String command = String.format("install '%s'", url);
        String response = WatchTask._sendGogoShellCommand(gogoShellClient, command);
        Matcher matcher = _installResponsePattern.matcher(response);
        Logger logger = this.getLogger();
        if (matcher.matches()) {
            if (logger.isQuietEnabled()) {
                logger.quiet("Installed bundle at {}", new Object[]{file});
            }
            String bundleIdString = matcher.group(1);
            bundleId = Long.parseLong(bundleIdString);
        }
        if (start) {
            this._startBundle(bundleId, gogoShellClient);
        }
        if (bundleId < 0L) {
            logger.error("Unable to install bundle: {}", (Object)response);
        }
        return bundleId;
    }

    private void _installOrUpdateBundle(long bundleId, GogoShellClient gogoShellClient) throws IOException {
        File bundleDir = this.getBundleDir();
        if (bundleId > 0L) {
            this._updateBundle(bundleDir, bundleId, gogoShellClient);
        } else {
            bundleId = this._installBundle(bundleDir, gogoShellClient, true);
        }
        File manifestFile = new File(bundleDir, "META-INF/MANIFEST.MF");
        try (FileInputStream inputStream = new FileInputStream(manifestFile);){
            Manifest manifest = new Manifest(inputStream);
            Attributes attributes = manifest.getMainAttributes();
            _installedAttributes.put(bundleDir, attributes);
        }
        FileCollection fileCollection = this.getFragments();
        boolean installedFragment = false;
        if (fileCollection != null) {
            Set files = fileCollection.getFiles();
            for (File file : files) {
                long fragmentBundleId;
                if (!file.exists() || (fragmentBundleId = this._installBundle(file, gogoShellClient, false)) <= 0L) continue;
                installedFragment = true;
            }
            if (this._isFragmentModule()) {
                this._refreshFragmentHostBundle(gogoShellClient);
            }
        }
        String bundleIdString = String.valueOf(bundleId);
        File outputFile = this.getOutputFile();
        Files.write(outputFile.toPath(), bundleIdString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        if (installedFragment) {
            this._refreshBundle(bundleId, gogoShellClient);
        }
    }

    private boolean _isClassLoaderFileChanged(List<File> modifiedFiles) {
        for (File file : modifiedFiles) {
            String extension = FileUtil.getExtension(file);
            if (!this._classLoaderFileExtensions.contains(extension)) continue;
            return true;
        }
        return false;
    }

    private boolean _isFragmentModule() throws IOException {
        return this._getFragmentHost() != null;
    }

    private boolean _isManifestChanged(List<File> modifiedFiles) throws IOException {
        Object absolutePath;
        File manifestFile = null;
        for (File file : modifiedFiles) {
            absolutePath = FileUtil.getAbsolutePath((File)file);
            if (!((String)absolutePath).endsWith("/META-INF/MANIFEST.MF")) continue;
            manifestFile = file;
            break;
        }
        if (manifestFile == null) {
            return false;
        }
        Map<Object, Object> differences = null;
        FileInputStream inputStream = new FileInputStream(manifestFile);
        absolutePath = null;
        try {
            Manifest manifest = new Manifest(inputStream);
            Attributes attributes = manifest.getMainAttributes();
            differences = WatchTask._getDifferences(attributes, _installedAttributes.get(this.getBundleDir()));
        }
        catch (Throwable manifest) {
            absolutePath = manifest;
            throw manifest;
        }
        finally {
            if (inputStream != null) {
                if (absolutePath != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable manifest) {
                        ((Throwable)absolutePath).addSuppressed(manifest);
                    }
                } else {
                    ((InputStream)inputStream).close();
                }
            }
        }
        Set<Map.Entry<Object, Object>> entrySet = differences.entrySet();
        Iterator<Map.Entry<Object, Object>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String key = String.valueOf(entry.getKey());
            if (!this._ignoredManifestKeys.contains(key)) continue;
            iterator.remove();
        }
        if (differences.isEmpty()) {
            return false;
        }
        Logger logger = this.getLogger();
        if (logger.isQuietEnabled()) {
            logger.quiet("Detected differences in manifest: {}", new Object[]{differences});
        }
        return true;
    }

    private void _refreshBundle(long bundleId, GogoShellClient gogoShellClient) throws IOException {
        String command = String.format("refresh %s", bundleId);
        WatchTask._sendGogoShellCommand(gogoShellClient, command);
        Logger logger = this.getLogger();
        if (logger.isQuietEnabled()) {
            logger.quiet("Refreshed bundle {}", new Object[]{bundleId});
        }
    }

    private void _refreshFragmentHostBundle(GogoShellClient gogoShellClient) throws IOException {
        long fragmentHostBundleId = WatchTask._getBundleId(this._getFragmentHostName(), gogoShellClient);
        if (fragmentHostBundleId > 0L) {
            this._refreshBundle(fragmentHostBundleId, gogoShellClient);
        }
    }

    private void _startBundle(long bundleId, GogoShellClient gogoShellClient) throws IOException {
        String command = String.format("start %s", bundleId);
        String response = WatchTask._sendGogoShellCommand(gogoShellClient, command);
        Logger logger = this.getLogger();
        if (logger.isQuietEnabled()) {
            logger.quiet("Bundle {} started. {}", new Object[]{bundleId, response});
        }
    }

    private void _updateBundle(File bundleDir, long bundleId, GogoShellClient gogoShellClient) throws IOException {
        Logger logger = this.getLogger();
        if (logger.isQuietEnabled()) {
            logger.quiet("Updating bundle {} from {}", new Object[]{bundleId, bundleDir});
        }
        String url = this._getReferenceInstallURL(bundleDir);
        String command = String.format("update %s '%s'", bundleId, url);
        String response = WatchTask._sendGogoShellCommand(gogoShellClient, command);
        if (logger.isQuietEnabled()) {
            logger.quiet("Bundle {} updated.\n{}\n", new Object[]{bundleId, response});
        }
    }
}

