/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.css.builder.CSSBuilderPlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.internal.CSSBuilderDefaultsPlugin;
import com.liferay.gradle.plugins.internal.EclipseDefaultsPlugin;
import com.liferay.gradle.plugins.internal.IdeaDefaultsPlugin;
import com.liferay.gradle.plugins.internal.WatchOSGiPlugin;
import com.liferay.gradle.plugins.internal.XMLFormatterDefaultsPlugin;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.source.formatter.SourceFormatterPlugin;
import com.liferay.gradle.plugins.xml.formatter.XMLFormatterPlugin;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileTree;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.java.archives.ManifestMergeDetails;
import org.gradle.api.java.archives.ManifestMergeSpec;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.util.VersionNumber;

public class LiferayOSGiExtPlugin
implements Plugin<Project> {
    public static final String ORIGINAL_MODULE_CONFIGURATION_NAME = "originalModule";
    public static final String UNZIP_ORIGINAL_MODULE_TASK_NAME = "unzipOriginalModule";
    private static final String _VERSION_SUFFIX = "ext";

    public void apply(Project project) {
        this._applyPlugins(project);
        Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
        final Configuration originalModuleConfiguration = this._addConfigurationOriginalModule(project);
        Sync unzipOriginalModuleTask = this._addTaskUnzipOriginalModule(project, originalModuleConfiguration);
        this._configureConfigurationCompileOnly(project, originalModuleConfiguration);
        this._configureLiferay(project);
        this._configureTaskDeploy(jar);
        this._configureTaskJar(jar, unzipOriginalModuleTask);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                LiferayOSGiExtPlugin.this._configureProject(project, originalModuleConfiguration);
            }
        });
    }

    private Configuration _addConfigurationOriginalModule(Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)ORIGINAL_MODULE_CONFIGURATION_NAME);
        configuration.setDescription("Configures the original module to extend.");
        configuration.setTransitive(false);
        configuration.setVisible(false);
        return configuration;
    }

    private Sync _addTaskUnzipOriginalModule(final Project project, final Configuration configuration) {
        Sync sync = (Sync)GradleUtil.addTask((Project)project, (String)UNZIP_ORIGINAL_MODULE_TASK_NAME, Sync.class);
        sync.from(new Object[]{new Callable<FileTree>(){

            @Override
            public FileTree call() {
                return project.zipTree((Object)configuration.getSingleFile());
            }
        }});
        sync.into((Object)new Callable<File>(){

            @Override
            public File call() {
                return new File(project.getBuildDir(), "original-module");
            }
        });
        sync.setDescription("Unzips the original module into a temporary directory.");
        return sync;
    }

    private void _applyPlugins(Project project) {
        GradleUtil.applyPlugin((Project)project, CSSBuilderPlugin.class);
        GradleUtil.applyPlugin((Project)project, EclipsePlugin.class);
        GradleUtil.applyPlugin((Project)project, IdeaPlugin.class);
        GradleUtil.applyPlugin((Project)project, JavaPlugin.class);
        GradleUtil.applyPlugin((Project)project, LiferayBasePlugin.class);
        GradleUtil.applyPlugin((Project)project, SourceFormatterPlugin.class);
        GradleUtil.applyPlugin((Project)project, XMLFormatterPlugin.class);
        CSSBuilderDefaultsPlugin.INSTANCE.apply((Object)project);
        EclipseDefaultsPlugin.INSTANCE.apply((Object)project);
        IdeaDefaultsPlugin.INSTANCE.apply((Object)project);
        WatchOSGiPlugin.INSTANCE.apply((Object)project);
        XMLFormatterDefaultsPlugin.INSTANCE.apply((Object)project);
    }

    private Configuration _configureConfigurationCompileOnly(Project project, Configuration originalModuleConfiguration) {
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"compileOnly");
        configuration.extendsFrom(new Configuration[]{originalModuleConfiguration});
        return configuration;
    }

    private void _configureLiferay(Project project) {
        final LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        liferayExtension.setDeployDir(new Callable<File>(){

            @Override
            public File call() {
                return new File(liferayExtension.getAppServerParentDir(), "osgi/marketplace/override");
            }
        });
    }

    private void _configureProject(Project project, Configuration originalModuleConfiguration) {
        try (JarFile jarFile = new JarFile(originalModuleConfiguration.getSingleFile());){
            java.util.jar.Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String version = attributes.getValue("Bundle-Version");
            VersionNumber versionNumber = VersionNumber.parse((String)version);
            version = Validator.isNull((String)versionNumber.getQualifier()) ? version + ".ext" : version + "-ext";
            project.setVersion((Object)version);
            BasePluginConvention basePluginConvention = (BasePluginConvention)GradleUtil.getConvention((Project)project, BasePluginConvention.class);
            basePluginConvention.setArchivesBaseName(attributes.getValue("Bundle-SymbolicName"));
        }
        catch (IOException ioe) {
            throw new UncheckedIOException((Throwable)ioe);
        }
    }

    private void _configureTaskDeploy(Jar jar) {
        Copy copy = (Copy)GradleUtil.getTask((Project)jar.getProject(), (String)"deploy");
        copy.from(new Object[]{jar});
    }

    private Jar _configureTaskJar(final Jar jar, final Sync unzipOriginalModuleTask) {
        jar.dependsOn(new Object[]{unzipOriginalModuleTask});
        jar.from(new Object[]{new Callable<File>(){

            @Override
            public File call() throws Exception {
                return unzipOriginalModuleTask.getDestinationDir();
            }
        }});
        jar.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
        Manifest manifest = jar.getManifest();
        manifest.attributes(Collections.singletonMap("Bundle-Version", new Object(){

            public String toString() {
                return jar.getVersion();
            }
        }));
        manifest.from((Object)new Callable<File>(){

            @Override
            public File call() {
                return new File(unzipOriginalModuleTask.getDestinationDir(), "META-INF/MANIFEST.MF");
            }
        }, (Closure)new Closure<Void>((Object)jar){

            public void doCall(ManifestMergeSpec manifestMergeSpec) {
                manifestMergeSpec.eachEntry((Action)new Action<ManifestMergeDetails>(){

                    public void execute(ManifestMergeDetails manifestMergeDetails) {
                        if ("Bundle-Version".equals(manifestMergeDetails.getKey())) {
                            manifestMergeDetails.setValue(manifestMergeDetails.getBaseValue());
                        }
                    }
                });
            }
        });
        return jar;
    }
}

