/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.extensions.AppServer;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.internal.NodeDefaultsPlugin;
import com.liferay.gradle.plugins.internal.SourceFormatterDefaultsPlugin;
import com.liferay.gradle.plugins.internal.util.FileUtil;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.tasks.DirectDeployTask;
import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskContainer;

public class LiferayBasePlugin
implements Plugin<Project> {
    public static final String DEPLOY_TASK_NAME = "deploy";
    public static final String PORTAL_CONFIGURATION_NAME = "portal";

    public void apply(Project project) {
        LiferayExtension liferayExtension = this._addLiferayExtension(project);
        NodeDefaultsPlugin.INSTANCE.apply((Object)project);
        SourceFormatterDefaultsPlugin.INSTANCE.apply((Object)project);
        this._addConfigurationPortal(project, liferayExtension);
        this._addTaskDeploy(project, liferayExtension);
        this._configureConfigurations(project, liferayExtension);
        this._configureTasksDirectDeploy(project, liferayExtension);
    }

    private Configuration _addConfigurationPortal(final Project project, final LiferayExtension liferayExtension) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)PORTAL_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                LiferayBasePlugin.this._addDependenciesPortal(project, liferayExtension);
            }
        });
        configuration.setDescription("Configures the classpath from the local Liferay bundle.");
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesPortal(Project project, LiferayExtension liferayExtension) {
        File appServerClassesPortalDir = new File(liferayExtension.getAppServerPortalDir(), "WEB-INF/classes");
        GradleUtil.addDependency((Project)project, (String)PORTAL_CONFIGURATION_NAME, (File)appServerClassesPortalDir);
        File appServerLibPortalDir = new File(liferayExtension.getAppServerPortalDir(), "WEB-INF/lib");
        FileTree appServerLibPortalDirJarFiles = FileUtil.getJarsFileTree(project, appServerLibPortalDir, new String[0]);
        GradleUtil.addDependency((Project)project, (String)PORTAL_CONFIGURATION_NAME, (FileCollection)appServerLibPortalDirJarFiles);
        FileTree appServerLibGlobalDirJarFiles = FileUtil.getJarsFileTree(project, liferayExtension.getAppServerLibGlobalDir(), "mail.jar");
        GradleUtil.addDependency((Project)project, (String)PORTAL_CONFIGURATION_NAME, (FileCollection)appServerLibGlobalDirJarFiles);
        GradleUtil.addDependency((Project)project, (String)PORTAL_CONFIGURATION_NAME, (String)"com.liferay", (String)"net.sf.jargs", (String)"1.0");
        GradleUtil.addDependency((Project)project, (String)PORTAL_CONFIGURATION_NAME, (String)"com.thoughtworks.qdox", (String)"qdox", (String)"1.12.1");
        GradleUtil.addDependency((Project)project, (String)PORTAL_CONFIGURATION_NAME, (String)"javax.activation", (String)"activation", (String)"1.1");
        GradleUtil.addDependency((Project)project, (String)PORTAL_CONFIGURATION_NAME, (String)"javax.servlet", (String)"javax.servlet-api", (String)"3.0.1");
        GradleUtil.addDependency((Project)project, (String)PORTAL_CONFIGURATION_NAME, (String)"javax.servlet.jsp", (String)"javax.servlet.jsp-api", (String)"2.3.1");
        AppServer appServer = liferayExtension.getAppServer();
        appServer.addAdditionalDependencies(PORTAL_CONFIGURATION_NAME);
    }

    private LiferayExtension _addLiferayExtension(Project project) {
        LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.addExtension((ExtensionAware)project, (String)"liferay", LiferayExtension.class);
        GradleUtil.applyScript((Project)project, (String)"com/liferay/gradle/plugins/dependencies/config-liferay.gradle", (Object)project);
        return liferayExtension;
    }

    private Copy _addTaskDeploy(Project project, final LiferayExtension liferayExtension) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)DEPLOY_TASK_NAME, Copy.class);
        copy.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return liferayExtension.getDeployDir();
            }
        });
        copy.setDescription("Assembles the project and deploys it to Liferay.");
        copy.setGroup("build");
        return copy;
    }

    private void _configureConfigurations(Project project, final LiferayExtension liferayExtension) {
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Action<Configuration> action = new Action<Configuration>(){

            public void execute(Configuration configuration) {
                ResolutionStrategy resolutionStrategy = configuration.getResolutionStrategy();
                resolutionStrategy.eachDependency((Action)new Action<DependencyResolveDetails>(){

                    public void execute(DependencyResolveDetails dependencyResolveDetails) {
                        ModuleVersionSelector moduleVersionSelector = dependencyResolveDetails.getRequested();
                        String version = moduleVersionSelector.getVersion();
                        if (!version.equals("default")) {
                            return;
                        }
                        version = liferayExtension.getDefaultVersion(moduleVersionSelector);
                        dependencyResolveDetails.useVersion(version);
                    }
                });
            }
        };
        configurationContainer.all((Action)action);
    }

    private void _configureTaskDirectDeploy(DirectDeployTask directDeployTask, final LiferayExtension liferayExtension) {
        directDeployTask.setAppServerDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return liferayExtension.getAppServerDir();
            }
        });
        directDeployTask.setAppServerLibGlobalDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return liferayExtension.getAppServerLibGlobalDir();
            }
        });
        directDeployTask.setAppServerPortalDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return liferayExtension.getAppServerPortalDir();
            }
        });
        directDeployTask.setAppServerType(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return liferayExtension.getAppServerType();
            }
        });
    }

    private void _configureTasksDirectDeploy(Project project, final LiferayExtension liferayExtension) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(DirectDeployTask.class, (Action)new Action<DirectDeployTask>(){

            public void execute(DirectDeployTask directDeployTask) {
                LiferayBasePlugin.this._configureTaskDirectDeploy(directDeployTask, liferayExtension);
            }
        });
    }
}

