/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.extensions;

import com.liferay.gradle.plugins.extensions.AppServer;
import com.liferay.gradle.plugins.internal.extensions.AppServerFactory;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.plugins.ExtensionAware;

public class LiferayExtension {
    protected final Project project;
    private Object _appServerParentDir;
    private final NamedDomainObjectContainer<AppServer> _appServers;
    private String _appServerType;
    private final Map<String, Object> _defaultVersions = new HashMap<String, Object>();
    private Object _deployDir;
    private Object _jmxRemotePort;
    private Object _liferayHome;

    public LiferayExtension(Project project) {
        this.project = project;
        this._appServers = project.container(AppServer.class, (NamedDomainObjectFactory)new AppServerFactory(project));
    }

    public void appServers(Closure<?> closure) {
        this._appServers.configure(closure);
    }

    public void defaultDependencyNotation(String group, String name, Object version) {
        String dependencyNotation = this._getDependencyNotation(group, name);
        this._defaultVersions.put(dependencyNotation, version);
    }

    public AppServer getAppServer() {
        return this.getAppServer(this.getAppServerType());
    }

    public AppServer getAppServer(String type) {
        return (AppServer)this._appServers.getAt(type);
    }

    public File getAppServerDeployDir() {
        AppServer appServer = this.getAppServer();
        return appServer.getDeployDir();
    }

    public File getAppServerDir() {
        AppServer appServer = this.getAppServer();
        return appServer.getDir();
    }

    public File getAppServerLibGlobalDir() {
        AppServer appServer = this.getAppServer();
        return appServer.getLibGlobalDir();
    }

    public File getAppServerParentDir() {
        return this.project.file(this._appServerParentDir);
    }

    public File getAppServerPortalDir() {
        AppServer appServer = this.getAppServer();
        return appServer.getPortalDir();
    }

    public NamedDomainObjectContainer<AppServer> getAppServers() {
        return this._appServers;
    }

    public String getAppServerType() {
        return this._appServerType;
    }

    public String getDefaultVersion(ModuleVersionSelector moduleVersionSelector) {
        return this.getDefaultVersion(moduleVersionSelector.getGroup(), moduleVersionSelector.getName());
    }

    public String getDefaultVersion(String group, String name) {
        return this.getDefaultVersion(group, name, "latest.release");
    }

    public String getDefaultVersion(String group, String name, String defaultVersion) {
        String dependencyNotation = this._getDependencyNotation(group, name);
        String version = GradleUtil.toString((Object)this._defaultVersions.get(dependencyNotation));
        if (Validator.isNull((String)version)) {
            version = GradleUtil.getProperty((ExtensionAware)this.project, (String)(group + "." + name + ".version"), (String)null);
            if (Validator.isNull((String)version)) {
                version = GradleUtil.getProperty((ExtensionAware)this.project, (String)(name + ".version"), (String)defaultVersion);
            }
            this._defaultVersions.put(dependencyNotation, version);
        }
        return version;
    }

    public File getDeployDir() {
        return this.project.file(this._deployDir);
    }

    public int getJmxRemotePort() {
        Integer jmxRemotePort = GradleUtil.toInteger((Object)this._jmxRemotePort);
        if (jmxRemotePort != null) {
            return jmxRemotePort;
        }
        return 0;
    }

    public File getLiferayHome() {
        return this.project.file(this._liferayHome);
    }

    public void setAppServerParentDir(Object appServerParentDir) {
        this._appServerParentDir = appServerParentDir;
    }

    public void setAppServerType(String appServerType) {
        this._appServerType = appServerType;
    }

    public void setDeployDir(Object deployDir) {
        this._deployDir = deployDir;
    }

    public void setJmxRemotePort(Object jmxRemotePort) {
        this._jmxRemotePort = jmxRemotePort;
    }

    public void setLiferayHome(Object liferayHome) {
        this._liferayHome = liferayHome;
    }

    private String _getDependencyNotation(String group, String name) {
        return group + ":" + name;
    }
}

