/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.LiferayAntPlugin;
import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.LiferayOSGiPlugin;
import com.liferay.gradle.plugins.LiferayThemePlugin;
import com.liferay.gradle.plugins.internal.util.FileUtil;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class LiferayPlugin
implements Plugin<Project> {
    public static final String PLUGIN_NAME = "liferay";

    public void apply(Project project) {
        Class<? extends Plugin<Project>> clazz = this.isAnt(project) ? this.getAntPluginClass() : (this.isOSGi(project) ? this.getOSGiPluginClass() : (this.isTheme(project) ? this.getThemePluginClass() : this.getBasePluginClass()));
        GradleUtil.applyPlugin((Project)project, clazz);
    }

    protected Class<? extends Plugin<Project>> getAntPluginClass() {
        return LiferayAntPlugin.class;
    }

    protected Class<? extends Plugin<Project>> getBasePluginClass() {
        return LiferayBasePlugin.class;
    }

    protected Class<? extends Plugin<Project>> getOSGiPluginClass() {
        return LiferayOSGiPlugin.class;
    }

    protected Class<? extends Plugin<Project>> getThemePluginClass() {
        return LiferayThemePlugin.class;
    }

    protected boolean isAnt(Project project) {
        return FileUtil.exists((Project)project, (String)"build.xml");
    }

    protected boolean isOSGi(Project project) {
        return FileUtil.exists((Project)project, (String)"bnd.bnd");
    }

    protected boolean isTheme(Project project) {
        String gulpFileContent;
        File gulpFile = project.file((Object)"gulpfile.js");
        if (!gulpFile.exists()) {
            return false;
        }
        try {
            gulpFileContent = new String(Files.readAllBytes(gulpFile.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException ioe) {
            throw new GradleException("Unable to read " + gulpFile, (Throwable)ioe);
        }
        return gulpFileContent.contains("require('liferay-theme-tasks')");
    }
}

