/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.tasks;

import com.liferay.gradle.plugins.internal.util.FileUtil;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.OutputDirectories;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

public class BuildDBTask
extends JavaExec {
    private Object _databaseName;
    private final Set<Object> _databaseTypes = new LinkedHashSet<Object>();
    private Object _sqlDir;

    public BuildDBTask() {
        this.setMain("com.liferay.portal.tools.DBBuilder");
        this.setMaxHeapSize("384m");
        this.systemProperty("external-properties", "com/liferay/portal/tools/dependencies/portal-tools.properties");
    }

    public BuildDBTask databaseTypes(Iterable<Object> databaseTypes) {
        GUtil.addToCollection(this._databaseTypes, (Iterable[])new Iterable[]{databaseTypes});
        return this;
    }

    public BuildDBTask databaseTypes(Object ... databaseTypes) {
        return this.databaseTypes(Arrays.asList(databaseTypes));
    }

    public void exec() {
        this.setArgs(this.getCompleteArgs());
        super.exec();
    }

    @Input
    public String getDatabaseName() {
        return GradleUtil.toString((Object)this._databaseName);
    }

    @Input
    public List<String> getDatabaseTypes() {
        return GradleUtil.toStringList(this._databaseTypes);
    }

    @OutputDirectories
    public Iterable<File> getOutputDirs() {
        File sqlDir = this.getSqlDir();
        return Arrays.asList(new File(sqlDir, "create"), new File(sqlDir, "create-bare"), new File(sqlDir, "indexes"), new File(sqlDir, "tables"));
    }

    @InputDirectory
    public File getSqlDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._sqlDir);
    }

    public void setDatabaseName(Object databaseName) {
        this._databaseName = databaseName;
    }

    public void setDatabaseTypes(Iterable<Object> databaseTypes) {
        this._databaseTypes.clear();
        this.databaseTypes(databaseTypes);
    }

    public void setDatabaseTypes(Object ... databaseTypes) {
        this.setDatabaseTypes(Arrays.asList(databaseTypes));
    }

    public void setSqlDir(Object sqlDir) {
        this._sqlDir = sqlDir;
    }

    protected List<String> getCompleteArgs() {
        ArrayList<String> args = new ArrayList<String>(this.getArgs());
        args.add("db.database.name=" + this.getDatabaseName());
        args.add("db.database.types=" + CollectionUtils.join((String)",", this.getDatabaseTypes()));
        args.add("db.sql.dir=" + FileUtil.getAbsolutePath((File)this.getSqlDir()));
        return args;
    }
}

