/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.internal;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.node.NodePlugin;
import com.liferay.gradle.plugins.node.tasks.ExecuteNpmTask;
import com.liferay.gradle.plugins.node.tasks.NpmInstallTask;
import com.liferay.gradle.plugins.node.tasks.PublishNodeModuleTask;
import com.liferay.gradle.util.Validator;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.TaskContainer;

public class NodeDefaultsPlugin
extends BaseDefaultsPlugin<NodePlugin> {
    @Override
    protected void configureDefaults(Project project, NodePlugin nodePlugin) {
        this.configureTasksExecuteNpm(project);
        this.configureTasksNpmInstall(project);
        this.configureTasksPublishNodeModule(project);
    }

    protected void configureTaskExecuteNpm(ExecuteNpmTask executeNpmTask) {
        String registry = GradleUtil.getProperty((ExtensionAware)executeNpmTask.getProject(), (String)"nodejs.npm.registry", (String)null);
        if (Validator.isNotNull((String)registry)) {
            executeNpmTask.setRegistry((Object)registry);
        }
    }

    protected void configureTaskNpmInstall(NpmInstallTask npmInstallTask) {
        String removeShrinkwrappedUrls = GradleUtil.getProperty((ExtensionAware)npmInstallTask.getProject(), (String)"nodejs.npm.remove.shrinkwrapped.urls", (String)null);
        if (Validator.isNotNull((String)removeShrinkwrappedUrls)) {
            npmInstallTask.setRemoveShrinkwrappedUrls(Boolean.parseBoolean(removeShrinkwrappedUrls));
        }
    }

    protected void configureTaskPublishNodeModule(PublishNodeModuleTask publishNodeModuleTask) {
        String repository;
        String userName;
        String password;
        String emailAddress;
        String license;
        String bugsUrl;
        Project project = publishNodeModuleTask.getProject();
        String author = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.module.author", (String)null);
        if (Validator.isNotNull((String)author)) {
            publishNodeModuleTask.setModuleAuthor((Object)author);
        }
        if (Validator.isNotNull((String)(bugsUrl = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.module.bugs.url", (String)null)))) {
            publishNodeModuleTask.setModuleBugsUrl((Object)bugsUrl);
        }
        if (Validator.isNotNull((String)(license = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.module.license", (String)null)))) {
            publishNodeModuleTask.setModuleLicense((Object)license);
        }
        if (Validator.isNotNull((String)(emailAddress = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.email", (String)null)))) {
            publishNodeModuleTask.setNpmEmailAddress((Object)emailAddress);
        }
        if (Validator.isNotNull((String)(password = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.password", (String)null)))) {
            publishNodeModuleTask.setNpmPassword((Object)password);
        }
        if (Validator.isNotNull((String)(userName = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.user", (String)null)))) {
            publishNodeModuleTask.setNpmUserName((Object)userName);
        }
        if (Validator.isNotNull((String)(repository = GradleUtil.getProperty((ExtensionAware)project, (String)"nodejs.npm.module.repository", (String)null)))) {
            publishNodeModuleTask.setModuleRepository((Object)repository);
        }
    }

    protected void configureTasksExecuteNpm(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(ExecuteNpmTask.class, (Action)new Action<ExecuteNpmTask>(){

            public void execute(ExecuteNpmTask executeNpmTask) {
                NodeDefaultsPlugin.this.configureTaskExecuteNpm(executeNpmTask);
            }
        });
    }

    protected void configureTasksNpmInstall(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(NpmInstallTask.class, (Action)new Action<NpmInstallTask>(){

            public void execute(NpmInstallTask npmInstallTask) {
                NodeDefaultsPlugin.this.configureTaskNpmInstall(npmInstallTask);
            }
        });
    }

    protected void configureTasksPublishNodeModule(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(PublishNodeModuleTask.class, (Action)new Action<PublishNodeModuleTask>(){

            public void execute(PublishNodeModuleTask publishNodeModuleTask) {
                NodeDefaultsPlugin.this.configureTaskPublishNodeModule(publishNodeModuleTask);
            }
        });
    }

    @Override
    protected Class<NodePlugin> getPluginClass() {
        return NodePlugin.class;
    }
}

