/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.task;

import com.liferay.gradle.plugins.internal.util.FileUtil;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

@CacheableTask
public class BuildExtInfoTask
extends JavaExec {
    private Object _baseDir;
    private Object _outputDir;
    private Object _servletContextName;

    public BuildExtInfoTask() {
        this.setMain("com.liferay.portal.tools.ExtInfoBuilder");
        this.setMaxHeapSize("256m");
    }

    public void exec() {
        this.setArgs(this._getCompleteArgs());
        super.exec();
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getBaseDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._baseDir);
    }

    public File getOutputDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._outputDir);
    }

    @OutputFile
    public File getOutputFile() {
        return new File(this.getOutputDir(), "ext-" + this.getServletContextName() + ".xml");
    }

    @Input
    public String getServletContextName() {
        return GradleUtil.toString((Object)this._servletContextName);
    }

    public void setBaseDir(Object baseDir) {
        this._baseDir = baseDir;
    }

    @Input
    public void setOutputDir(Object outputDir) {
        this._outputDir = outputDir;
    }

    public void setServletContextName(Object servletContextName) {
        this._servletContextName = servletContextName;
    }

    private List<String> _getCompleteArgs() {
        List args = this.getArgs();
        ArrayList<String> completeArgs = new ArrayList<String>(args.size() + 3);
        completeArgs.add(FileUtil.getAbsolutePath((File)this.getBaseDir()));
        completeArgs.add(FileUtil.getAbsolutePath((File)this.getOutputDir()));
        completeArgs.add(this.getServletContextName());
        completeArgs.addAll(args);
        return completeArgs;
    }
}

