/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.tasks.WatchTask;
import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.War;

public class LiferayWarPlugin
implements Plugin<Project> {
    public static final String BUILD_WAR_DIR_TASK_NAME = "buildWarDir";
    public static final String WATCH_TASK_NAME = "watch";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, WarPlugin.class);
        TaskProvider buildWarDirTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)BUILD_WAR_DIR_TASK_NAME, Sync.class);
        TaskProvider watchTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)WATCH_TASK_NAME, WatchTask.class);
        TaskProvider warTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"war", War.class);
        this._configureTaskBuildWarDirProvider(project, (TaskProvider<Sync>)buildWarDirTaskProvider, (TaskProvider<War>)warTaskProvider);
        this._configureTaskWatchProvider((TaskProvider<Sync>)buildWarDirTaskProvider, (TaskProvider<War>)warTaskProvider, (TaskProvider<WatchTask>)watchTaskProvider);
    }

    private void _configureTaskBuildWarDirProvider(final Project project, TaskProvider<Sync> buildWarDirTaskProvider, final TaskProvider<War> warTaskProvider) {
        buildWarDirTaskProvider.configure((Action)new Action<Sync>(){

            public void execute(Sync buildWarDirSync) {
                buildWarDirSync.dependsOn(new Object[]{warTaskProvider});
                buildWarDirSync.from(new Object[]{new Callable<FileTree>(){

                    @Override
                    public FileTree call() throws Exception {
                        War war = (War)warTaskProvider.get();
                        return project.zipTree((Object)war.getArchivePath());
                    }
                }});
                buildWarDirSync.into((Object)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return new File(project.getBuildDir(), LiferayWarPlugin.BUILD_WAR_DIR_TASK_NAME);
                    }
                });
                buildWarDirSync.setDescription("Unzips the project's WAR file into a temporary directory.");
            }
        });
    }

    private void _configureTaskWatchProvider(final TaskProvider<Sync> buildWarDirTaskProvider, final TaskProvider<War> warTaskProvider, TaskProvider<WatchTask> watchTaskProvider) {
        watchTaskProvider.configure((Action)new Action<WatchTask>(){

            public void execute(WatchTask watchTask) {
                watchTask.dependsOn(new Object[]{buildWarDirTaskProvider});
                watchTask.setBundleDir(new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        Sync buildWarDirSync = (Sync)buildWarDirTaskProvider.get();
                        return buildWarDirSync.getDestinationDir();
                    }
                });
                watchTask.setBundleSymbolicName(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        War war = (War)warTaskProvider.get();
                        return war.getBaseName();
                    }
                });
                watchTask.setDescription("Continuously redeploys the project's WAR dir.");
                watchTask.setGroup("build");
            }
        });
    }
}

