/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.tasks;

import aQute.bnd.gradle.BndUtils;
import aQute.bnd.gradle.PropertiesWrapper;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Processor;
import aQute.bnd.version.MavenVersion;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.service.reporter.Report;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class ExecuteBndTask
extends DefaultTask {
    private Object _baseDir;
    private FileCollection _classpath;
    private boolean _failOnError = true;
    private Object _outputFile;
    private final Map<String, Object> _properties = new LinkedHashMap<String, Object>();
    private FileCollection _resourceDirs;
    private FileCollection _sourceDirs;
    private boolean _writeManifest;

    public ExecuteBndTask() {
        Project project = this.getProject();
        this._baseDir = project.getProjectDir();
    }

    @TaskAction
    public void executeBnd() throws Exception {
        Project project = this.getProject();
        Logger logger = this.getLogger();
        long clockStart = System.currentTimeMillis();
        PropertiesWrapper gradleProperties = new PropertiesWrapper();
        gradleProperties.put("project", project);
        gradleProperties.put("task", (Object)this);
        try (Builder builder = new Builder(new Processor((Properties)gradleProperties, false));){
            File outputFile;
            block35: {
                String bundleVersion;
                String bundleSymbolicName;
                Properties properties = this.getProperties();
                builder.setBase(this.getBaseDir());
                builder.setJar(new Jar("dot"));
                builder.setProperties(properties);
                ConfigurableFileCollection buildDirs = project.files(new Object[]{this.getClasspath(), this.getResourceDirs()});
                builder.setClasspath(this._toArray((FileCollection)buildDirs));
                builder.setProperty("project.buildpath", buildDirs.getAsPath());
                if (logger.isDebugEnabled()) {
                    logger.debug("Builder Classpath: {}", (Object)buildDirs.getAsPath());
                }
                ConfigurableFileCollection sourceDirs = project.files(new Object[]{this.getSourceDirs()});
                builder.setProperty("project.sourcepath", sourceDirs.getAsPath());
                builder.setSourcepath(this._toArray((FileCollection)sourceDirs));
                if (logger.isDebugEnabled()) {
                    logger.debug("Builder Sourcepath: {}", (Object)sourceDirs.getAsPath());
                }
                if (Validator.isNull((String)(bundleSymbolicName = builder.getProperty("Bundle-SymbolicName"))) || "<<EMPTY>>".equals(bundleSymbolicName)) {
                    builder.setProperty("Bundle-SymbolicName", project.getName());
                }
                if ((Validator.isNull((String)(bundleVersion = builder.getProperty("Bundle-Version"))) || "<<EMPTY>>".equals(bundleVersion)) && project.getVersion() != null) {
                    MavenVersion mavenVersion = MavenVersion.parseString((String)String.valueOf(project.getVersion()));
                    builder.setProperty("Bundle-Version", String.valueOf(mavenVersion.getOSGiVersion()));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Builder Properties: {}", (Object)properties);
                }
                Jar jar = builder.build();
                if (!builder.isOk()) {
                    BndUtils.logReport((Object)builder, (Logger)logger);
                    throw new GradleException((Object)((Object)this) + " failed");
                }
                outputFile = this.getOutputFile();
                if (this.isWriteManifest()) {
                    File outputDir = outputFile.getParentFile();
                    outputDir.mkdirs();
                    try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
                        Manifest manifest = jar.getManifest();
                        manifest.write(outputStream);
                        break block35;
                    }
                    catch (IOException ioException) {
                        throw new GradleException((Object)((Object)this) + " failed", (Throwable)ioException);
                    }
                }
                jar.write(outputFile);
            }
            this._logReport((Report)builder, logger);
            if (!builder.isOk()) {
                throw new GradleException((Object)((Object)this) + " failed");
            }
            if (logger.isInfoEnabled()) {
                long clockStop = System.currentTimeMillis();
                logger.info("Building the {} file took {} seconds.", (Object)outputFile.getName(), (Object)((clockStop - clockStart) / 1000L));
            }
        }
    }

    @Input
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getBaseDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._baseDir);
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getClasspath() {
        return this._classpath;
    }

    @OutputFile
    public File getOutputFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._outputFile);
    }

    @Input
    public Properties getProperties() {
        UTF8Properties properties = new UTF8Properties();
        for (Map.Entry<String, Object> entry : this._properties.entrySet()) {
            properties.put(entry.getKey(), GradleUtil.toString((Object)entry.getValue()));
        }
        return properties;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getResourceDirs() {
        return this._resourceDirs;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getSourceDirs() {
        return this._sourceDirs;
    }

    public boolean isFailOnError() {
        return this._failOnError;
    }

    @Input
    public boolean isWriteManifest() {
        return this._writeManifest;
    }

    public ExecuteBndTask properties(Map<String, ?> properties) {
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            this.property(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public ExecuteBndTask property(String key, Object value) {
        this._properties.put(key, value);
        return this;
    }

    public void setBaseDir(Object baseDir) {
        this._baseDir = baseDir;
    }

    public void setClasspath(FileCollection classpath) {
        this._classpath = classpath;
    }

    public void setFailOnError(boolean failOnError) {
        this._failOnError = failOnError;
    }

    public void setOutputFile(Object outputFile) {
        this._outputFile = outputFile;
    }

    public void setProperties(Map<String, ?> properties) {
        this._properties.clear();
        this.properties(properties);
    }

    public void setResourceDirs(FileCollection resourceDirs) {
        this._resourceDirs = resourceDirs;
    }

    public void setSourceDirs(FileCollection sourceDirs) {
        this._sourceDirs = sourceDirs;
    }

    public void setWriteManifest(boolean writeManifest) {
        this._writeManifest = writeManifest;
    }

    private void _logReport(Report report, Logger logger) {
        Report.Location location;
        if (logger.isWarnEnabled()) {
            for (String warning : report.getWarnings()) {
                location = report.getLocation(warning);
                if (location != null && location.file != null) {
                    logger.warn("{}:{}:{}", new Object[]{location.file, location.line, warning});
                    continue;
                }
                logger.warn(warning);
            }
        }
        if (logger.isErrorEnabled()) {
            for (String error : report.getErrors()) {
                location = report.getLocation(error);
                if (location != null && location.file != null) {
                    logger.error("{}:{}:{}", new Object[]{location.file, location.line, error});
                    continue;
                }
                logger.error(error);
            }
        }
    }

    private File[] _toArray(FileCollection fileCollection) {
        Set files = fileCollection.getFiles();
        return files.toArray(new File[0]);
    }
}

