/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.internal;

import com.liferay.gradle.plugins.BaseDefaultsPlugin;
import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.alloy.taglib.AlloyTaglibPlugin;
import com.liferay.gradle.plugins.alloy.taglib.BuildTaglibsTask;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.util.PortalTools;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.TaskContainer;

public class AlloyTaglibDefaultsPlugin
extends BaseDefaultsPlugin<AlloyTaglibPlugin> {
    public static final Plugin<Project> INSTANCE = new AlloyTaglibDefaultsPlugin();
    public static final String PORTAL_TOOL_NAME = "alloy-taglib";
    private static final String _PORTAL_TOOL_CONFIGURATION_NAME = "alloyTaglib";
    private static final String _PORTAL_TOOL_GROUP = "com.liferay.alloy-taglibs";

    @Override
    protected void applyPluginDefaults(final Project project, AlloyTaglibPlugin alloyTaglibPlugin) {
        ConfigurationContainer configurationContainer = project.getConfigurations();
        final Configuration portalToolConfiguration = (Configuration)configurationContainer.create(_PORTAL_TOOL_CONFIGURATION_NAME);
        Configuration runtimeConfiguration = configurationContainer.getByName("runtime");
        this._configureConfigurationPortalTool(portalToolConfiguration, runtimeConfiguration);
        PortalTools.addPortalToolDependencies(project, _PORTAL_TOOL_CONFIGURATION_NAME, _PORTAL_TOOL_GROUP, PORTAL_TOOL_NAME);
        GradleUtil.addDependency((Project)project, (String)_PORTAL_TOOL_CONFIGURATION_NAME, (String)"org.freemarker", (String)"freemarker", (String)"2.3.23");
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildTaglibsTask.class, (Action)new Action<BuildTaglibsTask>(){

            public void execute(BuildTaglibsTask buildTaglibsTask) {
                AlloyTaglibDefaultsPlugin.this._configureTaskBuildTaglibs(portalToolConfiguration, buildTaglibsTask);
            }
        });
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(LiferayBasePlugin.class, (Action)new Action<LiferayBasePlugin>(){

            public void execute(LiferayBasePlugin liferayBasePlugin) {
                AlloyTaglibDefaultsPlugin.this._configurePluginLiferayBase(project, portalToolConfiguration);
            }
        });
    }

    @Override
    protected Class<AlloyTaglibPlugin> getPluginClass() {
        return AlloyTaglibPlugin.class;
    }

    private AlloyTaglibDefaultsPlugin() {
    }

    private void _configureConfigurationPortalTool(Configuration portalToolConfiguration, Configuration runtimeConfiguration) {
        portalToolConfiguration.setDescription("Configures the Alloy Taglib tool for this project.");
        portalToolConfiguration.setVisible(false);
        portalToolConfiguration.extendsFrom(new Configuration[]{runtimeConfiguration});
    }

    private void _configurePluginLiferayBase(Project project, Configuration portalToolConfiguration) {
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Configuration portalConfiguration = configurationContainer.getByName("portal");
        portalToolConfiguration.extendsFrom(new Configuration[]{portalConfiguration});
    }

    private void _configureTaskBuildTaglibs(Configuration portalToolConfiguration, BuildTaglibsTask buildTaglibsTask) {
        buildTaglibsTask.setClasspath((FileCollection)portalToolConfiguration);
    }
}

