/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins;

import com.liferay.gradle.plugins.extensions.BundleExtension;
import com.liferay.gradle.plugins.internal.util.GradleUtil;
import com.liferay.gradle.plugins.internal.util.IncludeResourceCompileIncludeInstruction;
import com.liferay.gradle.plugins.tasks.ExecuteBndTask;
import com.liferay.gradle.plugins.tasks.WatchTask;
import com.liferay.gradle.plugins.util.BndUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.concurrent.Callable;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Jar;

public class WatchOSGiPlugin
implements Plugin<Project> {
    public static final String BUILD_BUNDLE_DIR_TASK_NAME = "buildBundleDir";
    public static final Plugin<Project> INSTANCE = new WatchOSGiPlugin();
    public static final String JAR_COMPILE_INCLUDE_FRAGMENT_TASK_NAME = "jarCompileIncludeFragment";
    public static final String WATCH_TASK_NAME = "watch";

    public void apply(Project project) {
        BundleExtension bundleExtension = BndUtil.getBundleExtension(project.getExtensions());
        Convention convention = project.getConvention();
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)convention.getPlugin(JavaPluginConvention.class);
        SourceSetContainer javaSourceSetContainer = javaPluginConvention.getSourceSets();
        SourceSet javaMainSourceSet = (SourceSet)javaSourceSetContainer.getByName("main");
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Configuration compileIncludeConfiguration = (Configuration)configurationContainer.maybeCreate("compileInclude");
        TaskProvider buildBundleDirTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)BUILD_BUNDLE_DIR_TASK_NAME, Sync.class);
        TaskProvider jarCompileIncludeFragmentTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)JAR_COMPILE_INCLUDE_FRAGMENT_TASK_NAME, ExecuteBndTask.class);
        TaskProvider watchTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)WATCH_TASK_NAME, WatchTask.class);
        TaskProvider jarTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)"jar", Jar.class);
        this._configureTaskBuildBundleDirProvider(project, (TaskProvider<Sync>)buildBundleDirTaskProvider, (TaskProvider<Jar>)jarTaskProvider);
        this._configureTaskJarCompileIncludeFragmentProvider(project, javaMainSourceSet, bundleExtension, compileIncludeConfiguration, (TaskProvider<ExecuteBndTask>)jarCompileIncludeFragmentTaskProvider);
        this._configureTaskWatchProvider((TaskProvider<Sync>)buildBundleDirTaskProvider, (TaskProvider<ExecuteBndTask>)jarCompileIncludeFragmentTaskProvider, (TaskProvider<WatchTask>)watchTaskProvider);
    }

    private WatchOSGiPlugin() {
    }

    private void _configureTaskBuildBundleDirProvider(final Project project, TaskProvider<Sync> buildBundleDirTaskProvider, final TaskProvider<Jar> jarTaskProvider) {
        buildBundleDirTaskProvider.configure((Action)new Action<Sync>(){

            public void execute(Sync buildBundleDirSync) {
                buildBundleDirSync.dependsOn(new Object[]{jarTaskProvider});
                buildBundleDirSync.from(new Object[]{new Callable<FileTree>(){

                    @Override
                    public FileTree call() throws Exception {
                        Jar jar = (Jar)jarTaskProvider.get();
                        return project.zipTree((Object)jar.getArchivePath());
                    }
                }});
                buildBundleDirSync.into((Object)new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return new File(project.getBuildDir(), WatchOSGiPlugin.BUILD_BUNDLE_DIR_TASK_NAME);
                    }
                });
                buildBundleDirSync.setDescription("Unzips the project's JAR file into a temporary directory.");
            }
        });
    }

    private void _configureTaskJarCompileIncludeFragmentProvider(final Project project, final SourceSet javaMainSourceSet, final BundleExtension bundleExtension, final Configuration compileIncludeConfiguration, TaskProvider<ExecuteBndTask> jarCompileIncludeFragmentTaskProvider) {
        jarCompileIncludeFragmentTaskProvider.configure((Action)new Action<ExecuteBndTask>(){

            public void execute(ExecuteBndTask jarCompileIncludeFragmentExecuteBndTask) {
                jarCompileIncludeFragmentExecuteBndTask.property("Bundle-Name", new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        String instruction = bundleExtension.getInstruction("Bundle-Name");
                        return instruction + " Libs";
                    }
                });
                jarCompileIncludeFragmentExecuteBndTask.property("Bundle-SymbolicName", new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        String instruction = bundleExtension.getInstruction("Bundle-SymbolicName");
                        return instruction + ".libs";
                    }
                });
                jarCompileIncludeFragmentExecuteBndTask.property("Bundle-Version", "1.0.0");
                jarCompileIncludeFragmentExecuteBndTask.property("Fragment-Host", new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return bundleExtension.getInstruction("Bundle-SymbolicName");
                    }
                });
                jarCompileIncludeFragmentExecuteBndTask.property("-includeresource", new IncludeResourceCompileIncludeInstruction(new Callable<Iterable<File>>(){

                    @Override
                    public Iterable<File> call() throws Exception {
                        return compileIncludeConfiguration;
                    }
                }, new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return Boolean.FALSE;
                    }
                }));
                jarCompileIncludeFragmentExecuteBndTask.onlyIf((Spec)new Spec<Task>(){

                    public boolean isSatisfiedBy(Task task) {
                        return !compileIncludeConfiguration.isEmpty();
                    }
                });
                jarCompileIncludeFragmentExecuteBndTask.setClasspath(javaMainSourceSet.getCompileClasspath());
                jarCompileIncludeFragmentExecuteBndTask.setDescription("Generates an OSGi fragment containing all dependencies of compileInclude.");
                jarCompileIncludeFragmentExecuteBndTask.setGroup("build");
                jarCompileIncludeFragmentExecuteBndTask.setOutputFile(new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return new File(project.getBuildDir(), project.getName() + "-libs." + "jar");
                    }
                });
                jarCompileIncludeFragmentExecuteBndTask.setResourceDirs((FileCollection)project.files(new Object[0]));
                jarCompileIncludeFragmentExecuteBndTask.setSourceDirs((FileCollection)project.files(new Object[0]));
            }
        });
    }

    private void _configureTaskWatchProvider(final TaskProvider<Sync> buildBundleDirTaskProvider, final TaskProvider<ExecuteBndTask> jarCompileIncludeFragmentTaskProvider, TaskProvider<WatchTask> watchTaskProvider) {
        watchTaskProvider.configure((Action)new Action<WatchTask>(){

            public void execute(WatchTask watchTask) {
                final Sync buildBundleDirSync = (Sync)buildBundleDirTaskProvider.get();
                watchTask.dependsOn(new Object[]{buildBundleDirSync});
                watchTask.setBundleDir(new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        return buildBundleDirSync.getDestinationDir();
                    }
                });
                watchTask.setBundleSymbolicName(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        File manifestFile = new File(buildBundleDirSync.getDestinationDir(), "META-INF/MANIFEST.MF");
                        if (manifestFile.exists()) {
                            try (FileInputStream fileInputStream = new FileInputStream(manifestFile);){
                                Manifest manifest = new Manifest(fileInputStream);
                                Attributes attributes = manifest.getMainAttributes();
                                String string = attributes.getValue("Bundle-SymbolicName");
                                return string;
                            }
                        }
                        return null;
                    }
                });
                watchTask.setDescription("Continuously redeploys the project's OSGi bundle.");
                watchTask.setGroup("build");
                ExecuteBndTask jarCompileIncludeFragmentExecuteBndTask = (ExecuteBndTask)((Object)jarCompileIncludeFragmentTaskProvider.get());
                TaskOutputsInternal taskOutputs = jarCompileIncludeFragmentExecuteBndTask.getOutputs();
                watchTask.setFragments(taskOutputs.getFiles());
            }
        });
    }
}

