/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.xsd.builder;

import com.liferay.gradle.plugins.xsd.builder.BuildXSDTask;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.StringUtil;
import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.compile.JavaCompile;

public class XSDBuilderPlugin
implements Plugin<Project> {
    public static final String BUILD_XSD_TASK_NAME = "buildXSD";
    public static final String CONFIGURATION_NAME = "xsdBuilder";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, JavaPlugin.class);
        this.addConfigurationXSDBuilder(project);
        this.addTaskBuildXSD(project);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                XSDBuilderPlugin.this.configureTaskBuildXSD(project);
            }
        });
    }

    protected Configuration addConfigurationXSDBuilder(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CONFIGURATION_NAME);
        configuration.setDescription("Configures Apache XMLBeans for generating XMLBeans bindings.");
        configuration.setVisible(false);
        GradleUtil.executeIfEmpty((Configuration)configuration, (Action)new Action<Configuration>(){

            public void execute(Configuration configuration) {
                XSDBuilderPlugin.this.addDependenciesXSDBuilder(project);
            }
        });
        return configuration;
    }

    protected void addDependenciesXSDBuilder(Project project) {
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"org.apache.xmlbeans", (String)"xmlbeans", (String)"2.5.0");
    }

    protected BuildXSDTask addTaskBuildXSD(Project project) {
        final BuildXSDTask buildXSDTask = (BuildXSDTask)GradleUtil.addTask((Project)project, (String)BUILD_XSD_TASK_NAME, BuildXSDTask.class);
        buildXSDTask.setDescription("Generates XMLBeans bindings.");
        buildXSDTask.setDestinationDir(project.file((Object)"lib"));
        buildXSDTask.setGroup("build");
        buildXSDTask.setInputDir("xsd");
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(WarPlugin.class, (Action)new Action<WarPlugin>(){

            public void execute(WarPlugin warPlugin) {
                XSDBuilderPlugin.this.configureTaskBuildXSDForWarPlugin(buildXSDTask);
            }
        });
        return buildXSDTask;
    }

    protected Task addTaskBuildXSDCompile(BuildXSDTask buildXSDTask, Task generateTask) {
        Project project = buildXSDTask.getProject();
        JavaCompile javaCompile = (JavaCompile)GradleUtil.addTask((Project)project, (String)(buildXSDTask.getName() + "Compile"), JavaCompile.class);
        javaCompile.dependsOn(new Object[]{"clean" + StringUtil.capitalize((String)javaCompile.getName())});
        javaCompile.setClasspath((FileCollection)GradleUtil.getConfiguration((Project)project, (String)CONFIGURATION_NAME));
        File tmpBinDir = new File(project.getBuildDir(), buildXSDTask.getName() + "/bin");
        javaCompile.setDestinationDir(tmpBinDir);
        javaCompile.setSource((Object)generateTask.getOutputs());
        return javaCompile;
    }

    protected Task addTaskBuildXSDGenerate(BuildXSDTask buildXSDTask) {
        Project project = buildXSDTask.getProject();
        JavaExec javaExec = (JavaExec)GradleUtil.addTask((Project)project, (String)(buildXSDTask.getName() + "Generate"), JavaExec.class);
        File tmpSrcDir = new File(project.getBuildDir(), buildXSDTask.getName() + "/src");
        javaExec.args(new Object[]{"-d"});
        javaExec.args(new Object[]{FileUtil.getAbsolutePath((File)tmpSrcDir)});
        javaExec.args(new Object[]{"-srconly"});
        FileCollection xsdFiles = buildXSDTask.getInputFiles();
        for (File xsdFile : xsdFiles) {
            javaExec.args(new Object[]{FileUtil.getAbsolutePath((File)xsdFile)});
        }
        javaExec.dependsOn(new Object[]{"clean" + StringUtil.capitalize((String)javaExec.getName())});
        javaExec.setClasspath((FileCollection)GradleUtil.getConfiguration((Project)project, (String)CONFIGURATION_NAME));
        javaExec.setMain("org.apache.xmlbeans.impl.tool.SchemaCompiler");
        TaskInputs taskInputs = javaExec.getInputs();
        taskInputs.files(new Object[]{xsdFiles});
        TaskOutputsInternal taskOutputs = javaExec.getOutputs();
        taskOutputs.dir((Object)tmpSrcDir);
        return javaExec;
    }

    protected void configureTaskBuildXSD(BuildXSDTask buildXSDTask) {
        FileCollection inputFiles = buildXSDTask.getInputFiles();
        if (inputFiles.isEmpty()) {
            return;
        }
        Task generateTask = this.addTaskBuildXSDGenerate(buildXSDTask);
        Task compileTask = this.addTaskBuildXSDCompile(buildXSDTask, generateTask);
        buildXSDTask.from(new Object[]{compileTask.getOutputs()});
        buildXSDTask.from(new Object[]{generateTask.getOutputs()});
        TaskOutputsInternal taskOutputs = buildXSDTask.getOutputs();
        GradleUtil.addDependency((Project)buildXSDTask.getProject(), (String)"compile", (FileCollection)taskOutputs.getFiles());
    }

    protected void configureTaskBuildXSD(Project project) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildXSDTask.class, (Action)new Action<BuildXSDTask>(){

            public void execute(BuildXSDTask buildXSDTask) {
                XSDBuilderPlugin.this.configureTaskBuildXSD(buildXSDTask);
            }
        });
    }

    protected void configureTaskBuildXSDForWarPlugin(final BuildXSDTask buildXSDTask) {
        buildXSDTask.setDestinationDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(XSDBuilderPlugin.this.getWebAppDir(buildXSDTask.getProject()), "WEB-INF/lib");
            }
        });
        buildXSDTask.setInputDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(XSDBuilderPlugin.this.getWebAppDir(buildXSDTask.getProject()), "WEB-INF/xsd");
            }
        });
    }

    protected File getWebAppDir(Project project) {
        WarPluginConvention warPluginConvention = (WarPluginConvention)GradleUtil.getConvention((Project)project, WarPluginConvention.class);
        return warPluginConvention.getWebAppDir();
    }
}

