/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.xml.formatter;

import com.liferay.gradle.plugins.xml.formatter.FormatXMLTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;

public class XMLFormatterPlugin
implements Plugin<Project> {
    public static final String CONFIGURATION_NAME = "xmlFormatter";
    public static final String FORMAT_XML_TASK_NAME = "formatXML";

    public void apply(Project project) {
        Configuration xmlFormatterConfiguration = this.addConfigurationXMLFormatter(project);
        this.addTaskFormatXML(project);
        this.configureTasksFormatXML(project, (FileCollection)xmlFormatterConfiguration);
    }

    protected Configuration addConfigurationXMLFormatter(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                XMLFormatterPlugin.this.addDependenciesXMLFormatter(project);
            }
        });
        configuration.setDescription("Configures Liferay XML Formatter for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    protected void addDependenciesXMLFormatter(Project project) {
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.xml.formatter", (String)"latest.release");
    }

    protected FormatXMLTask addTaskFormatXML(Project project) {
        final FormatXMLTask formatXMLTask = (FormatXMLTask)GradleUtil.addTask((Project)project, (String)FORMAT_XML_TASK_NAME, FormatXMLTask.class);
        formatXMLTask.setDescription("Runs Liferay XML Formatter to format the project files.");
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                XMLFormatterPlugin.this.configureTaskFormatXMLForJavaPlugin(formatXMLTask);
            }
        });
        return formatXMLTask;
    }

    protected void configureTaskFormatXML(FormatXMLTask formatXMLTask, FileCollection classpath) {
        formatXMLTask.setClasspath(classpath);
    }

    protected void configureTaskFormatXMLForJavaPlugin(FormatXMLTask formatXMLTask) {
        formatXMLTask.setIncludes(Collections.singleton("**/*.xml"));
        final SourceSet sourceSet = GradleUtil.getSourceSet((Project)formatXMLTask.getProject(), (String)"main");
        formatXMLTask.setSource(new Callable<Iterable<File>>(){

            @Override
            public Iterable<File> call() throws Exception {
                SourceDirectorySet sourceDirectorySet = sourceSet.getResources();
                return sourceDirectorySet.getSrcDirs();
            }
        });
    }

    protected void configureTasksFormatXML(Project project, final FileCollection classpath) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(FormatXMLTask.class, (Action)new Action<FormatXMLTask>(){

            public void execute(FormatXMLTask formatXMLTask) {
                XMLFormatterPlugin.this.configureTaskFormatXML(formatXMLTask, classpath);
            }
        });
    }
}

