/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.xml.formatter;

import com.liferay.gradle.util.FileUtil;
import com.liferay.xml.formatter.XMLFormatterArgs;
import groovy.lang.Closure;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaExecSpec;

public class FormatXMLTask
extends SourceTask {
    private final XMLFormatterArgs _xmlFormatterArgs = new XMLFormatterArgs();

    @TaskAction
    public void formatXML() {
        FileTree fileTree = this.getSource();
        for (File file : fileTree) {
            this.formatXML(file);
        }
    }

    public boolean isStripComments() {
        return this._xmlFormatterArgs.isStripComments();
    }

    public void setStripComments(boolean stripComments) {
        this._xmlFormatterArgs.setStripComments(stripComments);
    }

    protected void formatXML(final File file) {
        final Project project = this.getProject();
        project.javaexec((Closure)new Closure<Void>(null){

            public void doCall(JavaExecSpec javaExecSpec) {
                javaExecSpec.setClasspath(FormatXMLTask.this.getClasspath());
                javaExecSpec.setMain("com.liferay.xml.formatter.XMLFormatter");
                javaExecSpec.setSystemProperties(FormatXMLTask.this.getSystemProperties(file));
                javaExecSpec.setWorkingDir((Object)project.getProjectDir());
            }
        });
    }

    protected FileCollection getClasspath() {
        Project project = this.getProject();
        ConfigurationContainer configurationContainer = project.getConfigurations();
        return configurationContainer.getByName("xmlFormatter");
    }

    protected Map<String, Object> getSystemProperties(File file) {
        HashMap<String, Object> systemProperties = new HashMap<String, Object>();
        systemProperties.put("xml.formatter.file", FileUtil.getAbsolutePath((File)file));
        systemProperties.put("xml.formatter.strip.comments", this.isStripComments());
        return systemProperties;
    }
}

