/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.xml.formatter;

import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaExecSpec;

public class FormatXMLTask
extends SourceTask {
    private FileCollection _classpath;
    private Object _mainClassName = "com.liferay.xml.formatter.XMLFormatter";
    private boolean _stripComments;

    @TaskAction
    public void formatXML() {
        FileTree fileTree = this.getSource();
        for (File file : fileTree) {
            this.formatXML(file);
        }
    }

    @InputFiles
    public FileCollection getClasspath() {
        return this._classpath;
    }

    @Input
    public String getMainClassName() {
        return GradleUtil.toString((Object)this._mainClassName);
    }

    @Input
    public boolean isStripComments() {
        return this._stripComments;
    }

    public void setClasspath(FileCollection classpath) {
        this._classpath = classpath;
    }

    public void setMainClassName(Object mainClassName) {
        this._mainClassName = mainClassName;
    }

    public void setStripComments(boolean stripComments) {
        this._stripComments = stripComments;
    }

    protected void formatXML(final File file) {
        Project project = this.getProject();
        project.javaexec((Action)new Action<JavaExecSpec>(){

            public void execute(JavaExecSpec javaExecSpec) {
                javaExecSpec.setClasspath(FormatXMLTask.this.getClasspath());
                javaExecSpec.setMain(FormatXMLTask.this.getMainClassName());
                javaExecSpec.setSystemProperties(FormatXMLTask.this.getSystemProperties(file));
            }
        });
    }

    protected Map<String, Object> getSystemProperties(File file) {
        HashMap<String, Object> systemProperties = new HashMap<String, Object>();
        systemProperties.put("xml.formatter.file", FileUtil.getAbsolutePath((File)file));
        systemProperties.put("xml.formatter.strip.comments", this.isStripComments());
        return systemProperties;
    }
}

