/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.configurator;

import com.liferay.ant.bnd.metatype.MetatypePlugin;
import com.liferay.gradle.plugins.LiferayOSGiPlugin;
import com.liferay.gradle.plugins.extensions.BundleExtension;
import com.liferay.gradle.plugins.extensions.LiferayOSGiExtension;
import com.liferay.gradle.plugins.js.module.config.generator.JSModuleConfigGeneratorPlugin;
import com.liferay.gradle.plugins.js.transpiler.JSTranspilerBasePlugin;
import com.liferay.gradle.plugins.js.transpiler.JSTranspilerPlugin;
import com.liferay.gradle.plugins.rest.builder.RESTBuilderPlugin;
import com.liferay.gradle.plugins.service.builder.ServiceBuilderPlugin;
import com.liferay.gradle.plugins.soy.SoyPlugin;
import com.liferay.gradle.plugins.soy.SoyTranslationPlugin;
import com.liferay.gradle.plugins.test.integration.TestIntegrationTomcatExtension;
import com.liferay.gradle.plugins.upgrade.table.builder.UpgradeTableBuilderPlugin;
import com.liferay.gradle.plugins.util.BndUtil;
import com.liferay.gradle.plugins.workspace.FrontendPlugin;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.configurator.BaseProjectConfigurator;
import com.liferay.gradle.plugins.workspace.internal.JSModuleConfigGeneratorDefaultsPlugin;
import com.liferay.gradle.plugins.workspace.internal.util.FileUtil;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.plugins.wsdd.builder.WSDDBuilderPlugin;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySourceSpec;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.initialization.Settings;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.jvm.tasks.Jar;

public class ModulesProjectConfigurator
extends BaseProjectConfigurator {
    protected static final String NAME = "modules";
    private static final boolean _DEFAULT_JSP_PRECOMPILE_ENABLED = false;
    private static final String _DEFAULT_MODULES_DIR = "modules";
    private static final boolean _DEFAULT_REPOSITORY_ENABLED = true;
    private boolean _defaultRepositoryEnabled;
    private final Map<String, Path> _excludeProjectPathMap;
    private boolean _jspPrecompileEnabled;
    private final String _modulesDirs;
    private final String _modulesExcludeDirs;

    public ModulesProjectConfigurator(Settings settings) {
        super(settings);
        this._defaultRepositoryEnabled = GradleUtil.getProperty((ExtensionAware)settings, (String)"liferay.workspace.modules.default.repository.enabled", (boolean)true);
        this._jspPrecompileEnabled = GradleUtil.getProperty((ExtensionAware)settings, (String)"liferay.workspace.modules.jsp.precompile.enabled", (boolean)false);
        this._modulesDirs = GradleUtil.getProperty((ExtensionAware)settings, (String)"liferay.workspace.modules.dir", (String)"modules");
        this._modulesExcludeDirs = GradleUtil.getProperty((ExtensionAware)settings, (String)"liferay.workspace.modules.excludes.dir", null);
        this._excludeProjectPathMap = this._getExcludeProjectPathMap(settings);
    }

    public void apply(Project project) {
        if (this.isDefaultRepositoryEnabled()) {
            GradleUtil.addDefaultRepositories(project);
        }
        Callable<ConfigurableFileCollection> jarSourcePath = null;
        File bndBndFile = project.file((Object)"bnd.bnd");
        File buildGradleFile = project.file((Object)"build.gradle");
        File pomXmlFile = project.file((Object)"pom.xml");
        if (bndBndFile.exists() && (buildGradleFile.exists() || pomXmlFile.exists())) {
            if (!project.hasProperty("compile.jsp.include")) {
                ExtensionContainer extensionContainer = project.getExtensions();
                ExtraPropertiesExtension extraPropertiesExtension = extensionContainer.getExtraProperties();
                extraPropertiesExtension.set("compile.jsp.include", (Object)this.isJspPrecompileEnabled());
            }
            GradleUtil.applyPlugin((Project)project, LiferayOSGiPlugin.class);
            if (FileUtil.exists((Project)project, (String)"rest-config.yaml")) {
                GradleUtil.applyPlugin((Project)project, RESTBuilderPlugin.class);
            }
            if (FileUtil.exists((Project)project, (String)"service.xml")) {
                GradleUtil.applyPlugin((Project)project, ServiceBuilderPlugin.class);
            }
            GradleUtil.applyPlugin((Project)project, SoyPlugin.class);
            GradleUtil.applyPlugin((Project)project, SoyTranslationPlugin.class);
            GradleUtil.applyPlugin((Project)project, UpgradeTableBuilderPlugin.class);
            GradleUtil.applyPlugin((Project)project, WSDDBuilderPlugin.class);
            if (GradleUtil.hasTask(project, "packageRunBuild")) {
                GradleUtil.applyPlugin((Project)project, JSTranspilerBasePlugin.class);
            } else {
                GradleUtil.applyPlugin((Project)project, JSModuleConfigGeneratorPlugin.class);
                GradleUtil.applyPlugin((Project)project, JSTranspilerPlugin.class);
            }
            JSModuleConfigGeneratorDefaultsPlugin.INSTANCE.apply((Object)project);
            Jar jar = (Jar)GradleUtil.getTask((Project)project, (String)"jar");
            this._configureLiferayOSGi(project);
            this._configureRootTaskDistBundle(jar);
            project.afterEvaluate((Action)new Action<Project>(){

                public void execute(Project project) {
                    ModulesProjectConfigurator.this._configureTaskTestIntegration(project);
                }
            });
            jarSourcePath = jar;
        } else {
            File clientExtensionYamlFile = project.file((Object)"client-extension.yaml");
            File packageJsonFile = project.file((Object)"package.json");
            if (!clientExtensionYamlFile.exists() && packageJsonFile.exists() && this._hasJsPortletBuildScript(packageJsonFile.toPath())) {
                GradleUtil.applyPlugin((Project)project, FrontendPlugin.class);
                final Task buildTask = GradleUtil.getTask((Project)project, (String)"build");
                this._configureRootTaskDistBundle(buildTask);
                jarSourcePath = new Callable<ConfigurableFileCollection>(){

                    @Override
                    public ConfigurableFileCollection call() throws Exception {
                        Project project = buildTask.getProject();
                        ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{ModulesProjectConfigurator.this._getJarFile(project)});
                        return configurableFileCollection.builtBy(new Object[]{buildTask});
                    }
                };
            }
        }
        final BundleExtension bundleExtension = BndUtil.getBundleExtension((ExtensionContainer)project.getExtensions());
        final WorkspaceExtension workspaceExtension = this._getWorkspaceExtension(project);
        this.configureLiferay(project, workspaceExtension);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                Task setUpTestableTomcatTask;
                TaskContainer taskContainer = project.getTasks();
                Task deployFastTask = (Task)taskContainer.findByName("deployFast");
                if (deployFastTask != null) {
                    ModulesProjectConfigurator.this._configureTaskDeployFast((Copy)deployFastTask, bundleExtension, workspaceExtension);
                }
                if ((setUpTestableTomcatTask = (Task)taskContainer.findByName("setUpTestableTomcat")) != null) {
                    ModulesProjectConfigurator.this._configureTaskSetUpTestableTomcat(setUpTestableTomcatTask, workspaceExtension);
                }
                ModulesProjectConfigurator.this._disableTasks(ModulesProjectConfigurator.this._excludeProjectPathMap, project);
            }
        });
        this.addTaskDockerDeploy(project, (Object)jarSourcePath, workspaceExtension);
    }

    @Override
    public String getName() {
        return "modules";
    }

    public boolean isDefaultRepositoryEnabled() {
        return this._defaultRepositoryEnabled;
    }

    public boolean isJspPrecompileEnabled() {
        return this._jspPrecompileEnabled;
    }

    public void setDefaultRepositoryEnabled(boolean defaultRepositoryEnabled) {
        this._defaultRepositoryEnabled = defaultRepositoryEnabled;
    }

    public void setJspPrecompileEnabled(boolean jspPrecompileEnabled) {
        this._jspPrecompileEnabled = jspPrecompileEnabled;
    }

    @Override
    protected Iterable<File> doGetProjectDirs(File rootDir) throws Exception {
        final HashSet<File> projectDirs = new HashSet<File>();
        Files.walkFileTree(rootDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                if (Files.exists(dirPath.resolve("bnd.bnd"), new LinkOption[0])) {
                    projectDirs.add(dirPath.toFile());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                String dirName = String.valueOf(dirPath.getFileName());
                if (ModulesProjectConfigurator.this.isExcludedDirName(dirName)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Path clientExtensionYamlPath = dirPath.resolve("client-extension.yaml");
                Path packageJsonPath = dirPath.resolve("package.json");
                if (!Files.exists(clientExtensionYamlPath, new LinkOption[0]) && Files.exists(packageJsonPath, new LinkOption[0]) && ModulesProjectConfigurator.this._hasJsPortletBuildScript(packageJsonPath)) {
                    projectDirs.add(dirPath.toFile());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return projectDirs;
    }

    private void _configureExtensionTestIntegrationTomcat(TestIntegrationTomcatExtension testIntegrationTomcatExtension, final WorkspaceExtension workspaceExtension) {
        testIntegrationTomcatExtension.setDir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(workspaceExtension.getHomeDir(), "tomcat-" + workspaceExtension.getAppServerTomcatVersion());
            }
        });
    }

    private void _configureLiferayOSGi(Project project) {
        LiferayOSGiExtension liferayOSGiExtension = (LiferayOSGiExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayOSGiExtension.class);
        HashMap<String, String> bundleDefaultInstructions = new HashMap<String, String>();
        bundleDefaultInstructions.put("-plugin.metatype", MetatypePlugin.class.getName());
        liferayOSGiExtension.bundleDefaultInstructions(bundleDefaultInstructions);
    }

    private void _configureRootTaskDistBundle(final Jar jar) {
        Project project = jar.getProject();
        Copy copy = (Copy)GradleUtil.getTask((Project)project.getRootProject(), (String)"distBundle");
        copy.into((Object)"osgi/modules", (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySourceSpec copySourceSpec) {
                copySourceSpec.from(new Object[]{jar});
            }
        });
    }

    private void _configureRootTaskDistBundle(Task buildTask) {
        Project project = buildTask.getProject();
        Copy copy = (Copy)GradleUtil.getTask((Project)project.getRootProject(), (String)"distBundle");
        copy.dependsOn(new Object[]{buildTask});
        copy.into((Object)"osgi/modules", this._copyJarClosure(project, buildTask));
    }

    private void _configureTaskDeployFast(final Copy deployFastTask, BundleExtension bundleExtension, WorkspaceExtension workspaceExtension) {
        final Project project = deployFastTask.getProject();
        String bundleSymbolicName = bundleExtension.getInstruction("Bundle-SymbolicName");
        String bundleVersion = bundleExtension.getInstruction("Bundle-Version");
        StringBuilder sb = new StringBuilder();
        sb.append("work/");
        sb.append(bundleSymbolicName);
        sb.append("-");
        sb.append(bundleVersion);
        final String pathName = sb.toString();
        final File dockerWorkDir = new File(workspaceExtension.getDockerDir(), pathName);
        deployFastTask.setDestinationDir(workspaceExtension.getHomeDir());
        deployFastTask.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                project.sync((Action)new Action<CopySpec>(){

                    public void execute(CopySpec copySpec) {
                        copySpec.from(new Object[]{new File(deployFastTask.getDestinationDir(), pathName)});
                        copySpec.into((Object)dockerWorkDir);
                    }
                });
            }
        });
        Task cleanTask = GradleUtil.getTask((Project)project, (String)"clean");
        cleanTask.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                project.delete((Action)new Action<DeleteSpec>(){

                    public void execute(DeleteSpec deleteSpec) {
                        deleteSpec.delete(new Object[]{dockerWorkDir});
                    }
                });
            }
        });
    }

    private void _configureTaskSetUpTestableTomcat(Task setUpTestableTomcatTask, WorkspaceExtension workspaceExtension) {
        File homeDir = workspaceExtension.getHomeDir();
        if (!homeDir.exists()) {
            Project project = setUpTestableTomcatTask.getProject();
            Task initBundleTask = GradleUtil.getTask((Project)project.getRootProject(), (String)"initBundle");
            Task copyTestModulesTask = GradleUtil.getTask((Project)project, (String)"copyTestModules");
            copyTestModulesTask.dependsOn(new Object[]{initBundleTask});
            setUpTestableTomcatTask.dependsOn(new Object[]{copyTestModulesTask});
            ExtensionContainer extensionContainer = project.getExtensions();
            TestIntegrationTomcatExtension testIntegrationTomcatExtension = (TestIntegrationTomcatExtension)extensionContainer.getByType(TestIntegrationTomcatExtension.class);
            this._configureExtensionTestIntegrationTomcat(testIntegrationTomcatExtension, workspaceExtension);
        }
    }

    private void _configureTaskTestIntegration(final Project project) {
        final File testClassesIntegrationDir = project.file((Object)"test-classes/integration");
        Task testIntegrationClassesTask = GradleUtil.getTask((Project)project, (String)"testIntegrationClasses");
        testIntegrationClassesTask.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                project.sync((Action)new Action<CopySpec>(){

                    public void execute(CopySpec copySpec) {
                        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"testIntegration");
                        copySpec.from(new Object[]{FileUtil.getJavaClassesDir(sourceSet)});
                        copySpec.from(new Object[]{ModulesProjectConfigurator.this._getResourcesDir(sourceSet)});
                        copySpec.into((Object)testClassesIntegrationDir);
                    }
                });
            }
        });
        Delete deleteCleanTask = (Delete)GradleUtil.getTask((Project)project, (String)"clean");
        deleteCleanTask.delete(new Object[]{testClassesIntegrationDir.getParentFile()});
    }

    private Closure _copyJarClosure(Project project, final Task assembleTask) {
        return new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                Project project = assembleTask.getProject();
                File jarFile = ModulesProjectConfigurator.this._getJarFile(project);
                ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{jarFile});
                configurableFileCollection.builtBy(new Object[]{assembleTask});
                copySpec.from(new Object[]{jarFile});
            }
        };
    }

    private void _disableTasks(Map<String, Path> excludeProjectPathMap, Project project) {
        File projectDir = project.getProjectDir();
        Path projectDirPath = projectDir.toPath();
        Collection<Path> projectPaths = excludeProjectPathMap.values();
        for (Path excludeProjectPath : projectPaths) {
            if (!projectDirPath.startsWith(excludeProjectPath)) continue;
            Map projectTasksMap = project.getAllTasks(true);
            Collection projectTasks = projectTasksMap.values();
            for (Set tasks : projectTasks) {
                for (Task task : tasks) {
                    task.setEnabled(false);
                }
            }
        }
    }

    private Map<String, Path> _getExcludeProjectPathMap(Settings settings) {
        if (Objects.isNull(this._modulesExcludeDirs)) {
            return Collections.emptyMap();
        }
        List<String> modulesExcludeDirs = Arrays.asList(this._modulesExcludeDirs.split(","));
        if (Objects.isNull(modulesExcludeDirs) || modulesExcludeDirs.isEmpty()) {
            return Collections.emptyMap();
        }
        List<String> modulesDirs = Arrays.asList(this._modulesDirs.split(","));
        HashMap<String, Path> excludeProjectPathMap = new HashMap<String, Path>();
        for (String modulesDirString : modulesDirs) {
            File modulesDir = new File(settings.getRootDir(), modulesDirString.trim());
            if (!modulesDir.isDirectory()) continue;
            try {
                for (String excludeDirString : modulesExcludeDirs) {
                    ModulesProjectExcludeVisitor modulesExcludeVisitor = new ModulesProjectExcludeVisitor(excludeDirString.trim());
                    Files.walkFileTree(modulesDir.toPath(), modulesExcludeVisitor);
                    Path modulesExcludePath = modulesExcludeVisitor.getModulesExcludePath();
                    if (!Objects.nonNull(modulesExcludePath)) continue;
                    excludeProjectPathMap.put(excludeDirString, modulesExcludePath);
                }
            }
            catch (Exception exception) {
                return Collections.emptyMap();
            }
        }
        Set excludeProjectEntries = excludeProjectPathMap.entrySet();
        for (Map.Entry modulesExcludeEntry : excludeProjectEntries) {
            String modulesExcludeName = (String)modulesExcludeEntry.getKey();
            Path modulesExcludePath = (Path)modulesExcludeEntry.getValue();
            for (String modulesDirString : modulesDirs) {
                File modulesDir = new File(settings.getRootDir(), modulesDirString);
                Path excludeParentPath = modulesExcludePath.getParent();
                boolean foundParent = false;
                while (!Objects.equals(excludeParentPath, modulesDir.toPath())) {
                    modulesExcludePath = excludeParentPath;
                    excludeParentPath = modulesExcludePath.getParent();
                    foundParent = true;
                }
                if (!foundParent) continue;
                excludeProjectPathMap.put(modulesExcludeName, modulesExcludePath);
            }
        }
        return excludeProjectPathMap;
    }

    private File _getJarFile(Project project) {
        return project.file((Object)("dist/" + GradleUtil.getArchivesBaseName(project) + "-" + project.getVersion() + ".jar"));
    }

    private Map<String, Object> _getPackageJsonMap(File packageJsonFile) {
        if (!packageJsonFile.exists()) {
            return Collections.emptyMap();
        }
        JsonSlurper jsonSlurper = new JsonSlurper();
        return (Map)jsonSlurper.parse(packageJsonFile);
    }

    private File _getResourcesDir(SourceSet sourceSet) {
        SourceSetOutput sourceSetOutput = sourceSet.getOutput();
        return sourceSetOutput.getResourcesDir();
    }

    private WorkspaceExtension _getWorkspaceExtension(Project project) {
        return (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)((ExtensionAware)project.getGradle()), WorkspaceExtension.class);
    }

    private boolean _hasJsPortletBuildScript(Path packageJsonPath) {
        Map<String, Object> packageJsonMap = this._getPackageJsonMap(packageJsonPath.toFile());
        Map liferayTheme = (Map)packageJsonMap.get("liferayTheme");
        Map scripts = (Map)packageJsonMap.get("scripts");
        return liferayTheme == null && scripts != null && scripts.get("build") != null;
    }

    private class ModulesProjectExcludeVisitor
    extends SimpleFileVisitor<Path> {
        private final String _modulesExcludeDirName;
        private Path _modulesExcludePath;

        public ModulesProjectExcludeVisitor(String modulesExcludeDirName) {
            this._modulesExcludeDirName = modulesExcludeDirName;
        }

        public Path getModulesExcludePath() {
            return this._modulesExcludePath;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes basicFileAttributes) throws IOException {
            super.preVisitDirectory(dir, basicFileAttributes);
            if (Files.exists(dir.resolve(this._modulesExcludeDirName), new LinkOption[0])) {
                this._modulesExcludePath = dir.resolve(this._modulesExcludeDirName);
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

