/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.configurator;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.liferay.gradle.plugins.LiferayBasePlugin;
import com.liferay.gradle.plugins.extensions.LiferayExtension;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.configurator.BaseProjectConfigurator;
import com.liferay.gradle.plugins.workspace.internal.client.extension.ClientExtension;
import com.liferay.gradle.plugins.workspace.internal.client.extension.ClientExtensionTypeConfigurer;
import com.liferay.gradle.plugins.workspace.internal.client.extension.ConfigurationRuntimeTypeConfigurer;
import com.liferay.gradle.plugins.workspace.internal.client.extension.CustomElementTypeConfigurer;
import com.liferay.gradle.plugins.workspace.internal.client.extension.ThemeCSSTypeConfigurer;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.plugins.workspace.task.CreateClientExtensionConfigTask;
import com.liferay.petra.string.StringBundler;
import groovy.lang.Closure;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.Zip;

public class ClientExtensionProjectConfigurator
extends BaseProjectConfigurator {
    public static final String ASSEMBLE_CLIENT_EXTENSION_TASK_NAME = "assembleClientExtension";
    public static final String BUILD_CLIENT_EXTENSION_ZIP_TASK_NAME = "buildClientExtensionZip";
    public static final String CREATE_CLIENT_EXTENSION_CONFIG_TASK_NAME = "createClientExtensionConfig";
    protected static final String NAME = "client.extension";
    private static final String _CLIENT_EXTENSION_YAML = "client-extension.yaml";
    private static final boolean _DEFAULT_REPOSITORY_ENABLED = true;
    private final Map<String, List<ClientExtensionTypeConfigurer>> _clientExtensionConfigurers = new HashMap<String, List<ClientExtensionTypeConfigurer>>();
    private final boolean _defaultRepositoryEnabled;

    public ClientExtensionProjectConfigurator(Settings settings) {
        super(settings);
        this._clientExtensionConfigurers.put("configuration", Collections.singletonList(new ConfigurationRuntimeTypeConfigurer()));
        this._clientExtensionConfigurers.put("customElement", Collections.singletonList(new CustomElementTypeConfigurer()));
        this._clientExtensionConfigurers.put("themeCSS", Collections.singletonList(new ThemeCSSTypeConfigurer()));
        this._defaultRepositoryEnabled = GradleUtil.getProperty((ExtensionAware)settings, (String)"liferay.workspace.client.extension.default.repository.enabled", (boolean)true);
    }

    public void apply(Project project) {
        TaskProvider createClientExtensionConfigTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)CREATE_CLIENT_EXTENSION_CONFIG_TASK_NAME, CreateClientExtensionConfigTask.class);
        TaskProvider assembleClientExtensionTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)ASSEMBLE_CLIENT_EXTENSION_TASK_NAME, Copy.class);
        TaskProvider buildClientExtensionZipTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)BUILD_CLIENT_EXTENSION_ZIP_TASK_NAME, Zip.class);
        this._baseConfigureClientExtensionProject(project, (TaskProvider<Copy>)assembleClientExtensionTaskProvider, (TaskProvider<Zip>)buildClientExtensionZipTaskProvider, (TaskProvider<CreateClientExtensionConfigTask>)createClientExtensionConfigTaskProvider);
        File clientExtensionFile = project.file((Object)_CLIENT_EXTENSION_YAML);
        try (FileReader fileReader = new FileReader(clientExtensionFile);){
            ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            JsonNode rootJsonNode = objectMapper.readTree(clientExtensionFile);
            Iterator iterator = rootJsonNode.fields();
            iterator.forEachRemaining(entry -> {
                String id = (String)entry.getKey();
                if (Objects.equals("assemble", id)) {
                    JsonNode assembleJsonNode = (JsonNode)entry.getValue();
                    this._configureAssembleClientExtensionTask((TaskProvider<Copy>)assembleClientExtensionTaskProvider, assembleJsonNode);
                } else if (Objects.equals("runtime", id)) {
                    JsonNode runtimeJsonNode = (JsonNode)entry.getValue();
                    JsonNode runtimeTypeJsonNode = runtimeJsonNode.get("type");
                    if (runtimeTypeJsonNode != null) {
                        createClientExtensionConfigTaskProvider.configure(createClientExtensionConfigTask -> createClientExtensionConfigTask.setType(runtimeTypeJsonNode.asText()));
                        List<ClientExtensionTypeConfigurer> clientExtensionTypeConfigurers = this._clientExtensionConfigurers.getOrDefault(runtimeTypeJsonNode.asText(), Collections.emptyList());
                        clientExtensionTypeConfigurers.forEach(clientExtensionTypeConfigurer -> clientExtensionTypeConfigurer.apply(project, Optional.empty(), (TaskProvider<Copy>)assembleClientExtensionTaskProvider));
                    }
                } else {
                    JsonNode clientExtensionJsonNode = (JsonNode)entry.getValue();
                    try {
                        ClientExtension clientExtension = (ClientExtension)objectMapper.treeToValue((TreeNode)clientExtensionJsonNode, ClientExtension.class);
                        clientExtension.id = id;
                        clientExtension.projectName = project.getName();
                        createClientExtensionConfigTaskProvider.configure(createClientExtensionConfigTask -> createClientExtensionConfigTask.addClientExtension(clientExtension));
                        List<ClientExtensionTypeConfigurer> clientExtensionTypeConfigurers = this._clientExtensionConfigurers.getOrDefault(clientExtension.type, Collections.emptyList());
                        clientExtensionTypeConfigurers.forEach(clientExtensionTypeConfigurer -> clientExtensionTypeConfigurer.apply(project, Optional.of(clientExtension), (TaskProvider<Copy>)assembleClientExtensionTaskProvider));
                    }
                    catch (JsonProcessingException jsonProcessingException) {
                        throw new GradleException("Failed to parse client-extension " + id, (Throwable)jsonProcessingException);
                    }
                }
            });
        }
        catch (IOException ioException) {
            throw new GradleException(StringBundler.concat((String[])new String[]{"Failed parsing ", _CLIENT_EXTENSION_YAML, " file."}), (Throwable)ioException);
        }
    }

    @Override
    public String getName() {
        return "client-extension";
    }

    public boolean isDefaultRepositoryEnabled() {
        return this._defaultRepositoryEnabled;
    }

    @Override
    protected Iterable<File> doGetProjectDirs(final File rootDir) throws Exception {
        final HashSet<File> projectDirs = new HashSet<File>();
        Files.walkFileTree(rootDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                String dirName = String.valueOf(dirPath.getFileName());
                if (ClientExtensionProjectConfigurator.this.isExcludedDirName(dirName)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Path clientExtensionPath = dirPath.resolve(ClientExtensionProjectConfigurator._CLIENT_EXTENSION_YAML);
                if (Files.exists(clientExtensionPath, new LinkOption[0]) && !Objects.equals(dirPath, rootDir.toPath())) {
                    projectDirs.add(dirPath.toFile());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return projectDirs;
    }

    private TaskProvider<Zip> _baseConfigureClientExtensionProject(Project project, TaskProvider<Copy> assembleClientExtensionTaskProvider, TaskProvider<Zip> buildClientExtensionZipTaskProvider, TaskProvider<CreateClientExtensionConfigTask> createClientExtensionConfigTaskProvider) {
        if (this.isDefaultRepositoryEnabled()) {
            GradleUtil.addDefaultRepositories(project);
        }
        GradleUtil.applyPlugin((Project)project, BasePlugin.class);
        GradleUtil.applyPlugin((Project)project, LiferayBasePlugin.class);
        LiferayExtension liferayExtension = (LiferayExtension)GradleUtil.getExtension((ExtensionAware)project, LiferayExtension.class);
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)((ExtensionAware)project.getGradle()), WorkspaceExtension.class);
        this.configureLiferay(project, workspaceExtension);
        this._configureLiferayExtension(project, liferayExtension);
        this._configureConfigurationDefault(project);
        this._configureTaskClean(project);
        this._configureTaskDeploy(project);
        this._configureClientExtensionTasks(project, assembleClientExtensionTaskProvider, buildClientExtensionZipTaskProvider, createClientExtensionConfigTaskProvider);
        this.addTaskDockerDeploy(project, buildClientExtensionZipTaskProvider, new File(workspaceExtension.getDockerDir(), "client-extensions"));
        this._configureArtifacts(project, buildClientExtensionZipTaskProvider);
        this._configureRootTaskDistBundle(project, buildClientExtensionZipTaskProvider);
        return buildClientExtensionZipTaskProvider;
    }

    private void _configureArtifacts(Project project, TaskProvider<Zip> buildClientExtensionZipTaskProvider) {
        ArtifactHandler artifacts = project.getArtifacts();
        artifacts.add("archives", buildClientExtensionZipTaskProvider);
    }

    private void _configureAssembleClientExtensionTask(TaskProvider<Copy> assembleClientExtensionTaskProvider, JsonNode assembleJsonNode) {
        assembleClientExtensionTaskProvider.configure(copy -> assembleJsonNode.forEach(copyJsonNode -> {
            JsonNode fromJsonNode = copyJsonNode.get("from");
            JsonNode includeJsonNode = copyJsonNode.get("include");
            JsonNode intoJsonNode = copyJsonNode.get("into");
            copy.from((Object)(fromJsonNode != null ? fromJsonNode.asText() : "."), copySpec -> {
                if (includeJsonNode instanceof ArrayNode) {
                    ArrayNode arrayNode = (ArrayNode)includeJsonNode;
                    arrayNode.forEach(include -> copySpec.include(new String[]{include.asText()}));
                } else if (includeJsonNode != null) {
                    copySpec.include(new String[]{includeJsonNode.asText()});
                }
                if (intoJsonNode != null) {
                    copySpec.into((Object)intoJsonNode.asText());
                }
                copySpec.setIncludeEmptyDirs(false);
            });
        }));
    }

    private void _configureClientExtensionTasks(final Project project, TaskProvider<Copy> assembleClientExtensionTaskProvider, TaskProvider<Zip> buildClientExtensionZipTaskProvider, TaskProvider<CreateClientExtensionConfigTask> createClientExtensionConfigTaskProvider) {
        createClientExtensionConfigTaskProvider.configure(createClientExtensionConfigTask -> {
            TaskInputsInternal taskInputs = createClientExtensionConfigTask.getInputs();
            taskInputs.file((Object)project.file((Object)_CLIENT_EXTENSION_YAML));
        });
        assembleClientExtensionTaskProvider.configure(copy -> {
            copy.setDestinationDir(new File(project.getBuildDir(), "clientExtension"));
            copy.from(new Object[]{createClientExtensionConfigTaskProvider});
            copy.into((Object)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return "static";
                }
            }, (Closure)new Closure<Void>(copy){

                public void doCall(CopySpec copySpec) {
                    copySpec.from(new Object[]{project.file((Object)"assets")});
                    copySpec.include(new String[]{"**/*"});
                    copySpec.setIncludeEmptyDirs(false);
                }
            });
        });
        buildClientExtensionZipTaskProvider.configure(zip -> {
            DirectoryProperty destinationDirectoryProperty = zip.getDestinationDirectory();
            destinationDirectoryProperty.set(new File(project.getProjectDir(), "dist"));
            Property archiveBaseNameProperty = zip.getArchiveBaseName();
            archiveBaseNameProperty.set(project.provider((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return project.getName();
                }
            }));
            zip.from(new Object[]{assembleClientExtensionTaskProvider});
            zip.include(new String[]{"**/*"});
        });
    }

    private void _configureConfigurationDefault(Project project) {
        Configuration defaultConfiguration = GradleUtil.getConfiguration((Project)project, (String)"default");
        Configuration archivesConfiguration = GradleUtil.getConfiguration((Project)project, (String)"archives");
        defaultConfiguration.extendsFrom(new Configuration[]{archivesConfiguration});
    }

    private void _configureLiferayExtension(final Project project, final LiferayExtension liferayExtension) {
        liferayExtension.setDeployDir((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                File dir = new File(liferayExtension.getAppServerParentDir(), "osgi/client-extensions");
                dir.mkdirs();
                return GradleUtil.getProperty((Project)project, (String)"auto.deploy.dir", (File)dir);
            }
        });
    }

    private void _configureRootTaskDistBundle(Project project, final TaskProvider<Zip> buildClientExtensionZipTaskProvider) {
        final Task assembleTask = GradleUtil.getTask((Project)project, (String)"assemble");
        Copy copy = (Copy)GradleUtil.getTask((Project)project.getRootProject(), (String)"distBundle");
        copy.dependsOn(new Object[]{assembleTask});
        copy.into((Object)"osgi/client-extensions", (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                Project project = assembleTask.getProject();
                ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{buildClientExtensionZipTaskProvider});
                configurableFileCollection.builtBy(new Object[]{assembleTask});
                copySpec.from(new Object[]{buildClientExtensionZipTaskProvider});
            }
        });
    }

    private void _configureTaskClean(Project project) {
        Delete delete = (Delete)GradleUtil.getTask((Project)project, (String)"clean");
        delete.delete(new Object[]{"build", "dist"});
    }

    private void _configureTaskDeploy(Project project) {
        Copy copy = (Copy)GradleUtil.getTask((Project)project, (String)"deploy");
        copy.dependsOn(new Object[]{"assemble"});
        copy.from(new Object[]{this._getZipFile(project)});
    }

    private File _getZipFile(Project project) {
        return project.file((Object)("dist/" + GradleUtil.getArchivesBaseName(project) + ".zip"));
    }
}

