/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.soy.tasks;

import com.liferay.portal.tools.soy.builder.commands.BuildSoyCommand;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
@Deprecated
public class BuildSoyTask
extends SourceTask {
    private FileCollection _classpath;

    @TaskAction
    public void buildSoy() throws Exception {
        final ArrayList<Path> paths = new ArrayList<Path>();
        for (File file : this.getSource()) {
            paths.add(file.toPath());
        }
        this._withClasspath((Iterable<File>)this.getClasspath(), new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Thread currentThread = Thread.currentThread();
                ClassLoader contextClassLoader = currentThread.getContextClassLoader();
                Class<?> clazz = contextClassLoader.loadClass(BuildSoyCommand.class.getName());
                Method executeMethod = clazz.getMethod("execute", List.class);
                Object buildSoyCommand = clazz.newInstance();
                executeMethod.invoke(buildSoyCommand, paths);
                return null;
            }
        });
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getClasspath() {
        return this._classpath;
    }

    @OutputFiles
    public Iterable<File> getOutputFiles() {
        ArrayList<File> outputFiles = new ArrayList<File>();
        for (File sourceFile : this.getSource()) {
            String fileName = sourceFile.getName();
            File outputFile = new File(sourceFile.getParentFile(), fileName + ".js");
            outputFiles.add(outputFile);
        }
        return outputFiles;
    }

    public void setClasspath(FileCollection classpath) {
        this._classpath = classpath;
    }

    /*
     * Loose catch block
     */
    private <T> T _withClasspath(Iterable<File> classpath, Callable<T> callable) throws Exception {
        Thread currentThread = Thread.currentThread();
        URLClassLoader contextURLClassLoader = (URLClassLoader)currentThread.getContextClassLoader();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : classpath) {
            URI uri = file.toURI();
            urls.add(uri.toURL());
        }
        Collections.addAll(urls, contextURLClassLoader.getURLs());
        try {
            T t;
            try (URLClassLoader urlClassLoader = new URLClassLoader(urls.toArray(new URL[0]), null);){
                currentThread.setContextClassLoader(urlClassLoader);
                t = callable.call();
            }
            return t;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            currentThread.setContextClassLoader(contextURLClassLoader);
        }
    }
}

