/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.configurators;

import com.liferay.gradle.plugins.LiferayThemePlugin;
import com.liferay.gradle.plugins.gulp.ExecuteGulpTask;
import com.liferay.gradle.plugins.theme.builder.BuildThemeTask;
import com.liferay.gradle.plugins.theme.builder.ThemeBuilderPlugin;
import com.liferay.gradle.plugins.workspace.ProjectConfigurator;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.configurators.BaseProjectConfigurator;
import com.liferay.gradle.plugins.workspace.internal.LiferayThemeGulpPlugin;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.initialization.Settings;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.tasks.Copy;

public class ThemesProjectConfigurator
extends BaseProjectConfigurator {
    protected static final String NAME = "themes";
    private static final boolean _JAVA_BUILD = false;
    private boolean _javaBuild;

    public ThemesProjectConfigurator(Settings settings) {
        super(settings);
        this._javaBuild = GradleUtil.getProperty((ExtensionAware)settings, (String)"liferay.workspace.themes.java.build", (boolean)false);
    }

    public void apply(Project project) {
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)((ExtensionAware)project.getGradle()), WorkspaceExtension.class);
        if (this.isJavaBuild()) {
            ProjectConfigurator projectConfigurator = workspaceExtension.propertyMissing("wars");
            projectConfigurator.apply(project);
            GradleUtil.applyPlugin((Project)project, ThemeBuilderPlugin.class);
            this._configureTaskBuildTheme(project);
            this._configureWar(project);
        } else {
            GradleUtil.applyPlugin((Project)project, LiferayThemePlugin.class);
            LiferayThemeGulpPlugin.INSTANCE.apply((Object)project);
            this.configureLiferay(project, workspaceExtension);
            final Task assembleTask = GradleUtil.getTask((Project)project, (String)"assemble");
            this._configureRootTaskDistBundle(assembleTask);
            this._configureTaskGulpBuild(project, workspaceExtension);
            Callable<ConfigurableFileCollection> warSourcePath = new Callable<ConfigurableFileCollection>(){

                @Override
                public ConfigurableFileCollection call() throws Exception {
                    Project project = assembleTask.getProject();
                    ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{ThemesProjectConfigurator.this._getWarFile(project)});
                    return configurableFileCollection.builtBy(new Object[]{assembleTask});
                }
            };
            this.addTaskDockerDeploy(project, warSourcePath, workspaceExtension);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean isJavaBuild() {
        return this._javaBuild;
    }

    public void setJavaBuild(boolean javaBuild) {
        this._javaBuild = javaBuild;
    }

    @Override
    protected Iterable<File> doGetProjectDirs(File rootDir) throws Exception {
        final HashSet<File> projectDirs = new HashSet<File>();
        Files.walkFileTree(rootDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                String dirName = String.valueOf(dirPath.getFileName());
                if (ThemesProjectConfigurator.this.isExcludedDirName(dirName)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                Path gulpfileJsPath = dirPath.resolve("gulpfile.js");
                Path packageJsonPath = dirPath.resolve("package.json");
                if (Files.exists(gulpfileJsPath, new LinkOption[0]) && Files.exists(packageJsonPath, new LinkOption[0]) && ThemesProjectConfigurator.this._isLiferayTheme(packageJsonPath)) {
                    projectDirs.add(dirPath.toFile());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return projectDirs;
    }

    private void _configureRootTaskDistBundle(final Task assembleTask) {
        Project project = assembleTask.getProject();
        Copy copy = (Copy)GradleUtil.getTask((Project)project.getRootProject(), (String)"distBundle");
        copy.dependsOn(new Object[]{assembleTask});
        copy.into((Object)"osgi/war", (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                Project project = assembleTask.getProject();
                File warFile = ThemesProjectConfigurator.this._getWarFile(project);
                ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{warFile});
                configurableFileCollection.builtBy(new Object[]{assembleTask});
                copySpec.from(new Object[]{warFile});
            }
        });
    }

    private void _configureTaskBuildTheme(Project project) {
        File packageJsonFile = project.file((Object)"package.json");
        if (!packageJsonFile.exists()) {
            return;
        }
        BuildThemeTask buildThemeTask = (BuildThemeTask)GradleUtil.getTask((Project)project, (String)"buildTheme");
        Map<String, Object> packageJsonMap = this._getPackageJsonMap(packageJsonFile);
        Map liferayThemeMap = (Map)packageJsonMap.get("liferayTheme");
        String baseTheme = (String)liferayThemeMap.get("baseTheme");
        if (baseTheme.equals("styled") || baseTheme.equals("unstyled")) {
            baseTheme = "_" + baseTheme;
        }
        String templateLanguage = (String)liferayThemeMap.get("templateLanguage");
        buildThemeTask.setParentName((Object)baseTheme);
        buildThemeTask.setTemplateExtension((Object)templateLanguage);
    }

    private void _configureTaskGulpBuild(Project project, WorkspaceExtension workspaceExtension) {
        ExecuteGulpTask executeGulpTask = (ExecuteGulpTask)GradleUtil.getTask((Project)project, (String)"gulpBuild");
        File packageJsonFile = project.file((Object)"package.json");
        Map<String, Object> packageJsonMap = this._getPackageJsonMap(packageJsonFile);
        Map scriptsMap = (Map)packageJsonMap.get("scripts");
        if (scriptsMap != null) {
            String buildScript = (String)scriptsMap.get("build");
            if (buildScript != null && !buildScript.equals("")) {
                executeGulpTask.setEnabled(false);
            }
        } else {
            String nodePackageManager = workspaceExtension.getNodePackageManager();
            if (nodePackageManager.equals("yarn")) {
                Project rootProject = project.getRootProject();
                executeGulpTask.setScriptFile(rootProject.file((Object)"node_modules/gulp/bin/gulp.js"));
            }
        }
    }

    private void _configureWar(Project project) {
        WarPluginConvention warPluginConvention = (WarPluginConvention)GradleUtil.getConvention((Project)project, WarPluginConvention.class);
        warPluginConvention.setWebAppDirName("src");
    }

    private Map<String, Object> _getPackageJsonMap(File packageJsonFile) {
        if (!packageJsonFile.exists()) {
            return Collections.emptyMap();
        }
        JsonSlurper jsonSlurper = new JsonSlurper();
        return (Map)jsonSlurper.parse(packageJsonFile);
    }

    private File _getWarFile(Project project) {
        BasePluginConvention basePluginConvention = (BasePluginConvention)GradleUtil.getConvention((Project)project, BasePluginConvention.class);
        return project.file((Object)("dist/" + basePluginConvention.getArchivesBaseName() + ".war"));
    }

    private boolean _isLiferayTheme(Path packageJsonPath) {
        Map<String, Object> packageJsonMap = this._getPackageJsonMap(packageJsonPath.toFile());
        Map liferayTheme = (Map)packageJsonMap.get("liferayTheme");
        return liferayTheme != null;
    }
}

