/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.configurators;

import com.liferay.gradle.plugins.LiferayExtPlugin;
import com.liferay.gradle.plugins.LiferayOSGiExtPlugin;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.configurators.BaseProjectConfigurator;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.CopySourceSpec;
import org.gradle.api.initialization.Settings;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.Copy;

public class ExtProjectConfigurator
extends BaseProjectConfigurator {
    protected static final String NAME = "ext";
    private static final boolean _DEFAULT_REPOSITORY_ENABLED = true;
    private static final String[] _EXT_SOURCE_SET_NAMES = new String[]{"extImpl", "extKernel", "extUtilBridges", "extUtilJava", "extUtilTaglib"};
    private final boolean _defaultRepositoryEnabled;
    private final Set<File> _defaultRootDirs;

    public ExtProjectConfigurator(Settings settings) {
        super(settings);
        this._defaultRepositoryEnabled = GradleUtil.getProperty((ExtensionAware)settings, (String)"liferay.workspace.ext.default.repository.enabled", (boolean)true);
        String defaultRootDirNames = GradleUtil.getProperty((ExtensionAware)settings, (String)this.getDefaultRootDirPropertyName(), (String)null);
        if (Validator.isNotNull((String)defaultRootDirNames)) {
            this._defaultRootDirs = new HashSet<File>();
            for (String dirName : defaultRootDirNames.split("\\s*,\\s*")) {
                this._defaultRootDirs.add(new File(settings.getRootDir(), dirName));
            }
        } else {
            File dir = new File(settings.getRootDir(), this.getDefaultRootDirName());
            this._defaultRootDirs = Collections.singleton(dir);
        }
    }

    public void apply(Project project) {
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)((ExtensionAware)project.getGradle()), WorkspaceExtension.class);
        boolean extPlugin = this._isExtPlugin(project);
        this._applyPlugins(project, extPlugin);
        if (this.isDefaultRepositoryEnabled()) {
            GradleUtil.addDefaultRepositories(project);
        }
        this._configureRootTaskDistBundle(project, extPlugin);
        this.configureLiferay(project, workspaceExtension);
    }

    @Override
    public Iterable<File> getDefaultRootDirs() {
        return this._defaultRootDirs;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean isDefaultRepositoryEnabled() {
        return this._defaultRepositoryEnabled;
    }

    @Override
    protected Iterable<File> doGetProjectDirs(File rootDir) throws Exception {
        final HashSet<File> projectDirs = new HashSet<File>();
        Files.walkFileTree(rootDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) throws IOException {
                if (Files.isDirectory(dirPath.resolve("src"), new LinkOption[0])) {
                    projectDirs.add(dirPath.toFile());
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return projectDirs;
    }

    private void _applyPlugins(Project project, boolean extPlugin) {
        if (extPlugin) {
            GradleUtil.applyPlugin((Project)project, LiferayExtPlugin.class);
        } else {
            GradleUtil.applyPlugin((Project)project, LiferayOSGiExtPlugin.class);
        }
    }

    private void _configureRootTaskDistBundle(Project project, boolean extPlugin) {
        Copy copy = (Copy)GradleUtil.getTask((Project)project.getRootProject(), (String)"distBundle");
        String dirName = null;
        String taskName = null;
        if (extPlugin) {
            dirName = "osgi/war";
            taskName = "war";
        } else {
            dirName = "osgi/marketplace/override";
            taskName = "jar";
        }
        final Task task = GradleUtil.getTask((Project)project, (String)taskName);
        copy.into((Object)dirName, (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySourceSpec copySourceSpec) {
                copySourceSpec.from(new Object[]{task});
            }
        });
    }

    private boolean _isExtPlugin(Project project) {
        if (FileUtil.exists((Project)project, (String)"src/main/webapp")) {
            return true;
        }
        for (String name : _EXT_SOURCE_SET_NAMES) {
            if (!FileUtil.exists((Project)project, (String)("src/" + name))) continue;
            return true;
        }
        return false;
    }
}

