/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace;

import com.liferay.gradle.plugins.LiferayYarnPlugin;
import com.liferay.gradle.plugins.node.NodeExtension;
import com.liferay.gradle.plugins.node.tasks.NpmInstallTask;
import com.liferay.gradle.plugins.node.tasks.YarnInstallTask;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.plugins.workspace.tasks.SetUpYarnTask;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class LiferayWorkspaceYarnPlugin
extends LiferayYarnPlugin {
    public static final String SET_UP_YARN_TASK_NAME = "setUpYarn";
    public static final String YARN_INSTALL_TASK_NAME = "yarnInstall";

    public void apply(Project project) {
        super.apply(project);
        TaskProvider setUpYarnTaskProvider = GradleUtil.addTaskProvider((Project)project, (String)SET_UP_YARN_TASK_NAME, SetUpYarnTask.class);
        final TaskProvider yarnInstallTaskProvider = GradleUtil.getTaskProvider((Project)project, (String)YARN_INSTALL_TASK_NAME, YarnInstallTask.class);
        this._configureTaskYarnInstallProvider(project, (TaskProvider<YarnInstallTask>)yarnInstallTaskProvider, (TaskProvider<SetUpYarnTask>)setUpYarnTaskProvider);
        project.subprojects((Action)new Action<Project>(){

            public void execute(Project project) {
                LiferayWorkspaceYarnPlugin.this._configureNodeProject(project, (TaskProvider<YarnInstallTask>)yarnInstallTaskProvider);
            }
        });
    }

    private void _configureNodeProject(Project project, final TaskProvider<YarnInstallTask> yarnInstallTaskProvider) {
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                TaskContainer taskContainer = project.getTasks();
                taskContainer.withType(NpmInstallTask.class, (Action)new Action<NpmInstallTask>(){

                    public void execute(NpmInstallTask npmInstallTask) {
                        NodeExtension nodeExtension = (NodeExtension)GradleUtil.getExtension((ExtensionAware)npmInstallTask.getProject(), NodeExtension.class);
                        nodeExtension.setUseNpm((Object)false);
                        npmInstallTask.finalizedBy(new Object[]{yarnInstallTaskProvider});
                    }
                });
            }
        });
    }

    private void _configureTaskYarnInstallProvider(final Project project, TaskProvider<YarnInstallTask> yarnInstallTaskProvider, final TaskProvider<SetUpYarnTask> setUpYarnTaskProvider) {
        yarnInstallTaskProvider.configure((Action)new Action<YarnInstallTask>(){

            public void execute(YarnInstallTask yarnInstallTask) {
                block4: {
                    yarnInstallTask.dependsOn(new Object[]{setUpYarnTaskProvider});
                    try {
                        File file = new File(project.getProjectDir(), "yarn.lock");
                        if (file.exists()) {
                            String contents = new String(Files.readAllBytes(file.toPath()));
                            yarnInstallTask.setFrozenLockFile((Object)(!contents.equals("") ? 1 : 0));
                        } else {
                            yarnInstallTask.setFrozenLockFile((Object)false);
                        }
                    }
                    catch (IOException ioException) {
                        Logger logger = project.getLogger();
                        if (!logger.isWarnEnabled()) break block4;
                        StringBuilder sb = new StringBuilder();
                        sb.append("Unable to read yarn.lock.");
                        logger.warn(sb.toString());
                    }
                }
            }
        });
    }
}

