/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.configurators;

import com.bmuschko.gradle.docker.DockerRemoteApiPlugin;
import com.bmuschko.gradle.docker.tasks.container.DockerCreateContainer;
import com.bmuschko.gradle.docker.tasks.container.DockerLogsContainer;
import com.bmuschko.gradle.docker.tasks.container.DockerRemoveContainer;
import com.bmuschko.gradle.docker.tasks.container.DockerStartContainer;
import com.bmuschko.gradle.docker.tasks.container.DockerStopContainer;
import com.bmuschko.gradle.docker.tasks.image.DockerBuildImage;
import com.bmuschko.gradle.docker.tasks.image.DockerPullImage;
import com.bmuschko.gradle.docker.tasks.image.Dockerfile;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.internal.configurators.TargetPlatformRootProjectConfigurator;
import com.liferay.gradle.plugins.workspace.internal.util.FileUtil;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.plugins.workspace.tasks.CreateTokenTask;
import com.liferay.gradle.plugins.workspace.tasks.InitBundleTask;
import com.liferay.gradle.util.OSDetector;
import com.liferay.gradle.util.Validator;
import com.liferay.gradle.util.copy.StripPathSegmentsAction;
import de.undercouch.gradle.tasks.download.Download;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.io.FilenameUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.initialization.Settings;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.api.tasks.bundling.Compression;
import org.gradle.api.tasks.bundling.Tar;
import org.gradle.api.tasks.bundling.Zip;
import org.gradle.language.base.plugins.LifecycleBasePlugin;

public class RootProjectConfigurator
implements Plugin<Project> {
    public static final String BUILD_DOCKER_IMAGE_TASK_NAME = "buildDockerImage";
    public static final String BUNDLE_CONFIGURATION_NAME = "bundle";
    public static final String BUNDLE_GROUP = "bundle";
    public static final String BUNDLE_SUPPORT_CONFIGURATION_NAME = "bundleSupport";
    public static final String CLEAN_TASK_NAME = "clean";
    public static final String CREATE_DOCKER_CONTAINER_TASK_NAME = "createDockerContainer";
    public static final String CREATE_DOCKERFILE_TASK_NAME = "createDockerfile";
    public static final String CREATE_TOKEN_TASK_NAME = "createToken";
    public static final String DIST_BUNDLE_TAR_TASK_NAME = "distBundleTar";
    public static final String DIST_BUNDLE_TASK_NAME = "distBundle";
    public static final String DIST_BUNDLE_ZIP_TASK_NAME = "distBundleZip";
    public static final String DOCKER_DEPLOY_TASK_NAME = "dockerDeploy";
    public static final String DOCKER_GROUP = "docker";
    public static final String DOWNLOAD_BUNDLE_TASK_NAME = "downloadBundle";
    public static final String INIT_BUNDLE_TASK_NAME = "initBundle";
    public static final String LOGS_DOCKER_CONTAINER_TASK_NAME = "logsDockerContainer";
    public static final String PROVIDED_MODULES_CONFIGURATION_NAME = "providedModules";
    public static final String PULL_DOCKER_IMAGE_TASK_NAME = "pullDockerImage";
    public static final String REMOVE_DOCKER_CONTAINER_TASK_NAME = "removeDockerContainer";
    public static final String START_DOCKER_CONTAINER_TASK_NAME = "startDockerContainer";
    public static final String STOP_DOCKER_CONTAINER_TASK_NAME = "stopDockerContainer";
    private static final boolean _DEFAULT_REPOSITORY_ENABLED = true;
    private boolean _defaultRepositoryEnabled;

    @Deprecated
    public RootProjectConfigurator() {
    }

    public RootProjectConfigurator(Settings settings) {
        this._defaultRepositoryEnabled = GradleUtil.getProperty((Object)settings, "liferay.workspace.default.repository.enabled", true);
    }

    public void apply(Project project) {
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)((ExtensionAware)project.getGradle()), WorkspaceExtension.class);
        GradleUtil.applyPlugin((Project)project, DockerRemoteApiPlugin.class);
        GradleUtil.applyPlugin((Project)project, LifecycleBasePlugin.class);
        if (this.isDefaultRepositoryEnabled()) {
            GradleUtil.addDefaultRepositories(project);
        }
        Configuration bundleSupportConfiguration = this._addConfigurationBundleSupport(project);
        Configuration providedModulesConfiguration = this._addConfigurationProvidedModules(project);
        TargetPlatformRootProjectConfigurator.INSTANCE.apply((Object)project);
        CreateTokenTask createTokenTask = this._addTaskCreateToken(project, workspaceExtension);
        Download downloadBundleTask = this._addTaskDownloadBundle(createTokenTask, workspaceExtension);
        Copy distBundleTask = this._addTaskDistBundle(project, downloadBundleTask, workspaceExtension, providedModulesConfiguration);
        Tar distBundleTarTask = this._addTaskDistBundle(project, DIST_BUNDLE_TAR_TASK_NAME, Tar.class, distBundleTask, workspaceExtension);
        distBundleTarTask.setCompression(Compression.GZIP);
        distBundleTarTask.setExtension("tar.gz");
        this._addTaskDistBundle(project, DIST_BUNDLE_ZIP_TASK_NAME, Zip.class, distBundleTask, workspaceExtension);
        this._addTaskInitBundle(project, downloadBundleTask, workspaceExtension, bundleSupportConfiguration, providedModulesConfiguration);
        Dockerfile dockerfile = this._addTaskCreateDockerfile(project, workspaceExtension);
        this._addTaskBuildDockerImage(dockerfile, workspaceExtension);
        this._addTaskCreateDockerContainer(project, workspaceExtension);
        this._addTaskDockerDeploy(project, workspaceExtension, providedModulesConfiguration);
        this._addTaskLogsDockerContainer(project);
        this._addTaskPullDockerImage(project, workspaceExtension);
        this._addTaskRemoveDockerContainer(project);
        this._addTaskStartDockerContainer(project);
        this._addTaskStopDockerContainer(project);
    }

    public boolean isDefaultRepositoryEnabled() {
        return this._defaultRepositoryEnabled;
    }

    public void setDefaultRepositoryEnabled(boolean defaultRepositoryEnabled) {
        this._defaultRepositoryEnabled = defaultRepositoryEnabled;
    }

    private Configuration _addConfigurationBundleSupport(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)BUNDLE_SUPPORT_CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                RootProjectConfigurator.this._addDependenciesBundleSupport(project);
            }
        });
        configuration.setDescription("Configures Liferay Bundle Support for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    private Configuration _addConfigurationProvidedModules(Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)PROVIDED_MODULES_CONFIGURATION_NAME);
        configuration.setDescription("Configures additional 3rd-party OSGi modules to add to Liferay.");
        configuration.setTransitive(false);
        configuration.setVisible(true);
        return configuration;
    }

    private void _addDependenciesBundleSupport(Project project) {
        GradleUtil.addDependency((Project)project, (String)BUNDLE_SUPPORT_CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.portal.tools.bundle.support", (String)"latest.release");
    }

    private DockerBuildImage _addTaskBuildDockerImage(Dockerfile dockerfile, WorkspaceExtension workspaceExtension) {
        Project project = dockerfile.getProject();
        DockerBuildImage dockerBuildImage = (DockerBuildImage)GradleUtil.addTask((Project)project, (String)BUILD_DOCKER_IMAGE_TASK_NAME, DockerBuildImage.class);
        dockerBuildImage.dependsOn(new Object[]{dockerfile, PULL_DOCKER_IMAGE_TASK_NAME});
        dockerBuildImage.setDescription("Builds the Docker image with all modules/configs deployed.");
        dockerBuildImage.setGroup(DOCKER_GROUP);
        dockerBuildImage.setInputDir(workspaceExtension.getDockerDir());
        dockerBuildImage.setTag(project.getName() + ":" + workspaceExtension.getEnvironment());
        return dockerBuildImage;
    }

    private Copy _addTaskCopyBundle(Project project, String taskName, Download downloadBundleTask, final WorkspaceExtension workspaceExtension, Configuration providedModulesConfiguration) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)taskName, Copy.class);
        this._configureTaskCopyBundleFromConfig(copy, new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(workspaceExtension.getConfigsDir(), workspaceExtension.getEnvironment());
            }
        });
        this._configureTaskCopyBundleFromConfig(copy, new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(workspaceExtension.getConfigsDir(), "common");
            }
        });
        copy.from((Object)providedModulesConfiguration, (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                copySpec.into((Object)"osgi/modules");
            }
        });
        this._configureTaskCopyBundleFromDownload(copy, downloadBundleTask);
        this._configureTaskCopyBundlePreserveTimestamps(copy);
        copy.dependsOn(new Object[]{downloadBundleTask});
        copy.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Copy copy = (Copy)task;
                Project project = copy.getProject();
                project.delete(new Object[]{copy.getDestinationDir()});
            }
        });
        copy.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
        return copy;
    }

    private DockerCreateContainer _addTaskCreateDockerContainer(Project project, final WorkspaceExtension workspaceExtension) {
        DockerCreateContainer dockerCreateContainer = (DockerCreateContainer)GradleUtil.addTask((Project)project, (String)CREATE_DOCKER_CONTAINER_TASK_NAME, DockerCreateContainer.class);
        dockerCreateContainer.dependsOn(new Object[]{REMOVE_DOCKER_CONTAINER_TASK_NAME, DOCKER_DEPLOY_TASK_NAME, PULL_DOCKER_IMAGE_TASK_NAME});
        File dockerDir = workspaceExtension.getDockerDir();
        String dockerPath = dockerDir.getAbsolutePath();
        if (OSDetector.isWindows()) {
            String prefix = FilenameUtils.getPrefix((String)dockerPath);
            if (prefix.contains(":")) {
                dockerPath = '/' + dockerPath.replace(":", "");
            }
            dockerPath = dockerPath.replace('\\', '/');
        }
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put(dockerPath, "/etc/liferay/mount");
        dockerCreateContainer.setBinds(binds);
        dockerCreateContainer.setContainerName(project.getName() + "-liferayapp");
        dockerCreateContainer.setDescription("Creates a Docker container from your liferay image and mounts " + dockerPath + " to /etc/liferay.");
        ArrayList<String> portBindings = new ArrayList<String>();
        portBindings.add("8080:8080");
        portBindings.add("11311:11311");
        dockerCreateContainer.setPortBindings(portBindings);
        dockerCreateContainer.targetImageId((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return workspaceExtension.getDockerImageLiferay();
            }
        });
        return dockerCreateContainer;
    }

    private Dockerfile _addTaskCreateDockerfile(Project project, final WorkspaceExtension workspaceExtension) {
        final Dockerfile dockerfile = (Dockerfile)GradleUtil.addTask((Project)project, (String)CREATE_DOCKERFILE_TASK_NAME, Dockerfile.class);
        dockerfile.dependsOn(new Object[]{DOCKER_DEPLOY_TASK_NAME});
        dockerfile.from(workspaceExtension.getDockerImageLiferay());
        dockerfile.instruction("COPY --chown=liferay:liferay deploy /etc/liferay/mount/deploy");
        dockerfile.instruction("COPY --chown=liferay:liferay files /etc/liferay/mount/files");
        dockerfile.setDescription("Creates a dockerfile to build the Docker image.");
        dockerfile.setGroup(DOCKER_GROUP);
        dockerfile.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                block4: {
                    try {
                        File destinationDir = workspaceExtension.getDockerDir();
                        destinationDir.delete();
                        destinationDir.mkdirs();
                        File dir = new File(destinationDir, "files");
                        if (!dir.exists()) {
                            dir.mkdirs();
                        }
                        File file = new File(dir, ".touch");
                        file.createNewFile();
                        dir = new File(destinationDir, "deploy");
                        if (!dir.exists()) {
                            dir.mkdirs();
                        }
                        file = new File(dir, ".touch");
                        file.createNewFile();
                    }
                    catch (IOException ioe) {
                        Logger logger = dockerfile.getLogger();
                        if (!logger.isWarnEnabled()) break block4;
                        StringBuilder sb = new StringBuilder();
                        sb.append("Could not create a placeholder file. ");
                        sb.append("Please make sure you have at least ");
                        sb.append("one config or the buildDockerImage ");
                        sb.append("task will fail.");
                        logger.warn(sb.toString());
                    }
                }
            }
        });
        return dockerfile;
    }

    private CreateTokenTask _addTaskCreateToken(Project project, final WorkspaceExtension workspaceExtension) {
        CreateTokenTask createTokenTask = (CreateTokenTask)GradleUtil.addTask((Project)project, (String)CREATE_TOKEN_TASK_NAME, CreateTokenTask.class);
        createTokenTask.setDescription("Creates a liferay.com download token.");
        createTokenTask.setEmailAddress(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return workspaceExtension.getBundleTokenEmailAddress();
            }
        });
        createTokenTask.setForce(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return workspaceExtension.isBundleTokenForce();
            }
        });
        createTokenTask.setGroup("bundle");
        createTokenTask.setPassword(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return workspaceExtension.getBundleTokenPassword();
            }
        });
        createTokenTask.setPasswordFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return workspaceExtension.getBundleTokenPasswordFile();
            }
        });
        return createTokenTask;
    }

    private Copy _addTaskDistBundle(final Project project, Download downloadBundleTask, WorkspaceExtension workspaceExtension, Configuration providedModulesConfiguration) {
        Copy copy = this._addTaskCopyBundle(project, DIST_BUNDLE_TASK_NAME, downloadBundleTask, workspaceExtension, providedModulesConfiguration);
        this._configureTaskDisableUpToDate((Task)copy);
        copy.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(project.getBuildDir(), "dist");
            }
        });
        copy.setDescription("Assembles the Liferay bundle.");
        return copy;
    }

    private <T extends AbstractArchiveTask> T _addTaskDistBundle(Project project, String taskName, Class<T> clazz, final Copy distBundleTask, final WorkspaceExtension workspaceExtension) {
        AbstractArchiveTask task = (AbstractArchiveTask)GradleUtil.addTask((Project)project, (String)taskName, clazz);
        this._configureTaskDisableUpToDate((Task)task);
        task.into((Object)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String bundleDistRootDirName = workspaceExtension.getBundleDistRootDirName();
                if (Validator.isNull((String)bundleDistRootDirName)) {
                    bundleDistRootDirName = "";
                }
                return bundleDistRootDirName;
            }
        }, (Closure)new Closure<Void>((Object)task){

            public void doCall(CopySpec copySpec) {
                copySpec.from(new Object[]{distBundleTask});
            }
        });
        task.setBaseName(project.getName());
        task.setDescription("Assembles the Liferay bundle and zips it up.");
        task.setDestinationDir(project.getBuildDir());
        task.setGroup("bundle");
        return (T)task;
    }

    private Copy _addTaskDockerDeploy(Project project, final WorkspaceExtension workspaceExtension, Configuration providedModulesConfiguration) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)DOCKER_DEPLOY_TASK_NAME, Copy.class);
        copy.setDescription("Copy the Docker configs and provided configurations to the docker directory.");
        copy.setDestinationDir(workspaceExtension.getDockerDir());
        copy.from((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(workspaceExtension.getConfigsDir(), "common");
            }
        }, (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                copySpec.into((Object)"files");
            }
        });
        copy.from((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(workspaceExtension.getConfigsDir(), RootProjectConfigurator.DOCKER_GROUP);
            }
        }, (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                copySpec.into((Object)"files");
            }
        });
        copy.from((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(workspaceExtension.getConfigsDir(), workspaceExtension.getEnvironment());
            }
        }, (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                copySpec.into((Object)"files");
            }
        });
        copy.from((Object)providedModulesConfiguration, (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                copySpec.into((Object)"deploy");
            }
        });
        Task deployTask = GradleUtil.addTask((Project)project, (String)"deploy", Copy.class);
        deployTask.finalizedBy(new Object[]{copy});
        return copy;
    }

    private Download _addTaskDownloadBundle(final CreateTokenTask createTokenTask, final WorkspaceExtension workspaceExtension) {
        Project project = createTokenTask.getProject();
        final Download download = (Download)GradleUtil.addTask((Project)project, (String)DOWNLOAD_BUNDLE_TASK_NAME, Download.class);
        download.doFirst((Action)new Action<Task>(){

            public void execute(Task task) {
                Logger logger = download.getLogger();
                Project project = download.getProject();
                if (workspaceExtension.isBundleTokenDownload()) {
                    String token = FileUtil.read(createTokenTask.getTokenFile());
                    token = token.trim();
                    download.header("Authorization", "Bearer " + token);
                }
                for (Object src : RootProjectConfigurator.this._getSrcList(download)) {
                    File file;
                    block5: {
                        file = null;
                        try {
                            URI uri = project.uri(src);
                            file = project.file((Object)uri);
                        }
                        catch (Exception e) {
                            if (!logger.isDebugEnabled()) break block5;
                            logger.debug(e.getMessage(), (Throwable)e);
                        }
                    }
                    if (file == null || !file.exists()) continue;
                    File destinationFile = download.getDest();
                    if (destinationFile.isDirectory()) {
                        destinationFile = new File(destinationFile, file.getName());
                    }
                    if (!destinationFile.equals(file)) continue;
                    throw new GradleException("Download source " + file + " and destination " + destinationFile + " cannot be the same");
                }
            }
        });
        download.onlyIfNewer(true);
        download.setDescription("Downloads the Liferay bundle zip file.");
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                if (workspaceExtension.isBundleTokenDownload()) {
                    download.dependsOn(new Object[]{createTokenTask});
                }
                File destinationDir = workspaceExtension.getBundleCacheDir();
                destinationDir.mkdirs();
                download.dest((Object)destinationDir);
                List srcList = RootProjectConfigurator.this._getSrcList(download);
                if (!srcList.isEmpty()) {
                    return;
                }
                String bundleUrl = workspaceExtension.getBundleUrl();
                try {
                    if (bundleUrl.startsWith("file:")) {
                        URL url = new URL(bundleUrl);
                        File file = new File(url.getFile());
                        file = file.getAbsoluteFile();
                        URI uri = file.toURI();
                        bundleUrl = uri.toASCIIString();
                    } else {
                        bundleUrl = bundleUrl.replace(" ", "%20");
                    }
                    download.src((Object)bundleUrl);
                }
                catch (MalformedURLException murle) {
                    throw new GradleException(murle.getMessage(), (Throwable)murle);
                }
            }
        });
        return download;
    }

    private InitBundleTask _addTaskInitBundle(Project project, final Download downloadBundleTask, final WorkspaceExtension workspaceExtension, Configuration configurationBundleSupport, Configuration configurationOsgiModules) {
        InitBundleTask initBundleTask = (InitBundleTask)GradleUtil.addTask((Project)project, (String)INIT_BUNDLE_TASK_NAME, InitBundleTask.class);
        initBundleTask.dependsOn(new Object[]{downloadBundleTask});
        initBundleTask.setClasspath((FileCollection)configurationBundleSupport);
        initBundleTask.setConfigEnvironment(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return workspaceExtension.getEnvironment();
            }
        });
        initBundleTask.setConfigsDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return workspaceExtension.getConfigsDir();
            }
        });
        initBundleTask.setDescription("Downloads and unzips the bundle.");
        initBundleTask.setDestinationDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return workspaceExtension.getHomeDir();
            }
        });
        initBundleTask.setFile(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return RootProjectConfigurator.this._getDownloadFile(downloadBundleTask);
            }
        });
        initBundleTask.setGroup("bundle");
        initBundleTask.setProvidedModules((FileCollection)configurationOsgiModules);
        return initBundleTask;
    }

    private DockerLogsContainer _addTaskLogsDockerContainer(final Project project) {
        DockerLogsContainer dockerLogsContainer = (DockerLogsContainer)GradleUtil.addTask((Project)project, (String)LOGS_DOCKER_CONTAINER_TASK_NAME, DockerLogsContainer.class);
        dockerLogsContainer.setDescription("Logs the Docker container.");
        dockerLogsContainer.setFollow(Boolean.valueOf(true));
        dockerLogsContainer.setTailAll(Boolean.valueOf(true));
        dockerLogsContainer.targetContainerId((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return project.getName() + "-liferayapp";
            }
        });
        return dockerLogsContainer;
    }

    private DockerPullImage _addTaskPullDockerImage(Project project, WorkspaceExtension workspaceExtension) {
        DockerPullImage dockerPullImage = (DockerPullImage)GradleUtil.addTask((Project)project, (String)PULL_DOCKER_IMAGE_TASK_NAME, DockerPullImage.class);
        dockerPullImage.setDescription("Pull the Docker image.");
        String dockerImageLiferay = workspaceExtension.getDockerImageLiferay();
        int index = dockerImageLiferay.indexOf(":");
        dockerPullImage.setRepository(dockerImageLiferay.substring(0, index));
        dockerPullImage.setTag(dockerImageLiferay.substring(index + 1));
        return dockerPullImage;
    }

    private DockerRemoveContainer _addTaskRemoveDockerContainer(final Project project) {
        DockerRemoveContainer dockerRemoveContainer = (DockerRemoveContainer)GradleUtil.addTask((Project)project, (String)REMOVE_DOCKER_CONTAINER_TASK_NAME, DockerRemoveContainer.class);
        dockerRemoveContainer.setDescription("Removes the Docker container.");
        dockerRemoveContainer.setForce(Boolean.valueOf(true));
        dockerRemoveContainer.setRemoveVolumes(Boolean.valueOf(true));
        dockerRemoveContainer.targetContainerId((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return project.getName() + "-liferayapp";
            }
        });
        dockerRemoveContainer.setOnError((Closure)new Closure<Void>((Object)project){

            public void doCall(Exception e) {
                Logger logger = project.getLogger();
                if (logger.isWarnEnabled()) {
                    logger.warn("No container with ID '" + project.getName() + "-liferayapp' found.");
                }
            }
        });
        return dockerRemoveContainer;
    }

    private DockerStartContainer _addTaskStartDockerContainer(final Project project) {
        DockerStartContainer dockerStartContainer = (DockerStartContainer)GradleUtil.addTask((Project)project, (String)START_DOCKER_CONTAINER_TASK_NAME, DockerStartContainer.class);
        dockerStartContainer.setDescription("Starts the Docker container.");
        dockerStartContainer.targetContainerId((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return project.getName() + "-liferayapp";
            }
        });
        return dockerStartContainer;
    }

    private DockerStopContainer _addTaskStopDockerContainer(final Project project) {
        DockerStopContainer dockerStopContainer = (DockerStopContainer)GradleUtil.addTask((Project)project, (String)STOP_DOCKER_CONTAINER_TASK_NAME, DockerStopContainer.class);
        dockerStopContainer.setDescription("Stops the Docker container.");
        dockerStopContainer.targetContainerId((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return project.getName() + "-liferayapp";
            }
        });
        return dockerStopContainer;
    }

    private void _configureTaskCopyBundleFromConfig(Copy copy, Callable<File> dir) {
        copy.from(dir, (Closure)new Closure<Void>((Object)copy.getProject()){

            public void doCall(CopySpec copySpec) {
                copySpec.exclude(new String[]{"**/.touch"});
            }
        });
    }

    private void _configureTaskCopyBundleFromDownload(Copy copy, final Download download) {
        final Project project = copy.getProject();
        final HashSet rootDirNames = new HashSet();
        copy.dependsOn(new Object[]{download});
        copy.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Copy copy = (Copy)task;
                File destinationDir = copy.getDestinationDir();
                for (String rootDirName : rootDirNames) {
                    FileUtil.moveTree(new File(destinationDir, rootDirName), destinationDir);
                }
            }
        });
        copy.from((Object)new Callable<FileCollection>(){

            @Override
            public FileCollection call() throws Exception {
                File file = RootProjectConfigurator.this._getDownloadFile(download);
                String fileName = file.getName();
                if (fileName.endsWith(".tar.gz")) {
                    return project.tarTree((Object)file);
                }
                return project.zipTree((Object)file);
            }
        }, (Closure)new Closure<Void>((Object)project){

            public void doCall(CopySpec copySpec) {
                copySpec.eachFile((Action)new Action<FileCopyDetails>(){

                    public void execute(FileCopyDetails fileCopyDetails) {
                        RelativePath relativePath = fileCopyDetails.getRelativePath();
                        String[] segments = relativePath.getSegments();
                        rootDirNames.add(segments[0]);
                    }
                });
                copySpec.eachFile((Action)new StripPathSegmentsAction(1));
            }
        });
    }

    private void _configureTaskCopyBundlePreserveTimestamps(Copy copy) {
        final HashSet fileCopyDetailsSet = new HashSet();
        copy.doLast((Action)new Action<Task>(){

            public void execute(Task task) {
                Copy copy = (Copy)task;
                Logger logger = copy.getLogger();
                for (FileCopyDetails fileCopyDetails : fileCopyDetailsSet) {
                    File file = new File(copy.getDestinationDir(), fileCopyDetails.getPath());
                    if (!file.exists()) {
                        logger.error("Unable to set last modified time of {}, it has not been copied", (Object)file);
                        return;
                    }
                    boolean success = file.setLastModified(fileCopyDetails.getLastModified());
                    if (success) continue;
                    logger.error("Unable to set last modified time of {}", (Object)file);
                }
            }
        });
        copy.eachFile((Action)new Action<FileCopyDetails>(){

            public void execute(FileCopyDetails fileCopyDetails) {
                fileCopyDetailsSet.add(fileCopyDetails);
            }
        });
    }

    private void _configureTaskDisableUpToDate(Task task) {
        TaskOutputs taskOutputs = task.getOutputs();
        taskOutputs.upToDateWhen((Spec)new Spec<Task>(){

            public boolean isSatisfiedBy(Task task) {
                return false;
            }
        });
    }

    private File _getDownloadFile(Download download) {
        URL url = (URL)download.getSrc();
        String fileName = url.toString();
        return new File(download.getDest(), fileName.substring(fileName.lastIndexOf(47) + 1));
    }

    private List<?> _getSrcList(Download download) {
        Object src = download.getSrc();
        if (src == null) {
            return Collections.emptyList();
        }
        if (src instanceof List) {
            return (List)src;
        }
        return Collections.singletonList(src);
    }
}

