/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.configurators;

import com.liferay.gradle.plugins.workspace.ProjectConfigurator;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.initialization.Settings;
import org.gradle.api.tasks.Copy;

public abstract class BaseProjectConfigurator
implements ProjectConfigurator {
    private final Set<File> _defaultRootDirs;

    public BaseProjectConfigurator(Settings settings) {
        String defaultRootDirNames = GradleUtil.getProperty((Object)settings, this.getDefaultRootDirPropertyName(), null);
        if (Validator.isNotNull((String)defaultRootDirNames)) {
            this._defaultRootDirs = new HashSet<File>();
            for (String dirName : defaultRootDirNames.split("\\s*,\\s*")) {
                File dir = new File(settings.getRootDir(), dirName);
                this._defaultRootDirs.add(dir);
            }
        } else {
            File dir = new File(settings.getRootDir(), this.getDefaultRootDirName());
            this._defaultRootDirs = Collections.singleton(dir);
        }
    }

    @Override
    public void configureRootProject(Project project, WorkspaceExtension workspaceExtension) {
    }

    @Override
    public Iterable<File> getDefaultRootDirs() {
        return this._defaultRootDirs;
    }

    @Override
    public Iterable<File> getProjectDirs(File rootDir) {
        try {
            if (!rootDir.exists()) {
                return Collections.emptySet();
            }
            return this.doGetProjectDirs(rootDir);
        }
        catch (Exception e) {
            throw new GradleException("Unable to get project directories from " + rootDir, (Throwable)e);
        }
    }

    protected Copy addTaskDockerDeploy(Project project, Object sourcePath, WorkspaceExtension workspaceExtension) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)"dockerDeploy", Copy.class);
        copy.from(new Object[]{sourcePath});
        final File dockerDir = workspaceExtension.getDockerDir();
        copy.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(dockerDir, "deploy");
            }
        });
        copy.setDescription("Assembles the project and deploys it to the Liferay Docker container.");
        copy.setGroup("docker");
        Task buildDockerImageTask = GradleUtil.getTask((Project)project.getRootProject(), (String)"buildDockerImage");
        buildDockerImageTask.dependsOn(new Object[]{copy});
        Task createDockerContainerTask = GradleUtil.getTask((Project)project.getRootProject(), (String)"createDockerContainer");
        createDockerContainerTask.dependsOn(new Object[]{copy});
        Task deployTask = GradleUtil.getTask((Project)project, (String)"deploy");
        deployTask.finalizedBy(new Object[]{copy});
        return copy;
    }

    protected abstract Iterable<File> doGetProjectDirs(File var1) throws Exception;

    protected String getDefaultRootDirName() {
        return this.getName();
    }

    protected String getDefaultRootDirPropertyName() {
        return "liferay.workspace." + this.getName() + ".dir";
    }
}

