/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.internal.configurators;

import com.liferay.gradle.plugins.LiferayOSGiPlugin;
import com.liferay.gradle.plugins.target.platform.TargetPlatformIDEPlugin;
import com.liferay.gradle.plugins.target.platform.extensions.TargetPlatformExtension;
import com.liferay.gradle.plugins.target.platform.extensions.TargetPlatformIDEExtension;
import com.liferay.gradle.plugins.workspace.WorkspaceExtension;
import com.liferay.gradle.plugins.workspace.internal.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.specs.Spec;

public class TargetPlatformRootProjectConfigurator
implements Plugin<Project> {
    public static final Plugin<Project> INSTANCE = new TargetPlatformRootProjectConfigurator();
    private final Pattern _externalVersionPattern = Pattern.compile("([0-9]+)\\.([0-9]+)-([A-Za-z]+)([0-9]+)");

    public void apply(Project project) {
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)GradleUtil.getExtension((ExtensionAware)((ExtensionAware)project.getGradle()), WorkspaceExtension.class);
        String targetPlatformVersion = workspaceExtension.getTargetPlatformVersion();
        if (Validator.isNull((String)targetPlatformVersion)) {
            return;
        }
        Matcher matcher = this._externalVersionPattern.matcher(targetPlatformVersion);
        String repositoryVersion = null;
        if (matcher.matches()) {
            StringBuilder sb = new StringBuilder();
            sb.append(matcher.group(1));
            sb.append('.');
            sb.append(matcher.group(2));
            sb.append('.');
            String label = matcher.group(3);
            try {
                int labelNumber = Integer.parseInt(matcher.group(4));
                if (label.startsWith("GA")) {
                    sb.append(labelNumber - 1);
                } else if (label.startsWith("sp")) {
                    sb.append(labelNumber);
                }
            }
            catch (NumberFormatException nfe) {
                throw new GradleException("Invalid version property value", (Throwable)nfe);
            }
            repositoryVersion = this._fixBadVersionNumbers(sb.toString());
        } else {
            repositoryVersion = targetPlatformVersion;
        }
        GradleUtil.applyPlugin((Project)project, TargetPlatformIDEPlugin.class);
        this._configureConfigurationBundles(project);
        this._configureTargetPlatform(project);
        this._configureTargetPlatformIDE(project);
        this._addDependenciesTargetPlatformBoms(project, repositoryVersion);
        this._addDependenciesTargetPlatformDistro(project, repositoryVersion);
    }

    private TargetPlatformRootProjectConfigurator() {
    }

    private void _addDependenciesTargetPlatformBoms(Project project, String targetPlatformVersion) {
        GradleUtil.addDependency((Project)project, (String)"targetPlatformBoms", (String)"com.liferay", (String)"com.liferay.ce.portal.bom", (String)targetPlatformVersion);
        GradleUtil.addDependency((Project)project, (String)"targetPlatformBoms", (String)"com.liferay", (String)"com.liferay.ce.portal.compile.only", (String)targetPlatformVersion);
    }

    private void _addDependenciesTargetPlatformDistro(final Project project, final String targetPlatformVersion) {
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"targetPlatformDistro");
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                GradleUtil.addDependency((Project)project, (String)"targetPlatformDistro", (String)"com.liferay", (String)"com.liferay.ce.portal.distro", (String)targetPlatformVersion);
            }
        });
    }

    private void _configureConfigurationBundles(Project project) {
        Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"targetPlatformBundles");
        Configuration providedModulesConfiguration = GradleUtil.getConfiguration((Project)project, (String)"providedModules");
        configuration.extendsFrom(new Configuration[]{providedModulesConfiguration});
    }

    private void _configureTargetPlatform(Project project) {
        TargetPlatformExtension targetPlatformExtension = (TargetPlatformExtension)GradleUtil.getExtension((ExtensionAware)project, TargetPlatformExtension.class);
        targetPlatformExtension.resolveOnlyIf((Spec)new Spec<Project>(){

            public boolean isSatisfiedBy(Project project) {
                String projectName = project.getName();
                return !projectName.endsWith("-test");
            }
        });
        targetPlatformExtension.resolveOnlyIf((Spec)new Spec<Project>(){

            public boolean isSatisfiedBy(Project project) {
                PluginContainer pluginContainer = project.getPlugins();
                return pluginContainer.hasPlugin(LiferayOSGiPlugin.class);
            }
        });
    }

    private void _configureTargetPlatformIDE(Project project) {
        TargetPlatformIDEExtension targetPlatformIDEExtension = (TargetPlatformIDEExtension)GradleUtil.getExtension((ExtensionAware)project, TargetPlatformIDEExtension.class);
        targetPlatformIDEExtension.includeGroups(new Object[]{"com.liferay", "com.liferay.portal"});
    }

    private String _fixBadVersionNumbers(String version) {
        if (version.equals("7.0.6")) {
            return "7.0.6.1";
        }
        return version;
    }
}

