/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.workspace.configurators;

import com.liferay.gradle.plugins.workspace.configurators.ProjectConfigurator;
import com.liferay.gradle.plugins.workspace.util.GradleUtil;
import java.io.File;
import java.util.Collections;
import org.gradle.api.GradleException;
import org.gradle.api.initialization.Settings;

public abstract class BaseProjectConfigurator
implements ProjectConfigurator {
    private final File _defaultRootDir;

    public BaseProjectConfigurator(Settings settings) {
        File defaultRootDir = new File(settings.getRootDir(), this.getDefaultRootDirName());
        this._defaultRootDir = GradleUtil.getProperty(settings, this.getDefaultRootDirPropertyName(), defaultRootDir);
    }

    @Override
    public File getDefaultRootDir() {
        return this._defaultRootDir;
    }

    @Override
    public Iterable<File> getProjectDirs(File rootDir) {
        try {
            if (!rootDir.exists()) {
                return Collections.emptySet();
            }
            return this.doGetProjectDirs(rootDir);
        }
        catch (Exception e) {
            throw new GradleException("Unable to get project directories from " + rootDir, (Throwable)e);
        }
    }

    protected abstract Iterable<File> doGetProjectDirs(File var1) throws Exception;

    protected String getDefaultRootDirName() {
        return this.getName();
    }

    protected String getDefaultRootDirPropertyName() {
        return "liferay.workspace." + this.getName() + ".dir";
    }
}

