/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.upgrade.table.builder;

import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

@CacheableTask
public class BuildUpgradeTableTask
extends JavaExec {
    private Object _baseDir = "./";
    private boolean _osgiModule = true;
    private Object _releaseInfoVersion;
    private Object _upgradeTableDir;

    public BuildUpgradeTableTask() {
        Property mainClass = this.getMainClass();
        mainClass.set((Object)"com.liferay.portal.tools.upgrade.table.builder.UpgradeTableBuilder");
    }

    public void exec() {
        this.setArgs(this._getCompleteArgs());
        super.exec();
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getBaseDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._baseDir);
    }

    @Input
    @Optional
    public String getReleaseInfoVersion() {
        return GradleUtil.toString((Object)this._releaseInfoVersion);
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getUpgradeTableDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._upgradeTableDir);
    }

    @Input
    public boolean isOsgiModule() {
        return this._osgiModule;
    }

    public void setBaseDir(Object baseDir) {
        this._baseDir = baseDir;
    }

    public void setOsgiModule(boolean osgiModule) {
        this._osgiModule = osgiModule;
    }

    public void setReleaseInfoVersion(Object releaseInfoVersion) {
        this._releaseInfoVersion = releaseInfoVersion;
    }

    public void setUpgradeTableDir(Object upgradeTableDir) {
        this._upgradeTableDir = upgradeTableDir;
    }

    private List<String> _getCompleteArgs() {
        ArrayList<String> args = new ArrayList<String>(this.getArgs());
        args.add("upgrade.base.dir=" + FileUtil.getAbsolutePath((File)this.getBaseDir()));
        args.add("upgrade.osgi.module=" + this.isOsgiModule());
        String releaseInfoVersion = this.getReleaseInfoVersion();
        if (releaseInfoVersion != null) {
            args.add("upgrade.release.info.version=" + releaseInfoVersion);
        }
        args.add("upgrade.table.dir=" + FileUtil.getAbsolutePath((File)this.getUpgradeTableDir()));
        return args;
    }
}

