/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.upgrade.table.builder;

import com.liferay.gradle.plugins.upgrade.table.builder.BuildUpgradeTableTask;
import com.liferay.gradle.util.GradleUtil;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskContainer;

public class UpgradeTableBuilderPlugin
implements Plugin<Project> {
    public static final String BUILD_UPGRADE_TABLE_TASK_NAME = "buildUpgradeTable";
    public static final String CONFIGURATION_NAME = "upgradeTableBuilder";

    public void apply(Project project) {
        Configuration upgradeTableBuilderConfiguration = this.addConfigurationUpgradeTableBuilder(project);
        this.addTaskBuildUpgradeTable(project);
        this.configureTasksBuildUpgradeTable(project, upgradeTableBuilderConfiguration);
    }

    protected Configuration addConfigurationUpgradeTableBuilder(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CONFIGURATION_NAME);
        configuration.setDescription("Configures Liferay Upgrade Table Builder for this project.");
        configuration.setVisible(false);
        GradleUtil.executeIfEmpty((Configuration)configuration, (Action)new Action<Configuration>(){

            public void execute(Configuration configuration) {
                UpgradeTableBuilderPlugin.this.addUpgradeTableBuilderDependencies(project);
            }
        });
        return configuration;
    }

    protected BuildUpgradeTableTask addTaskBuildUpgradeTable(Project project) {
        BuildUpgradeTableTask buildUpgradeTableTask = (BuildUpgradeTableTask)GradleUtil.addTask((Project)project, (String)BUILD_UPGRADE_TABLE_TASK_NAME, BuildUpgradeTableTask.class);
        buildUpgradeTableTask.setBaseDir(project.getProjectDir());
        buildUpgradeTableTask.setDescription("Runs Liferay Upgrade Table Builder to build upgrade tables.");
        buildUpgradeTableTask.setGroup("build");
        return buildUpgradeTableTask;
    }

    protected void addUpgradeTableBuilderDependencies(Project project) {
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.portal.tools.upgrade.table.builder", (String)"latest.release");
    }

    protected void configureTaskBuildUpgradeTableClasspath(BuildUpgradeTableTask buildUpgradeTableTask, FileCollection fileCollection) {
        buildUpgradeTableTask.setClasspath(fileCollection);
    }

    protected void configureTasksBuildUpgradeTable(Project project, final Configuration upgradeTableBuilderConfiguration) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildUpgradeTableTask.class, (Action)new Action<BuildUpgradeTableTask>(){

            public void execute(BuildUpgradeTableTask buildUpgradeTableTask) {
                UpgradeTableBuilderPlugin.this.configureTaskBuildUpgradeTableClasspath(buildUpgradeTableTask, (FileCollection)upgradeTableBuilderConfiguration);
            }
        });
    }
}

