/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.tlddoc.builder.task;

import com.liferay.gradle.util.FileUtil;
import com.liferay.gradle.util.GradleUtil;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

@CacheableTask
public class TLDDocTask
extends JavaExec
implements PatternFilterable {
    private Object _destinationDir;
    private final PatternFilterable _patternFilterable = new PatternSet();
    private final List<Object> _source = new ArrayList<Object>();
    private Object _xsltDir;

    public TLDDocTask() {
        this.setMain("com.sun.tlddoc.TLDDoc");
        this.setMaxHeapSize("256m");
    }

    public TLDDocTask exclude(Closure excludeSpec) {
        this._patternFilterable.exclude(excludeSpec);
        return this;
    }

    public TLDDocTask exclude(Iterable<String> excludes) {
        this._patternFilterable.exclude(excludes);
        return this;
    }

    public TLDDocTask exclude(Spec<FileTreeElement> excludeSpec) {
        this._patternFilterable.exclude(excludeSpec);
        return this;
    }

    public TLDDocTask exclude(String ... excludes) {
        this._patternFilterable.exclude(excludes);
        return this;
    }

    public void exec() {
        this.setArgs(this._getCompleteArgs());
        super.exec();
    }

    @OutputDirectory
    public File getDestinationDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._destinationDir);
    }

    public Set<String> getExcludes() {
        return this._patternFilterable.getExcludes();
    }

    public Set<String> getIncludes() {
        return this._patternFilterable.getIncludes();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @SkipWhenEmpty
    public FileTree getSource() {
        Project project = this.getProject();
        ConfigurableFileCollection fileCollection = project.files(new Object[]{this._source});
        FileTree fileTree = fileCollection.getAsFileTree();
        return fileTree.matching(this._patternFilterable);
    }

    @InputDirectory
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getXsltDir() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._xsltDir);
    }

    public TLDDocTask include(Closure includeSpec) {
        this._patternFilterable.include(includeSpec);
        return this;
    }

    public TLDDocTask include(Iterable<String> includes) {
        this._patternFilterable.include(includes);
        return this;
    }

    public TLDDocTask include(Spec<FileTreeElement> includeSpec) {
        this._patternFilterable.include(includeSpec);
        return this;
    }

    public TLDDocTask include(String ... includes) {
        this._patternFilterable.include(includes);
        return this;
    }

    public void setDestinationDir(Object destinationDir) {
        this._destinationDir = destinationDir;
    }

    public TLDDocTask setExcludes(Iterable<String> excludes) {
        this._patternFilterable.setExcludes(excludes);
        return this;
    }

    public TLDDocTask setIncludes(Iterable<String> includes) {
        this._patternFilterable.setIncludes(includes);
        return this;
    }

    public void setSource(Object source) {
        this._source.clear();
        this._source.add(source);
    }

    public void setXsltDir(Object xsltDir) {
        this._xsltDir = xsltDir;
    }

    public TLDDocTask source(Object ... sources) {
        for (Object source : sources) {
            this._source.add(source);
        }
        return this;
    }

    private List<String> _getCompleteArgs() {
        ArrayList<String> args = new ArrayList<String>(this.getArgs());
        args.add("-d");
        args.add(FileUtil.relativize((File)this.getDestinationDir(), (File)this.getWorkingDir()));
        File xsltDir = this.getXsltDir();
        if (xsltDir != null) {
            args.add("-xslt");
            args.add(FileUtil.relativize((File)xsltDir, (File)this.getWorkingDir()));
        }
        for (File file : this.getSource()) {
            args.add(FileUtil.relativize((File)file, (File)this.getWorkingDir()));
        }
        return args;
    }
}

