/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.tlddoc.builder;

import com.liferay.gradle.plugins.tlddoc.builder.tasks.TLDDocTask;
import com.liferay.gradle.plugins.tlddoc.builder.tasks.ValidateSchemaTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;

public class TLDDocBuilderPlugin
implements Plugin<Project> {
    public static final String CONFIGURATION_NAME = "tlddoc";
    public static final String COPY_TLDDOC_RESOURCES_TASK_NAME = "copyTLDDocResources";
    public static final String TLDDOC_TASK_NAME = "tlddoc";
    public static final String VALIDATE_TLD_TASK_NAME = "validateTLD";

    public void apply(Project project) {
        Configuration tlddocConfiguration = this.addConfigurationTLDDoc(project);
        ValidateSchemaTask validateTLDTask = this.addTaskValidateTLD(project);
        Copy copyTLDDocResourcesTask = this.addTaskCopyTLDDocResources(project);
        this.addTaskTLDDoc(project, copyTLDDocResourcesTask, validateTLDTask);
        this.configureTasksTLDDoc(project, tlddocConfiguration);
    }

    protected Configuration addConfigurationTLDDoc(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)"tlddoc");
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                TLDDocBuilderPlugin.this.addDependenciesTLDDoc(project);
            }
        });
        configuration.setDescription("Configures Tag Library Documentation Generator for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    protected void addDependenciesTLDDoc(Project project) {
        GradleUtil.addDependency((Project)project, (String)"tlddoc", (String)"taglibrarydoc", (String)"tlddoc", (String)"1.3");
    }

    protected Copy addTaskCopyTLDDocResources(final Project project) {
        Copy copy = (Copy)GradleUtil.addTask((Project)project, (String)COPY_TLDDOC_RESOURCES_TASK_NAME, Copy.class);
        copy.from(new Object[]{"src/main/tlddoc"});
        copy.into((Object)new Callable<File>(){

            @Override
            public File call() throws Exception {
                TLDDocTask tlddocTask = (TLDDocTask)GradleUtil.getTask((Project)project, (String)"tlddoc");
                return tlddocTask.getDestinationDir();
            }
        });
        copy.setDescription("Copies Tag Library documentation resources.");
        return copy;
    }

    protected TLDDocTask addTaskTLDDoc(Project project, Copy copyTLDDocResourcesTask, ValidateSchemaTask validateTLDTask) {
        final TLDDocTask tlddocTask = (TLDDocTask)GradleUtil.addTask((Project)project, (String)"tlddoc", TLDDocTask.class);
        tlddocTask.dependsOn(new Object[]{copyTLDDocResourcesTask, validateTLDTask});
        tlddocTask.setDescription("Generates Tag Library documentation.");
        tlddocTask.setGroup("documentation");
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                TLDDocBuilderPlugin.this.configureTaskTLDDocForJavaPlugin(tlddocTask);
            }
        });
        return tlddocTask;
    }

    protected ValidateSchemaTask addTaskValidateTLD(Project project) {
        final ValidateSchemaTask validateSchemaTask = (ValidateSchemaTask)GradleUtil.addTask((Project)project, (String)VALIDATE_TLD_TASK_NAME, ValidateSchemaTask.class);
        validateSchemaTask.setDescription("Validates TLD files.");
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                TLDDocBuilderPlugin.this.configureTaskValidateSchemaForJavaPlugin(validateSchemaTask);
            }
        });
        return validateSchemaTask;
    }

    protected void configureTasksTLDDoc(Project project, final Configuration tlddocConfiguration) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(TLDDocTask.class, (Action)new Action<TLDDocTask>(){

            public void execute(TLDDocTask tlddocTask) {
                TLDDocBuilderPlugin.this.configureTaskTLDDocClasspath(tlddocTask, (FileCollection)tlddocConfiguration);
            }
        });
    }

    protected void configureTaskTLDDocClasspath(TLDDocTask tlddocTask, FileCollection fileCollection) {
        tlddocTask.setClasspath(fileCollection);
    }

    protected void configureTaskTLDDocForJavaPlugin(TLDDocTask tlddocTask) {
        final Project project = tlddocTask.getProject();
        tlddocTask.setDestinationDir(new Callable<File>(){

            @Override
            public File call() throws Exception {
                JavaPluginConvention javaPluginConvention = (JavaPluginConvention)GradleUtil.getConvention((Project)project, JavaPluginConvention.class);
                return new File(javaPluginConvention.getDocsDir(), "tlddoc");
            }
        });
        tlddocTask.setIncludes(Collections.singleton("**/*.tld"));
        tlddocTask.setSource(new Callable<Iterable<File>>(){

            @Override
            public Iterable<File> call() throws Exception {
                return TLDDocBuilderPlugin.this.getResourceDirs(project);
            }
        });
    }

    protected void configureTaskValidateSchemaForJavaPlugin(ValidateSchemaTask validateSchemaTask) {
        final Project project = validateSchemaTask.getProject();
        validateSchemaTask.setIncludes(Collections.singleton("**/*.tld"));
        validateSchemaTask.setSource(new Callable<Iterable<File>>(){

            @Override
            public Iterable<File> call() throws Exception {
                return TLDDocBuilderPlugin.this.getResourceDirs(project);
            }
        });
    }

    protected Iterable<File> getResourceDirs(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        SourceDirectorySet sourceDirectorySet = sourceSet.getResources();
        return sourceDirectorySet.getSrcDirs();
    }
}

