/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.tld.formatter;

import com.liferay.gradle.plugins.tld.formatter.FormatTLDTask;
import com.liferay.gradle.util.GradleUtil;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskContainer;

public class TLDFormatterPlugin
implements Plugin<Project> {
    public static final String CONFIGURATION_NAME = "tldFormatter";
    public static final String FORMAT_TLD_TASK_NAME = "formatTLD";

    public void apply(Project project) {
        Configuration tldFormatterConfiguration = this.addConfigurationTLDFormatter(project);
        this.addTaskFormatTLD(project);
        this.configureTasksFormatTLD(project, tldFormatterConfiguration);
    }

    protected Configuration addConfigurationTLDFormatter(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CONFIGURATION_NAME);
        configuration.setDescription("Configures Liferay TLD Formatter for this project.");
        configuration.setVisible(false);
        GradleUtil.executeIfEmpty((Configuration)configuration, (Action)new Action<Configuration>(){

            public void execute(Configuration configuration) {
                TLDFormatterPlugin.this.addDependenciesTLDFormatter(project);
            }
        });
        return configuration;
    }

    protected void addDependenciesTLDFormatter(Project project) {
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"com.liferay", (String)"com.liferay.tld.formatter", (String)"latest.release");
    }

    protected FormatTLDTask addTaskFormatTLD(Project project) {
        FormatTLDTask formatTLDTask = (FormatTLDTask)GradleUtil.addTask((Project)project, (String)FORMAT_TLD_TASK_NAME, FormatTLDTask.class);
        formatTLDTask.setDescription("Runs Liferay TLD Formatter to format files.");
        return formatTLDTask;
    }

    protected void configureTaskFormatTLDClasspath(FormatTLDTask formatTLDTask, FileCollection fileCollection) {
        formatTLDTask.setClasspath(fileCollection);
    }

    protected void configureTasksFormatTLD(Project project, final Configuration tldFormatterConfiguration) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(FormatTLDTask.class, (Action)new Action<FormatTLDTask>(){

            public void execute(FormatTLDTask formatTLDTask) {
                TLDFormatterPlugin.this.configureTaskFormatTLDClasspath(formatTLDTask, (FileCollection)tldFormatterConfiguration);
            }
        });
    }
}

