/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.target.platform.task;

import com.liferay.gradle.plugins.target.platform.internal.util.GradleUtil;
import groovy.util.XmlSlurper;
import groovy.util.slurpersupport.GPathResult;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;

public class DependencyManagementTask
extends DefaultTask {
    private String _outputFile;

    @Optional
    @OutputFile
    public File getOutputFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._outputFile);
    }

    @TaskAction
    public void report() {
        List<String> dependencies = this._getTargetPlatformDependencies(this.getProject());
        if (dependencies != null && !dependencies.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String dependency : dependencies) {
                sb.append("\t");
                sb.append(dependency);
                sb.append(System.lineSeparator());
            }
            String output = sb.toString();
            File outputFile = this.getOutputFile();
            if (outputFile != null) {
                try {
                    Files.write(outputFile.toPath(), output.getBytes(), new OpenOption[0]);
                }
                catch (IOException ioException) {
                    throw new GradleException("Unable to write dependencies to file", (Throwable)ioException);
                }
            } else {
                Logger logger = this.getLogger();
                if (logger.isLifecycleEnabled()) {
                    logger.lifecycle(output);
                }
            }
        } else {
            Logger logger = this.getLogger();
            if (logger.isLifecycleEnabled()) {
                logger.lifecycle("No dependencies found");
            }
        }
    }

    @Option(description="Set the output file.", option="output-file")
    public void setOutputFile(String outputFile) {
        this._outputFile = outputFile;
    }

    private List<String> _getTargetPlatformDependencies(final Project project) {
        final ArrayList<String> dependencies = new ArrayList<String>();
        final Configuration configuration = GradleUtil.getConfiguration((Project)project, (String)"targetPlatformIDEBoms");
        DependencySet dependencySet = configuration.getDependencies();
        dependencySet.all((Action)new Action<Dependency>(){

            public void execute(Dependency dependency) {
                if (configuration.isCanBeResolved()) {
                    Set files = configuration.files(new Dependency[]{dependency});
                    for (File file : files) {
                        dependencies.addAll(DependencyManagementTask.this._getTargetPlatformDependencies(project, file));
                    }
                }
            }
        });
        Collections.sort(dependencies, new Comparator<String>(){

            @Override
            public int compare(String entry1, String entry2) {
                String[] components2;
                String[] components1 = entry1.split(":");
                int result = components1[0].compareTo((components2 = entry2.split(":"))[0]);
                if (result == 0) {
                    result = components1[1].compareTo(components2[1]);
                }
                return result;
            }
        });
        return dependencies;
    }

    private List<String> _getTargetPlatformDependencies(Project project, File file) {
        try {
            ArrayList<String> dependencies = new ArrayList<String>();
            XmlSlurper xmlSlurper = new XmlSlurper();
            GPathResult gPathResult2 = xmlSlurper.parse(file);
            gPathResult2 = (GPathResult)gPathResult2.getProperty("dependencyManagement");
            gPathResult2 = (GPathResult)gPathResult2.getProperty("dependencies");
            gPathResult2 = (GPathResult)gPathResult2.getProperty("dependency");
            for (GPathResult gPathResult2 : gPathResult2) {
                String artifactId = String.valueOf(gPathResult2.getProperty("artifactId"));
                String groupId = String.valueOf(gPathResult2.getProperty("groupId"));
                String version = String.valueOf(gPathResult2.getProperty("version"));
                dependencies.add(groupId + ':' + artifactId + ':' + version);
            }
            return dependencies;
        }
        catch (Exception exception) {
            Logger logger = project.getLogger();
            if (logger.isWarnEnabled()) {
                logger.warn("Unable to parse BOM from {}", (Object)file);
            }
            return Collections.emptyList();
        }
    }
}

