/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.target.platform.internal.util;

import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.dsl.DependencyHandler;

public class TargetPlatformPluginUtil {
    public static void configureTargetPlatform(Project project, final List<String> configurationNames, final Configuration targetPlatformBomsConfiguration) {
        ConfigurationContainer configurationContainer = project.getConfigurations();
        final DependencyHandler dependencyHandler = project.getDependencies();
        configurationContainer.all((Action)new Action<Configuration>(){

            public void execute(final Configuration configuration) {
                String name = configuration.getName();
                if (!configurationNames.contains(name)) {
                    return;
                }
                if (name.equals("frontendCSSCommon") || name.equals("originalModule") || name.equals("parentThemes") || name.equals("portalCommonCSS") || name.equals("providedModules")) {
                    configuration.setTransitive(true);
                }
                DependencySet dependencySet = targetPlatformBomsConfiguration.getDependencies();
                dependencySet.all((Action)new Action<Dependency>(){

                    public void execute(Dependency dependency) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(dependency.getGroup());
                        sb.append(':');
                        sb.append(dependency.getName());
                        sb.append(':');
                        sb.append(dependency.getVersion());
                        Dependency platformDependency = dependencyHandler.platform((Object)sb.toString());
                        dependencyHandler.add(configuration.getName(), (Object)platformDependency);
                    }
                });
            }
        });
    }
}

