/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.target.platform.extensions;

import com.liferay.gradle.plugins.target.platform.internal.util.GradleUtil;
import com.liferay.gradle.plugins.target.platform.internal.util.TargetPlatformPluginUtil;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.PluginManager;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.util.GUtil;

public class TargetPlatformExtension {
    private AndSpec<Project> _onlyIfSpec = new AndSpec();
    private final Project _project;
    private AndSpec<Project> _resolveOnlyIfSpec = new AndSpec();
    private final Set<Project> _subprojects = new LinkedHashSet<Project>();

    public TargetPlatformExtension(Project project) {
        this._project = project;
        this._subprojects.addAll(project.getSubprojects());
        final Logger logger = project.getLogger();
        this.onlyIf(new Spec<Project>(){

            public boolean isSatisfiedBy(Project project) {
                TaskContainer taskContainer = project.getTasks();
                Task jarTask = (Task)taskContainer.findByName("jar");
                if (!(jarTask instanceof Jar)) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Excluding {} because it is not a valid Java project", (Object)project);
                    }
                    return false;
                }
                return true;
            }
        });
        this.resolveOnlyIf(new Spec<Project>(){

            public boolean isSatisfiedBy(Project project) {
                Project rootProject = project.getRootProject();
                File bndrunFile = rootProject.file((Object)"platform.bndrun");
                if (!bndrunFile.exists()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Explicitly excluding ");
                    sb.append(project);
                    sb.append(" from resolution because there is no ");
                    sb.append("platform.bndrun");
                    sb.append(" file at the root of the gradle workspace");
                    if (logger.isInfoEnabled()) {
                        logger.info(sb.toString());
                    }
                    return false;
                }
                return true;
            }
        });
        this.resolveOnlyIf(new Spec<Project>(){

            public boolean isSatisfiedBy(Project project) {
                PluginManager pluginManager = project.getPluginManager();
                if (!pluginManager.hasPlugin("com.liferay.osgi.plugin")) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Explicitly excluding {} from resolution because it does not appear to be an OSGi bundle", (Object)project);
                    }
                    return false;
                }
                return true;
            }
        });
    }

    public TargetPlatformExtension applyToConfiguration(Iterable<?> configurationNames) {
        Configuration targetPlatformBomsConfiguration = GradleUtil.getConfiguration((Project)this._project, (String)"targetPlatformBoms");
        ArrayList<String> configurationNamesList = new ArrayList<String>();
        for (Object obj : configurationNames) {
            if (!(obj instanceof String)) continue;
            configurationNamesList.add((String)obj);
        }
        TargetPlatformPluginUtil.configureTargetPlatform(this._project, configurationNamesList, targetPlatformBomsConfiguration);
        return this;
    }

    public TargetPlatformExtension applyToConfiguration(Object ... configurationNames) {
        return this.applyToConfiguration(Arrays.asList(configurationNames));
    }

    public Spec<Project> getOnlyIf() {
        return this._onlyIfSpec;
    }

    public Spec<Project> getResolveOnlyIf() {
        return this._resolveOnlyIfSpec;
    }

    public Set<Project> getSubprojects() {
        return this._subprojects;
    }

    public TargetPlatformExtension onlyIf(Closure<Boolean> onlyIfClosure) {
        this._onlyIfSpec = this._onlyIfSpec.and(onlyIfClosure);
        return this;
    }

    public TargetPlatformExtension onlyIf(Spec<Project> onlyIfSpec) {
        this._onlyIfSpec = this._onlyIfSpec.and(onlyIfSpec);
        return this;
    }

    public TargetPlatformExtension resolveOnlyIf(Closure<Boolean> resolveOnlyIfClosure) {
        this._resolveOnlyIfSpec = this._resolveOnlyIfSpec.and(resolveOnlyIfClosure);
        return this;
    }

    public TargetPlatformExtension resolveOnlyIf(Spec<Project> resolveOnlyIfSpec) {
        this._resolveOnlyIfSpec = this._resolveOnlyIfSpec.and(resolveOnlyIfSpec);
        return this;
    }

    public void setOnlyIf(Closure<Boolean> onlyIfClosure) {
        this._onlyIfSpec = new AndSpec();
        this._onlyIfSpec.and(onlyIfClosure);
    }

    public void setOnlyIf(Spec<Project> onlyIfSpec) {
        this._onlyIfSpec = new AndSpec(new Spec[]{onlyIfSpec});
    }

    public void setResolveOnlyIf(Closure<Boolean> resolveOnlyIfClosure) {
        this._resolveOnlyIfSpec = new AndSpec();
        this._resolveOnlyIfSpec.and(resolveOnlyIfClosure);
    }

    public void setResolveOnlyIf(Spec<Project> resolveOnlyIfSpec) {
        this._resolveOnlyIfSpec = new AndSpec(new Spec[]{resolveOnlyIfSpec});
    }

    public void setSubprojects(Iterable<Project> subprojects) {
        this._subprojects.clear();
        this.subprojects(subprojects);
    }

    public void setSubprojects(Project ... subprojects) {
        this.setSubprojects(Arrays.asList(subprojects));
    }

    public TargetPlatformExtension subprojects(Iterable<Project> subprojects) {
        GUtil.addToCollection(this._subprojects, (Iterable[])new Iterable[]{subprojects});
        return this;
    }

    public TargetPlatformExtension subprojects(Project ... subprojects) {
        return this.subprojects(Arrays.asList(subprojects));
    }
}

