/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.target.platform.tasks;

import aQute.bnd.build.Workspace;
import aQute.bnd.repository.fileset.FileSetRepository;
import aQute.bnd.service.RepositoryPlugin;
import aQute.service.reporter.Report;
import aQute.service.reporter.Reporter;
import biz.aQute.resolve.Bndrun;
import biz.aQute.resolve.ResolveProcess;
import com.liferay.gradle.plugins.target.platform.internal.util.GradleUtil;
import com.liferay.gradle.util.FileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.gradle.StartParameter;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.osgi.service.resolver.ResolutionException;

public class ResolveTask
extends DefaultTask {
    private Object _bndrunFile;
    private FileCollection _bundlesFileCollection;
    private FileCollection _distroFileCollection;
    private Object _ignoreFailures;
    private Object _offline;
    private FileCollection _requirementsFileCollection;

    public ResolveTask() {
        Project project = this.getProject();
        Gradle gradle = project.getGradle();
        StartParameter startParameter = gradle.getStartParameter();
        this._offline = startParameter.isOffline();
    }

    @InputFile
    @Optional
    public File getBndrunFile() {
        return GradleUtil.toFile((Project)this.getProject(), (Object)this._bndrunFile);
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getBundles() {
        return this._bundlesFileCollection;
    }

    public FileCollection getDistro() {
        return this._distroFileCollection;
    }

    @InputFile
    public File getDistroFile() {
        return this._distroFileCollection.getSingleFile();
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getRequirements() {
        return this._requirementsFileCollection;
    }

    @Input
    public boolean isIgnoreFailures() {
        return GradleUtil.toBoolean(this._ignoreFailures);
    }

    public boolean isOffline() {
        return GradleUtil.toBoolean(this._offline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void resolve() throws IOException {
        Logger logger = this.getLogger();
        Project project = this.getProject();
        File bndrunFile = this.getBndrunFile();
        if (bndrunFile == null) {
            bndrunFile = this._writeTemporaryBndrunFile();
        }
        File temporaryDir = this.getTemporaryDir();
        File cnfDir = new File(temporaryDir, "cnf");
        project.mkdir((Object)cnfDir);
        try (Bndrun bndrun = Bndrun.createBndrun(null, (File)bndrunFile);){
            block28: {
                bndrun.setBase(temporaryDir);
                Workspace workspace = bndrun.getWorkspace();
                workspace.setBuildDir(cnfDir);
                workspace.setOffline(this.isOffline());
                FileCollection bundlesFileCollection = this.getBundles();
                if (logger.isInfoEnabled()) {
                    logger.info("Bundles available for resolving: {}", (Object)bundlesFileCollection.getAsPath());
                }
                FileSetRepository fileSetRepository = new FileSetRepository(this.getName(), (Collection)bundlesFileCollection.getFiles());
                workspace.addBasicPlugin((Object)fileSetRepository);
                if (logger.isInfoEnabled()) {
                    logger.info("Resolving runbundles required for {}", (Object)bndrun.getPropertiesFile());
                }
                for (RepositoryPlugin repositoryPlugin : workspace.getRepositories()) {
                    repositoryPlugin.list(null);
                }
                bndrun.getInfo((Reporter)workspace);
                this._logReport((Report)bndrun);
                if (!bndrun.isOk()) {
                    throw new GradleException("Standalone workspace errors in " + bndrunFile);
                }
                try {
                    String result = bndrun.resolve(false, true);
                    if (logger.isInfoEnabled()) {
                        logger.info("{}: {}", (Object)"-runbundles", (Object)result);
                    }
                }
                catch (ResolutionException re) {
                    String message = "Unresolved requirements in " + project + ": " + ResolveProcess.format((Collection)re.getUnresolvedRequirements());
                    if (this.isIgnoreFailures()) {
                        logger.error(message);
                        break block28;
                    }
                    throw new GradleException(message, (Throwable)re);
                }
                finally {
                    this._logReport((Report)bndrun);
                }
            }
            if (!bndrun.isOk() && !this.isIgnoreFailures()) {
                throw new GradleException("Resolution failure in " + project);
            }
        }
        catch (Exception e) {
            String message = "Resolution exception in " + project + ": " + e.getMessage();
            if (this.isIgnoreFailures()) {
                logger.error(message);
            }
            throw new GradleException(message, (Throwable)e);
        }
    }

    public void setBndrunFile(Object bndrunFile) {
        this._bndrunFile = bndrunFile;
    }

    public void setBundles(FileCollection bundlesFileCollection) {
        this._bundlesFileCollection = bundlesFileCollection;
    }

    public void setDistro(FileCollection distroFileCollection) {
        this._distroFileCollection = distroFileCollection;
    }

    public void setIgnoreFailures(Object ignoreFailures) {
        this._ignoreFailures = ignoreFailures;
    }

    public void setOffline(Object offline) {
        this._offline = offline;
    }

    public void setRequirements(FileCollection requirementsFileCollection) {
        this._requirementsFileCollection = requirementsFileCollection;
    }

    private String _getManifestValue(File file, String name) throws IOException {
        try (JarFile jarFile = new JarFile(file);){
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String string = attributes.getValue(name);
            return string;
        }
    }

    private void _logReport(Report report) {
        Report.Location location;
        Logger logger = this.getLogger();
        if (logger.isWarnEnabled()) {
            for (String warning : report.getWarnings()) {
                location = report.getLocation(warning);
                if (location != null && location.file != null) {
                    logger.warn("{}:{}: warning: {}", new Object[]{location.file, location.line, warning});
                    continue;
                }
                logger.warn("Warning: {}", (Object)warning);
            }
        }
        if (logger.isErrorEnabled()) {
            for (String error : report.getErrors()) {
                location = report.getLocation(error);
                if (location != null && location.file != null) {
                    logger.error("{}:{}: error: {}", new Object[]{location.file, location.line, error});
                    continue;
                }
                logger.error("Error: {}", (Object)error);
            }
        }
    }

    private File _writeTemporaryBndrunFile() throws IOException {
        File bndrunFile = new File(this.getTemporaryDir(), "resolve.bndrun");
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(bndrunFile.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            bufferedWriter.write("-distro: \"");
            bufferedWriter.write(FileUtil.getAbsolutePath((File)this.getDistroFile()));
            bufferedWriter.write("\";version=file");
            bufferedWriter.newLine();
            bufferedWriter.write("-resolve.effective: active, resolve");
            bufferedWriter.newLine();
            bufferedWriter.write("-resourceonly: true");
            bufferedWriter.newLine();
            bufferedWriter.write("-runrequires:\\");
            bufferedWriter.newLine();
            boolean first = true;
            for (File requirementFile : this.getRequirements()) {
                String bundleSymbolicName = this._getManifestValue(requirementFile, "Bundle-SymbolicName");
                if (bundleSymbolicName == null) continue;
                if (!first) {
                    bufferedWriter.write(",\\");
                    bufferedWriter.newLine();
                } else {
                    first = false;
                }
                bufferedWriter.write("\tosgi.identity;filter:='(osgi.identity=");
                bufferedWriter.write(bundleSymbolicName);
                bufferedWriter.write(")'");
            }
            bufferedWriter.newLine();
            bufferedWriter.write("-standalone:");
        }
        return bndrunFile;
    }
}

