/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.target.platform;

import com.liferay.gradle.plugins.target.platform.TargetPlatformPlugin;
import com.liferay.gradle.plugins.target.platform.extensions.TargetPlatformIDEExtension;
import com.liferay.gradle.plugins.target.platform.internal.util.GradleUtil;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import io.spring.gradle.dependencymanagement.dsl.DependencyManagementConfigurer;
import io.spring.gradle.dependencymanagement.dsl.DependencyManagementExtension;
import io.spring.gradle.dependencymanagement.dsl.ImportsHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.internal.GeneratedIdeaScope;

public class TargetPlatformIDEPlugin
implements Plugin<Project> {
    public static final String PLUGIN_NAME = "targetPlatformIDE";
    public static final String TARGET_PLATFORM_IDE_CONFIGURATION_NAME = "targetPlatformIDE";

    public void apply(Project project) {
        GradleUtil.applyPlugin((Project)project, EclipsePlugin.class);
        GradleUtil.applyPlugin((Project)project, IdeaPlugin.class);
        GradleUtil.applyPlugin((Project)project, JavaPlugin.class);
        GradleUtil.applyPlugin((Project)project, TargetPlatformPlugin.class);
        DependencyManagementExtension dependencyManagementExtension = (DependencyManagementExtension)GradleUtil.getExtension((ExtensionAware)project, DependencyManagementExtension.class);
        TargetPlatformIDEExtension targetPlatformIDEExtension = (TargetPlatformIDEExtension)GradleUtil.addExtension((ExtensionAware)project, (String)"targetPlatformIDE", TargetPlatformIDEExtension.class);
        Configuration targetPlatformIDEConfiguration = this._addConfigurationTargetPlatformIDE(project, dependencyManagementExtension, targetPlatformIDEExtension);
        this._configureEclipseModel(project, targetPlatformIDEConfiguration);
        this._configureIdeaModel(project, targetPlatformIDEConfiguration);
    }

    private Configuration _addConfigurationTargetPlatformIDE(final Project project, final DependencyManagementExtension dependencyManagementExtension, final TargetPlatformIDEExtension targetPlatformIDEExtension) {
        final Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)"targetPlatformIDE");
        final Configuration bomConfiguration = GradleUtil.getConfiguration((Project)project, (String)"targetPlatformBoms");
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                TargetPlatformIDEPlugin.this._addDependenciesTargetPlatformIDE(project, dependencyManagementExtension, targetPlatformIDEExtension, configuration, bomConfiguration);
            }
        });
        configuration.setDescription("Configures all the managed dependencies for the configured Liferay target platform.");
        configuration.setVisible(false);
        return configuration;
    }

    private void _addDependenciesTargetPlatformIDE(Project project, DependencyManagementExtension dependencyManagementExtension, TargetPlatformIDEExtension targetPlatformIDEExtension, Configuration configuration, final Configuration bomConfiguration) {
        GroovyObjectSupport groovyObjectSupport = (GroovyObjectSupport)dependencyManagementExtension;
        Object[] args = new Object[]{configuration, new Closure<Void>((Object)project){

            public void doCall() {
                DependencySet dependencySet = bomConfiguration.getAllDependencies();
                final DependencyManagementConfigurer dependencyManagementConfigurer = (DependencyManagementConfigurer)this.getDelegate();
                dependencySet.all((Action)new Action<Dependency>(){

                    public void execute(Dependency dependency) {
                        TargetPlatformIDEPlugin.this._configureDependencyManagementImportsHandler(dependencyManagementConfigurer, dependency);
                    }
                });
            }
        }};
        groovyObjectSupport.invokeMethod("configurations", (Object)args);
        Map managedVersions = dependencyManagementExtension.getManagedVersionsForConfiguration(configuration);
        if (managedVersions.isEmpty()) {
            return;
        }
        HashSet<String> includeGroups = new HashSet<String>();
        for (Object object : targetPlatformIDEExtension.getIncludeGroups()) {
            includeGroups.add(GradleUtil.toString(object));
        }
        LinkedHashSet<String> dependencyNotations = new LinkedHashSet<String>();
        for (Map.Entry entry : managedVersions.entrySet()) {
            String key = (String)entry.getKey();
            String group = key.substring(0, key.indexOf(58));
            if (!includeGroups.contains(group)) continue;
            dependencyNotations.add(key + ":" + (String)entry.getValue());
        }
        for (String dependencyNotation : dependencyNotations) {
            GradleUtil.addDependency((Project)project, (String)"targetPlatformIDE", (String)dependencyNotation);
        }
    }

    private void _configureDependencyManagementImportsHandler(DependencyManagementConfigurer dependencyManagementConfigurer, final Dependency dependency) {
        dependencyManagementConfigurer.imports((Action)new Action<ImportsHandler>(){

            public void execute(ImportsHandler importsHandler) {
                StringBuilder sb = new StringBuilder();
                sb.append(dependency.getGroup());
                sb.append(':');
                sb.append(dependency.getName());
                sb.append(':');
                sb.append(dependency.getVersion());
                importsHandler.mavenBom(sb.toString());
            }
        });
    }

    private void _configureEclipseModel(Project project, Configuration targetPlatformIDEConfiguration) {
        EclipseModel eclipseModel = (EclipseModel)GradleUtil.getExtension((ExtensionAware)project, EclipseModel.class);
        EclipseClasspath eclipseClasspath = eclipseModel.getClasspath();
        eclipseClasspath.setDownloadJavadoc(false);
        Collection plusConfigurations = eclipseClasspath.getPlusConfigurations();
        plusConfigurations.add(targetPlatformIDEConfiguration);
    }

    private void _configureIdeaModel(Project project, Configuration targetPlatformIDEConfiguration) {
        ArrayList<Configuration> plus;
        IdeaModel ideaModel = (IdeaModel)GradleUtil.getExtension((ExtensionAware)project, IdeaModel.class);
        IdeaModule ideaModule = ideaModel.getModule();
        Map scopes = ideaModule.getScopes();
        HashMap<String, ArrayList<Configuration>> providedScope = (HashMap<String, ArrayList<Configuration>>)scopes.get(GeneratedIdeaScope.PROVIDED.name());
        if (providedScope == null) {
            providedScope = new HashMap<String, ArrayList<Configuration>>();
        }
        if ((plus = (ArrayList<Configuration>)providedScope.get("plus")) == null) {
            plus = new ArrayList<Configuration>();
        }
        plus.add(targetPlatformIDEConfiguration);
        providedScope.put("plus", plus);
        scopes.put(GeneratedIdeaScope.PROVIDED.name(), providedScope);
        ideaModule.setScopes(scopes);
        SourceSet mainSourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        FileCollection compileClasspath = mainSourceSet.getCompileClasspath();
        compileClasspath.plus((FileCollection)targetPlatformIDEConfiguration);
    }
}

