/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.target.platform.extensions;

import com.liferay.gradle.plugins.target.platform.internal.util.GradleUtil;
import com.liferay.gradle.plugins.target.platform.internal.util.TargetPlatformPluginUtil;
import groovy.lang.Closure;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.Spec;
import org.gradle.util.GUtil;

public class TargetPlatformExtension {
    private Object _ignoreResolveFailures;
    private AndSpec<Project> _onlyIfSpec = new AndSpec();
    private final Project _project;
    private AndSpec<Project> _resolveOnlyIfSpec = new AndSpec();
    private final Set<Project> _subprojects = new LinkedHashSet<Project>();

    public TargetPlatformExtension(Project project) {
        this._project = project;
        this._subprojects.addAll(project.getSubprojects());
    }

    public TargetPlatformExtension applyToConfiguration(Iterable<?> configurationNames) {
        Configuration targetPlatformBomsConfiguration = GradleUtil.getConfiguration((Project)this._project, (String)"targetPlatformBoms");
        TargetPlatformPluginUtil.configureDependencyManagement(this._project, targetPlatformBomsConfiguration, configurationNames);
        return this;
    }

    public TargetPlatformExtension applyToConfiguration(Object ... configurationNames) {
        return this.applyToConfiguration(Arrays.asList(configurationNames));
    }

    public Spec<Project> getOnlyIf() {
        return this._onlyIfSpec;
    }

    public Spec<Project> getResolveOnlyIf() {
        return this._resolveOnlyIfSpec;
    }

    public Set<Project> getSubprojects() {
        return this._subprojects;
    }

    public boolean isIgnoreResolveFailures() {
        return GradleUtil.toBoolean(this._ignoreResolveFailures);
    }

    public TargetPlatformExtension onlyIf(Closure<Boolean> onlyIfClosure) {
        this._onlyIfSpec = this._onlyIfSpec.and(onlyIfClosure);
        return this;
    }

    public TargetPlatformExtension onlyIf(Spec<Project> onlyIfSpec) {
        this._onlyIfSpec = this._onlyIfSpec.and(onlyIfSpec);
        return this;
    }

    public TargetPlatformExtension resolveOnlyIf(Closure<Boolean> resolveOnlyIfClosure) {
        this._resolveOnlyIfSpec = this._resolveOnlyIfSpec.and(resolveOnlyIfClosure);
        return this;
    }

    public TargetPlatformExtension resolveOnlyIf(Spec<Project> resolveOnlyIfSpec) {
        this._resolveOnlyIfSpec = this._resolveOnlyIfSpec.and(resolveOnlyIfSpec);
        return this;
    }

    public void setIgnoreResolveFailures(Object ignoreResolveFailures) {
        this._ignoreResolveFailures = ignoreResolveFailures;
    }

    public void setOnlyIf(Closure<Boolean> onlyIfClosure) {
        this._onlyIfSpec = new AndSpec();
        this._onlyIfSpec.and(onlyIfClosure);
    }

    public void setOnlyIf(Spec<Project> onlyIfSpec) {
        this._onlyIfSpec = new AndSpec(new Spec[]{onlyIfSpec});
    }

    public void setResolveOnlyIf(Closure<Boolean> resolveOnlyIfClosure) {
        this._resolveOnlyIfSpec = new AndSpec();
        this._resolveOnlyIfSpec.and(resolveOnlyIfClosure);
    }

    public void setResolveOnlyIf(Spec<Project> resolveOnlyIfSpec) {
        this._resolveOnlyIfSpec = new AndSpec(new Spec[]{resolveOnlyIfSpec});
    }

    public void setSubprojects(Iterable<Project> subprojects) {
        this._subprojects.clear();
        this.subprojects(subprojects);
    }

    public void setSubprojects(Project ... subprojects) {
        this.setSubprojects(Arrays.asList(subprojects));
    }

    public TargetPlatformExtension subprojects(Iterable<Project> subprojects) {
        GUtil.addToCollection(this._subprojects, (Iterable[])new Iterable[]{subprojects});
        return this;
    }

    public TargetPlatformExtension subprojects(Project ... subprojects) {
        return this.subprojects(Arrays.asList(subprojects));
    }
}

