/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.soy.tasks;

import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;

public class ReplaceSoyTranslationTask
extends SourceTask {
    private static final Pattern _pattern = Pattern.compile("var (MSG_EXTERNAL_\\d+) = goog\\.getMsg\\(\\s*'([\\w-\\{\\}\\$]+)'\\s*(?:,\\s*\\{([\\s\\S]+?)\\})?\\);");
    private Closure<String> _replacementClosure;

    @Input
    public Closure<String> getReplacementClosure() {
        return this._replacementClosure;
    }

    @TaskAction
    public void replaceSoyTranslation() throws IOException {
        for (File file : this.getSource()) {
            this._replaceSoyTranslation(file.toPath());
        }
    }

    public void setReplacementClosure(Closure<String> replacementClosure) {
        this._replacementClosure = replacementClosure;
    }

    private void _replaceSoyTranslation(Path path) throws IOException {
        String content = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        Matcher matcher = _pattern.matcher(content);
        StringBuffer sb = new StringBuffer();
        boolean found = false;
        while (matcher.find()) {
            found = true;
            String replacement = (String)this._replacementClosure.call(new Object[]{matcher.group(1), matcher.group(2), matcher.group(3)});
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        if (found) {
            content = sb.toString();
            Files.write(path, content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }
}

