/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.soy;

import com.liferay.gradle.plugins.soy.tasks.ReplaceSoyTranslationTask;
import com.liferay.gradle.util.GradleUtil;
import com.liferay.gradle.util.Validator;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;

public class SoyTranslationPlugin
implements Plugin<Project> {
    public static final String REPLACE_SOY_TRANSLATION_TASK_NAME = "replaceSoyTranslation";
    private static final String _CONFIG_JS_MODULES_TASK_NAME = "configJSModules";
    private static final String _JS_MODULE_CONFIG_GENERATOR_PLUGIN_ID = "com.liferay.js.module.config.generator";
    private static final String _JS_TRANSPILER_PLUGIN_ID = "com.liferay.js.transpiler";
    private static final String _TRANSPILE_JS_TASK_NAME = "transpileJS";

    public void apply(Project project) {
        this._addTaskReplaceSoyTranslation(project);
    }

    private ReplaceSoyTranslationTask _addTaskReplaceSoyTranslation(Project project) {
        final ReplaceSoyTranslationTask replaceSoyTranslationTask = (ReplaceSoyTranslationTask)GradleUtil.addTask((Project)project, (String)REPLACE_SOY_TRANSLATION_TASK_NAME, ReplaceSoyTranslationTask.class);
        replaceSoyTranslationTask.setDescription("Replaces 'goog.getMsg' definitions.");
        replaceSoyTranslationTask.setGroup("build");
        replaceSoyTranslationTask.setIncludes(Collections.singleton("**/*.soy.js"));
        replaceSoyTranslationTask.setReplacementClosure(new LiferayReplacementClosure((Object)replaceSoyTranslationTask));
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withId(_JS_MODULE_CONFIG_GENERATOR_PLUGIN_ID, (Action)new Action<Plugin>(){

            public void execute(Plugin plugin) {
                replaceSoyTranslationTask.dependsOn(new Object[]{SoyTranslationPlugin._CONFIG_JS_MODULES_TASK_NAME});
            }
        });
        pluginContainer.withId(_JS_TRANSPILER_PLUGIN_ID, (Action)new Action<Plugin>(){

            public void execute(Plugin plugin) {
                replaceSoyTranslationTask.dependsOn(new Object[]{SoyTranslationPlugin._TRANSPILE_JS_TASK_NAME});
            }
        });
        pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                SoyTranslationPlugin.this._configureTaskReplaceSoyTranslationForJavaPlugin(replaceSoyTranslationTask);
            }
        });
        return replaceSoyTranslationTask;
    }

    private void _configureTaskReplaceSoyTranslationForJavaPlugin(final ReplaceSoyTranslationTask replaceSoyTranslationTask) {
        replaceSoyTranslationTask.dependsOn(new Object[]{"processResources"});
        replaceSoyTranslationTask.setSource(new Callable<File>(){

            @Override
            public File call() throws Exception {
                SourceSet sourceSet = GradleUtil.getSourceSet((Project)replaceSoyTranslationTask.getProject(), (String)"main");
                SourceSetOutput sourceSetOutput = sourceSet.getOutput();
                return sourceSetOutput.getResourcesDir();
            }
        });
        Task classesTask = GradleUtil.getTask((Project)replaceSoyTranslationTask.getProject(), (String)"classes");
        classesTask.dependsOn(new Object[]{replaceSoyTranslationTask});
    }

    private static class LiferayReplacementClosure
    extends Closure<String> {
        private static final Pattern _argumentsObjectPattern = Pattern.compile("'.+'\\s*:\\s*([\\d\\w\\._]+)+");
        private static final Pattern _languageKeyPlaceholderPattern = Pattern.compile("\\{\\$\\w+\\}");

        public LiferayReplacementClosure(Object owner) {
            super(owner);
        }

        public String doCall(String variableName, String languageKey, String argumentsObject) {
            StringBuilder sb = new StringBuilder();
            sb.append("var ");
            sb.append(variableName);
            sb.append(" = Liferay.Language");
            sb.append(".get('");
            sb.append(this._fixLanguageKey(languageKey));
            sb.append("');");
            if (Validator.isNotNull((String)argumentsObject)) {
                this._appendArgumentReplaces(sb, argumentsObject, variableName);
            }
            return sb.toString();
        }

        private void _appendArgumentReplaces(StringBuilder sb, String argumentsObject, String variableName) {
            int i = 0;
            Matcher matcher = _argumentsObjectPattern.matcher(argumentsObject);
            while (matcher.find()) {
                sb.append(System.lineSeparator());
                sb.append(variableName);
                sb.append(" = ");
                sb.append(variableName);
                sb.append(".replace('{");
                sb.append(i);
                sb.append("}', ");
                sb.append(matcher.group(1));
                sb.append(");");
                ++i;
            }
        }

        private String _fixLanguageKey(String languageKey) {
            Matcher matcher = _languageKeyPlaceholderPattern.matcher(languageKey);
            return matcher.replaceAll("x");
        }
    }
}

