/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.gradle.plugins.soy;

import com.liferay.gradle.plugins.soy.BuildSoyTask;
import com.liferay.gradle.util.GradleUtil;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;

public class SoyPlugin
implements Plugin<Project> {
    public static final String BUILD_SOY_TASK_NAME = "buildSoy";
    public static final String CONFIGURATION_NAME = "soy";
    private static final String _VERSION = "2012-12-21";

    public void apply(Project project) {
        Configuration soyConfiguration = this.addConfigurationSoy(project);
        this.addTaskBuildSoy(project);
        this.configureTasksBuildSoy(project, soyConfiguration);
    }

    protected Configuration addConfigurationSoy(final Project project) {
        Configuration configuration = GradleUtil.addConfiguration((Project)project, (String)CONFIGURATION_NAME);
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencySet) {
                SoyPlugin.this.addDependenciesSoy(project);
            }
        });
        configuration.setDescription("Configures Closure Templates for this project.");
        configuration.setVisible(false);
        return configuration;
    }

    protected void addDependenciesSoy(Project project) {
        GradleUtil.addDependency((Project)project, (String)CONFIGURATION_NAME, (String)"com.google.template", (String)CONFIGURATION_NAME, (String)_VERSION);
    }

    protected BuildSoyTask addTaskBuildSoy(Project project) {
        final BuildSoyTask buildSoyTask = (BuildSoyTask)GradleUtil.addTask((Project)project, (String)BUILD_SOY_TASK_NAME, BuildSoyTask.class);
        buildSoyTask.setDescription("Compiles Closure Templates into JavaScript functions.");
        buildSoyTask.setGroup("build");
        buildSoyTask.setIncludes(Collections.singleton("**/*.soy"));
        PluginContainer pluginContainer = project.getPlugins();
        pluginContainer.withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                SoyPlugin.this.configureTaskBuildSoyForJavaPlugin(buildSoyTask);
            }
        });
        return buildSoyTask;
    }

    protected void configureTaskBuildSoyClasspath(BuildSoyTask buildSoyTask, FileCollection fileCollection) {
        buildSoyTask.setClasspath(fileCollection);
    }

    protected void configureTaskBuildSoyForJavaPlugin(final BuildSoyTask buildSoyTask) {
        buildSoyTask.setSource(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return SoyPlugin.this.getResourcesDir(buildSoyTask.getProject());
            }
        });
    }

    protected void configureTasksBuildSoy(Project project, final Configuration soyConfiguration) {
        TaskContainer taskContainer = project.getTasks();
        taskContainer.withType(BuildSoyTask.class, (Action)new Action<BuildSoyTask>(){

            public void execute(BuildSoyTask buildSoyTask) {
                SoyPlugin.this.configureTaskBuildSoyClasspath(buildSoyTask, (FileCollection)soyConfiguration);
            }
        });
    }

    protected File getResourcesDir(Project project) {
        SourceSet sourceSet = GradleUtil.getSourceSet((Project)project, (String)"main");
        return this.getSrcDir(sourceSet.getResources());
    }

    protected File getSrcDir(SourceDirectorySet sourceDirectorySet) {
        Set srcDirs = sourceDirectorySet.getSrcDirs();
        Iterator iterator = srcDirs.iterator();
        return (File)iterator.next();
    }
}

